<?php
// application/helpers/efactura_api.php
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

defined('BASEPATH') OR exit('No direct script access allowed');

class Efactura_api {
    private $apiBaseUrl = ANAF_API_URL;

    public function __construct() {
        $this->client = new Client();
    }

    private function getDefaultHeaders() {
        return [
            'x-api-key' => ANAF_API_KEY,
            'Accept' => 'application/json',
            'Content-Type'     => 'application/json',
        ];
    }

    public function makeGetApiCall($endpoint, $queryParams = [], $headers = []) {
        // Construct the full URL with the endpoint and query parameters
        $url = $this->apiBaseUrl . $endpoint;


        
    
        // Merge default headers with provided headers
        $allHeaders = array_merge($this->getDefaultHeaders(), $headers);
        

        try {

            // Make the GET request
            $response = $this->client->request('GET', $url.'?'. http_build_query($queryParams), [
                'headers' => $allHeaders,
            ]);

            // Return the decoded response body
            return $response->getBody()->getContents();
        } catch (\Exception $e) {
            // Handle errors as needed
            return ['error' => $e->getMessage()];
        }
    }

    public function makeApiCall($endpoint, $method = 'POST', $headers = [], $body = []) {
        $url = $this->apiBaseUrl . $endpoint;

        // Merge default headers with provided headers
        $allHeaders = array_merge($this->getDefaultHeaders(), $headers);

        try {
            $response = $this->client->request($method, $url, [
                'headers' => $allHeaders,
                'json' => $body,
            ]);

            return json_decode($response->getBody(), true);
        } catch (\Exception $e) {
            // Handle errors as needed
            return ['error' => $e->getMessage()];
        }
    }

    public function makeApiCallRaw($endpoint, $method = 'POST', $headers = [], $body = []) {
        $url = $this->apiBaseUrl . $endpoint;

        // Merge default headers with provided headers
        $allHeaders = array_merge($this->getDefaultHeaders(), $headers);

        try {
            $response = $this->client->request($method, $url, [
                'headers' => $allHeaders,
                'body' => $body,
            ]);

            return json_decode($response->getBody(), true);
        } catch (\Exception $e) {
            // Handle errors as needed
            return ['error' => $e->getMessage()];
        }
    }
}