<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Crm_invoice
{
  public function __construct($invoice, $tag = '')
  {
    /*
      $invoice                = hooks()->apply_filters('invoice_html_pdf_data', $invoice);
      $GLOBALS['invoice_pdf'] = $invoice;*/
      //parent::__construct();
      $this->ci =& get_instance();

      $this->tag            = $tag;
      $this->invoice        = $invoice;
      $this->invoice->doctitle = _l('invoice_doc_title');
      //Custom TMG - EDIConnect
      if(!empty($this->invoice->items)){
          foreach($this->invoice->items as $k=>$item_inv){
              $replaced_value = '';
              $inv_date = $this->invoice->date;

              if      (strpos($item_inv['description'], '[SAPTAMANA]') !== false) {
                  $replaced_value = _l('weeknumber') .' '. date("W", strtotime($inv_date));

                  $this->invoice->items[$k]['description']  = str_replace('[SAPTAMANA]',$replaced_value,$item_inv['description']);

              }else if (strpos($item_inv['description'], '[SAPTAMANA TRECUTA]') !== false) {
                  $replaced_value = _l('weeknumber') .' '. date('W', strtotime('-1 week', strtotime($inv_date)));

                  $this->invoice->items[$k]['description']  = str_replace('[SAPTAMANA TRECUTA]',$replaced_value,$item_inv['description']);

              }else if (strpos($item_inv['description'], '[SAPTAMANA URMATOARE]') !== false) {
                  $replaced_value = _l('weeknumber') .' '. date('W', strtotime('+1 week', strtotime($inv_date)));

                  $this->invoice->items[$k]['description']  = str_replace('[SAPTAMANA URMATOARE]',$replaced_value,$item_inv['description']);

              }else if (strpos($item_inv['description'], '[LUNA]') !== false) {
                  $replaced_value = ' '. date("M Y", strtotime($inv_date));

                  $this->invoice->items[$k]['description']  = str_replace('[LUNA]',$replaced_value,$item_inv['description']);

              }else if (strpos($item_inv['description'], '[LUNA VIITOARE]') !== false) {
                  $replaced_value = date("M Y",mktime(0,0,0,date("m", strtotime($inv_date))+1,1,date("Y", strtotime($inv_date))));

                  $this->invoice->items[$k]['description']  = str_replace('[LUNA VIITOARE]',$replaced_value,$item_inv['description']);

              }else if (strpos($item_inv['description'], '[LUNA TRECUTA]') !== false) {
                  $replaced_value = date("M Y",mktime(0,0,0,date("m", strtotime($inv_date))-1,1,date("Y", strtotime($inv_date))));

                  $this->invoice->items[$k]['description']  = str_replace('[LUNA TRECUTA]',$replaced_value,$item_inv['description']);

              }else if (strpos($item_inv['description'], '[AN]') !== false) {
                  $replaced_value = ' '. date("Y", strtotime($inv_date));

                  $this->invoice->items[$k]['description']  = str_replace('[AN]',$replaced_value,$item_inv['description']);

              }else if (strpos($item_inv['description'], '[ANUL TRECUT]') !== false) {
                  $replaced_value =  date('Y', strtotime('-1 year', strtotime($inv_date)));

                  $this->invoice->items[$k]['description']  = str_replace('[ANUL TRECUT]',$replaced_value,$item_inv['description']);

              }else if (strpos($item_inv['description'], '[ANUL URMATOR]') !== false) {
                  $replaced_value =  date('Y', strtotime('+1 year', strtotime($inv_date)));

                  $this->invoice->items[$k]['description']  = str_replace('[ANUL URMATOR]',$replaced_value,$item_inv['description']);

              }


              $this->invoice->items[$k]['tax_amount'] = 0;

              $invoice_item_taxes = get_invoice_item_taxes($item_inv['id']);
              //pre($invoice_item_taxes);
              if(!empty($invoice_item_taxes)){
                foreach($invoice_item_taxes as $tax){
                  if($tax['taxrate'] != 0){

                    $this->invoice->items[$k]['tax_amount'] += round(($tax['taxrate']/100)*($item_inv['price_converted']*$item_inv['qty']),4);
                  }
                }
              }



          }
      }


      $currencies = [];
      $display_currency = '';
      foreach($this->invoice->items as $k=>$item_inv ){
        if($item_inv['currency_name'] == $this->invoice->currency_name){ continue; }
        $currencies[$item_inv['currency_name'].'_'.$item_inv['currency_rate']] = '1 '.$item_inv['currency_name'].' = '.round($item_inv['currency_rate'],2).' '.$this->invoice->currency_name.'<br />';
      }
      if(!empty($currencies)){
        $display_currency = implode(' ',$currencies);
      }
      $this->invoice->display_currency = $display_currency;

      $this->invoice_number = format_invoice_number($this->invoice->id);


  }
  public function get_payment_modes()
  {
      $this->ci->load->model('payment_modes_model');
      $payment_modes = $this->ci->payment_modes_model->get();

      // In case user want to include {invoice_number} or {client_id} in PDF offline mode description
      foreach ($payment_modes as $key => $mode) {
          if (isset($mode['description'])) {
              $payment_modes[$key]['description'] = str_replace('{invoice_number}', $this->invoice_number, $mode['description']);
              $payment_modes[$key]['description'] = str_replace('{client_id}', $this->invoice->clientid, $mode['description']);
          }
      }

      return $payment_modes;
  }
  public function prepare_document(){
    $payment_modes = $this->get_payment_modes();
    $this->ci->load->model('invoices_model');
    $this->invoice->seria_settings = $this->ci->invoices_model->get_seria($this->invoice->prefix);


    $options['invoice_logo'] = get_option('invoice_logo');
    $options['invoice_bg'] = get_option('invoice_bg');
    $options['invoice_stamp'] = get_option('invoice_stamp');
    $options['invoice_settings'] = get_option('invoice_settings');
    $options['invoice_settings'] = json_decode($options['invoice_settings'],true);
    $this->invoice->options = $options;

    $this->invoice->payment_link = '';
    if ($this->invoice->status != Invoices_model::STATUS_PAID && $this->invoice->status != Invoices_model::STATUS_CANCELLED && get_option('show_pay_link_to_invoice_pdf') == 1
        && found_invoice_mode($payment_modes, $this->invoice->id, false)) {
        $this->invoice->payment_link = ' - <a href="' . site_url('invoice/' . $this->invoice->id . '/' . $this->invoice->hash) . '/." style="color:#84c529;text-decoration:none;text-transform:uppercase;"><b>' . _l('view_invoice_pdf_link_pay') . '</b></a>';
    }

    $this->invoice->logo = logo_url_v2();
    $this->invoice->logoUrl = logo_url_v2();

    if($options['invoice_logo']){
      $this->invoice->logoUrl = APP_BASE_URL.'uploads/company/'.$options['invoice_logo'];
    }

    $this->ci->load->model('clients_model');
    $this->ci->load->model('staff_model');

    $this->invoice->customer = $this->ci->clients_model->get($this->invoice->clientid);

    $this->invoice->account_man = [];
    $this->invoice->accounts_man = $this->ci->clients_model->get_admins($this->invoice->clientid);
    if(!empty($this->invoice->accounts_man)){
      foreach($this->invoice->accounts_man as $acc){
        $this->invoice->account_man = $this->ci->staff_model->get($acc); break;
      }
    }

    return $this->invoice;
  }



}
