<?php

	defined('BASEPATH') or exit('No direct script access allowed');

	class Billing_bank_model extends App_Model
	{

		public function __construct()
		{
			parent::__construct();
		}

		public function add($data = []) {
			$this->db->insert(db_prefix() . 'billing_bank', $data);
			$insert_id = $this->db->insert_id();

			if ($insert_id) {
				log_activity('New Bank Added [TYPE: ' . $data['iban'] . ' ]');

				return true;
			}
			return false;
		}

		public function get($id = false) {
			if (is_numeric($id)) {
				$this->db->select(db_prefix() . 'billing_bank.*, ' . db_prefix() . 'currencies.name AS currency_name');
				$this->db->from(db_prefix() . 'billing_bank');
				$this->db->join(db_prefix() . 'currencies', db_prefix() . 'currencies.id = ' . db_prefix() . 'billing_bank.currency_id', 'left');
				$billing_banks = $this->db->get()->row_array();
				return $billing_banks;
			}

			$billing_banks = $this->app_object_cache->get('billing-banks-data');

			if (!$billing_banks && !is_array($billing_banks)) {
				$this->db->select(db_prefix() . 'billing_bank.*, ' . db_prefix() . 'currencies.name AS currency_name');
				$this->db->from(db_prefix() . 'billing_bank');
				$this->db->join(db_prefix() . 'currencies', db_prefix() . 'currencies.id = ' . db_prefix() . 'billing_bank.currency_id', 'left');
				$billing_banks = $this->db->get()->result_array();
				$this->app_object_cache->add('billing-banks-data', $billing_banks);
			}

			return $billing_banks;

		}

		public function get_active($id = false) {
			if (is_numeric($id)) {

			}

			$billing_banks = $this->app_object_cache->get('billing-banks-data');

			if (!$billing_banks && !is_array($billing_banks)) {
				$this->db->select(db_prefix() . 'billing_bank.*, ' . db_prefix() . 'currencies.name AS currency_name');
				$this->db->from(db_prefix() . 'billing_bank');
				$this->db->join(db_prefix() . 'currencies', db_prefix() . 'currencies.id = ' . db_prefix() . 'billing_bank.currency_id', 'left');
				$this->db->where('status',1);
				$billing_banks = $this->db->get()->result_array();
				$this->app_object_cache->add('billing-banks-data', $billing_banks);
			}

			return $billing_banks;

		}


		public function update($id, $data = []) {
			$this->db->where('id', $id);
			$this->db->update(db_prefix() . 'billing_bank', $data);
			if ($this->db->affected_rows() > 0) {
				log_activity('Bank Updated [' . $id . ']');

				return true;
			}

			return false;
		}

	}
