<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Billing_notification_model extends App_Model
{
  public $table_name = '';

  public function __construct()
  {
    parent::__construct();
    $this->table_name = db_prefix().'billing_notifications';
  }


  public function add($data = [])
  {

    $this->db->insert($this->table_name, $data);
    $insert_id = $this->db->insert_id();

    if ($insert_id) {
      log_activity('Setting  Changed [Series: ' . $data['id'] .  '  ]');

      return $insert_id;
    }

    return false;
  }

  public function get($id = false)
  {
    
    if (is_numeric($id)) {
      $this->db->where('id', $id);

      $notification = $this->db->get($this->table_name)->row();

      return $notification;
    }

    $billing_notifications = $this->app_object_cache->get('billing-notification-data');

    if (!$billing_notifications && !is_array($billing_notifications)) {
      $billing_notifications = $this->db->get($this->table_name)->result_array();
      $this->app_object_cache->add('billing-notification-data', $billing_notifications);
    }

    return $billing_notifications;
  }

  public function update($id, $data = []) {

    $this->db->where('id', $id);

    $this->db->update($this->table_name, $data);

    if ($this->db->affected_rows() > 0) {
      log_activity('Setting Updated [' . $id . ']');
    }

    return $this->get($id);
  }

}

?>
