<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Billing_series_model extends App_Model
{

  public function __construct()
  {
    parent::__construct();
    $this->load->model('billing/billing_template_model');
  }

  public function check($data = [])
  {

    $this->db->select('id');
    $this->db->where('type', $data['type']);
    $this->db->where('name', $data['name']);

    return $this->db->get(db_prefix() . 'billing_series')->num_rows();
  }

  public function add($data = [])
  {

    if(!isset($data['current_number'])){
      $data['current_number'] =  $data['start_number'];
      if($data['start_number'] > 0){
        $data['current_number'] = $data['start_number'] - 1;
      }
    }
    $this->db->insert(db_prefix() . 'billing_series', $data);
    $insert_id = $this->db->insert_id();

    if ($insert_id) {
      log_activity('New Series Added [TYPE: ' . $data['type'] . ' Series: ' . $data['name'] . '  ]');

      /**
       * Condition added since has been problems loading this from instance
       * as it was written
       */
      if ($this->load->is_loaded('billing/billing_template_model')) {
        $exist = $this->billing_template_model->getBySeries($insert_id);
        if(!$exist){
          $parameter = $this->billing_template_model->get_default_data();
          $parameter['billing_series_id'] = $insert_id;
          $this->billing_template_model->add($parameter);
        } 
      }

      return true;
    }

    return false;
  }

  public function get($id = false)
  {
    if (is_numeric($id)) {
      $this->db->where('id', $id);

      $billing_serie = $this->db->get(db_prefix() . 'billing_series')->row();

      return $billing_serie;
    }

    $billing_series = $this->app_object_cache->get('billing-series-data');

    if (!$billing_series && !is_array($billing_series)) {
      $billing_series = $this->db->order_by('type','ASC')->order_by('id','DESC')->get(db_prefix() . 'billing_series')->result_array();
      $this->app_object_cache->add('billing-series-data', $billing_series);
    }

    return $billing_series;
  }
  public function get_customizable_doc(){
    $docs = $this->app_object_cache->get('billing-customizable-docs');

    if (!$docs) {
      $docs = $this->db->select('*')->from('billing_series')->where_in('type',['invoice','proforma'])->order_by('type','ASC')->order_by('name','ASC')->get()->result_array();
      $this->app_object_cache->add('billing-customizable-docs', $docs);
    }

    return $docs;
  }

  public function getByType($type = 'invoice')
  {
    $this->db->where('type', $type);

    $billing_serie = $this->db->get(db_prefix() . 'billing_series')->result_array();

    return $billing_serie;
  }

  public function get_series_type()
  {
    return [
      'invoice' => _l('billing_config_invoice'),
      'proforma' => _l('billing_config_proforma'),
      //'credit_note' => _l('billing_config_credit_note'),
      'advice'  => _l('billing_config_advice'),
      'receipt' => _l('billing_config_receipt'),
      'cash_receipt' => _l('billing_config_cash_receipt'),      
      'estimate' => _l('billing_config_estimate'),
      'proposal' => _l('billing_config_proposal'),

    ];
  }

  public function update($id, $data = []) {

    $this->db->where('id', $id);
    $this->db->update(db_prefix() . 'billing_series', $data);
    if ($this->db->affected_rows() > 0) {
      log_activity('Seria Updated [' . $id . ']');

      return true;
    }

    return false;
  }


    /**
     * Delete series from database
     * @param  mixed   $id serie id
     * @return boolean
     */
    public function delete($id)
    {
        $current         = $this->get($id);

        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'billing_series');
        if ($this->db->affected_rows() > 0) {
            log_activity('Serie Deleted [ID:' . $id . ', Serie Number: ' . format_invoice_number($current->name) . ']');
            return true;
        }
        return false;
    }
}
?>
