<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Billing_template_model extends App_Model
{

  public static $params = ['template', 'color', 'format', 'stamp', 'is_stamp_text', 'billing_series_id'];

  public function __construct()
  {
    parent::__construct();
  }


  public function add($data = [])
  {

    $this->db->insert(db_prefix() . 'billing_template', $data);
    $insert_id = $this->db->insert_id();

    if ($insert_id) {
      log_activity('Template  Changed [Series: ' . $data['billing_series_id'] .  '  ]');

      return $insert_id;
    }

    return false;
  }

  public function get($id = false)
  {

    if (is_numeric($id)) {
      $this->db->where('id', $id);

      $template = $this->db->get(db_prefix() . 'billing_template')->row();

      return $template;
    }

    $billing_templates = $this->app_object_cache->get('billing-template-data');

    if (!$billing_templates && !is_array($billing_templates)) {
      $billing_templates = $this->db->get(db_prefix() . 'billing_template')->result_array();
      $this->app_object_cache->add('billing-template-data', $billing_templates);
    }

    return $billing_templates;
  }


  public function getBySeries($id = false)
  {
    $id = (int) $id;
    $this->db->where('billing_series_id', $id);

    return $this->db->get(db_prefix() . 'billing_template')->row();
  }



  public function update($id, $data = []) {
    $data['is_stamp_text'] = !isset($data['is_stamp_text']) ? 0 : (int)$data['is_stamp_text'];

    $this->db->where('id', $id);
    $this->db->update(db_prefix() . 'billing_template', $data);

    if ($this->db->affected_rows() > 0) {
      log_activity('Template Updated [' . $id . ']');
    }

    return $this->get($id);
  }

  public function get_default_data()
  {
    return [
      'template' => 'v2',
      'color'  => '#3D6B86',
      'format' => 'A4',
      'logo' => null,
      'stamp' => null,
      'is_stamp_text' => 0,
    ];
  }
  public function get_default_data_old()
  {
    return [
      'template' => 1,
      'color'  => '#3D6B86',
      'format' => 'A4',
      'logo' => null,
      'stamp' => null,
      'is_stamp_text' => 0,
    ];
  }

  public function get_template_default_data()
  {
    return [
      'v2' => site_url('modules/billing/img/model1.png'),
    /*  2 => site_url('modules/billing/img/model2.png'),
      3 => site_url('modules/billing/img/model3.png'),
      4 => site_url('modules/billing/img/model4.png'),*/
    ];
  }
  public function get_template_default_data_old()
  {
    return [
      1 => site_url('modules/billing/img/model1.png'),
    /*  2 => site_url('modules/billing/img/model2.png'),
      3 => site_url('modules/billing/img/model3.png'),
      4 => site_url('modules/billing/img/model4.png'),*/
    ];
  }

  public function get_format_default_data()
  {
    return [
      'A4' => site_url('modules/billing/img/11-factura.png'),
      /*'A5' => site_url('modules/billing/img/22-factura.png'),
      'A4-2' => site_url('modules/billing/img/33-factura.png'),
      'A4-3' => site_url('modules/billing/img/44-factura.png'),*/
    ];
  }

  public function get_color_default_data()
  {
    return ['#3D6B86', '#E58B00', '#36A7EB', '#A7127B', '#4B8B4A', '#B82D2D', '#2CA70F'];
  }
}

?>
