<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
	<div class="d-block ht-1"></div>
	<div class="content">
		<div class="panel_s mg-t-15">
			<div class="panel-body">
                <?php echo $this->load->view('config/partials/header_config', [], true);
				?>
				<?php echo form_open('admin/billing/config/bank/',array('id'=>'billing_bank_form')); ?>
					<div class="row d-flex">
						<div class="col-md-2 d-flex">
							<div class="form-group-flex">
								<label for="input-iban" class="form-control-label"><?php echo _l('billing_config_iban'); ?><span class="text-danger">*</span></label>
								<input type="text" name="iban" value="" class="form-control" id="input-iban" required>
							</div>
						</div>
						<div class="col-md-2 d-flex">
							<div class="form-group-flex">
								<label for="input-bank" class="form-control-label"><?php echo _l('billing_config_bank'); ?><span class="text-danger">*</span></label>
								<input type="text" name="name" value="" class="form-control" id="input-bank" required>
							</div>
						</div>
						<div class="col-md-2 d-flex">
							<div class="form-group-flex">
								<label id="input-currency" class="form-control-label"><?php echo _l('billing_config_currency'); ?><span class="text-danger">*</span></label>
								<select name="currency_id" id="input-currency" class="form-control" required>
								<?php foreach ($currencies as $currency): ?>
									<option value="<?php echo $currency['id']; ?>" <?php if ($currency['isdefault']) echo 'selected'; ?>><?php echo $currency['name']; ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>
						<div class="col-md-2 d-flex">
							<div class="form-group-flex">
								<label for="input-swift" class="form-control-label"><?php echo _l('billing_config_swift'); ?></label>
								<input type="text" name="swift" value="" class="form-control" id="input-swift">
							</div>
						</div>
						<div class="col-md-2 d-flex">
							<div class="form-group-flex">
								<label for="input-description" class="form-control-label"><?php echo _l('billing_config_description'); ?></label>
								<input type="text" name="description" id="input-description" cols="30" rows="1"  class="form-control">
							</div>
						</div>
						<div class="col-md-2 d-flex">
							<div class="form-group-flex">
								<label for="" class="form-control-label">&nbsp;</label>
								<button class="btn btn-primary m-0 d-block"> <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php /* INACTIVE: echo _l('billing_config_add'); */ ?></button>
							</div>
						</div>
					</div>
				<?php echo form_close(); ?>
				
				<table class="table table-striped">
					<thead class="thead-colored thead-dark">
					<tr>
						<th><?php echo _l('billing_config_iban'); ?></th>
						<th><?php echo _l('billing_config_bank'); ?></th>
						<th><?php echo _l('billing_config_currency'); ?></th>
						<th><?php echo _l('billing_config_swift'); ?></th>
						<th><?php echo _l('billing_config_description'); ?></th>
						<th><?php echo _l('billing_config_status'); ?></th>
						<th><?php echo _l('billing_config_action'); ?></th>
					</tr>
					</thead>
					<tbody>
					<?php foreach ($billing_banks as $billing_bank): ?>
					<tr>
						<td><?php echo $billing_bank['iban']; ?></td>
						<td><?php echo $billing_bank['name']; ?></td>
						<td><?php echo $billing_bank['currency_name']; ?></td>
						<td><?php echo $billing_bank['swift']; ?></td>
						<td><?php echo $billing_bank['description']; ?></td>
						<td>
							<div class="onoffswitch">
                                <input type="checkbox" name="status" data-id="<?php echo $billing_bank['id']; ?>" id="<?php echo $billing_bank['id']; ?>" <?php if ($billing_bank['status']) echo 'checked'; ?> value="1" class="onoffswitch-checkbox" xdata-switch-url="<?php echo admin_url(); ?>misc/toggle_file_visibility">
                                <label class="onoffswitch-label" for="<?php echo $billing_bank['id']; ?>"></label>
                            </div>
						
							<?php /*<input type="checkbox" name="status" data-id="<?php echo $billing_bank['id']; ?>" <?php if ($billing_bank['status']) echo 'checked'; ?> value="1"> */ ?>
						</td>
						<td>
							<button class="btn btn-primary btn-rounded btn-xs mtop10 pull-right" onclick="editBankAcc(<?php echo $billing_bank['id']; ?>)"><i class="fas fa-pencil"></i></button>
							<button class="btn btn-danger btn-rounded btn-xs mtop10 pull-right" onclick="deleteBankAcc(<?php echo $billing_bank['id']; ?>)"><i class="fas fa-trash"></i></button>
						</td>
					</tr>
					<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php show_footer(); ?><?php init_tail(); ?>

<script type="text/javascript">
$('body').on('click', 'input[name="status"]', function () {
	  var bank_id = $(this).data('id');
	  if ($(this).is(":checked")) {
      var bank_status = 1;
		} else {
      var bank_status = 0;
		}

		$.ajax({
			method: 'post',
			url: '<?php echo admin_url('billing/config/bank/'); ?>',
			dataType: 'json',
			data: {
				id: bank_id,
				status: bank_status
			},
			success: function (json) {
				if (json.success) {
				alert_float('success', json.message);
				window.location.href = site_url + '/admin/billing/config/bank';
				}
			}
		})
  });


  function getFormData($form){
    var unindexed_array = $form.serializeArray();
    var indexed_array = {};

    $.map(unindexed_array, function(n, i){
        indexed_array[n['name']] = n['value'];
    });

    return indexed_array;
}


	function editBankAcc(bank_id){
		fetch(site_url+'/admin/billing/config/bank_edit/'+bank_id).
            then(response => response.text()).
            then(function(data){
              var response = JSON.parse(data);
			  console.log(response);
              Swal.fire({
                title: 'Modificare cont bancar',
                grow: 'fullscreen',
                html: response.html_output,
                showCancelButton: true,
              }, 

            ).then(function(isConfirm){  
               
                    if(isConfirm.value){
					   var $form = $("#billing_bank_edit");
						var posted = getFormData($form);
						console.log(posted);
						$.ajax({
							method: 'post',
							url: '<?php echo admin_url('billing/config/bank/'); ?>',
							dataType: 'json',
							data: {
								id: bank_id,
								iban: posted.iban
							},
							success: function (json) {
								if (json.success) {
									alert_float('success', json.message);
								}
							},
							error: function() {
								alert_float('danger', json.message);

							}
						})


                    }
                    else if(isConfirm.dismiss){
                        //Lobibox.notify('info', { msg: 'Canceled.' });
                    }
             });//end the isConfirm
			 
        });




		
	}
	function deleteBankAcc(bank_id){
		$.ajax({
			method: 'post',
			url: '<?php echo admin_url('billing/config/bank_delete/'); ?>',
			dataType: 'json',
			data: {
				id: bank_id
			},
			success: function (json) {
				if (json.success) {
					alert_float('success', json.message);
					window.location.href = site_url + '/admin/billing/config/bank';
				}
			}
		})
	}

</script>

</body>
</html>
