<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
  <div class="d-block ht-1"></div>
  <div class="content">
    <div class="panel_s mg-t-15">
      <div class="panel-body">
      <?php echo $this->load->view('config/partials/header_config', [], true); ?>
        <p><?php echo _l('billing_email_info')?></p>
        <?php echo form_open('admin/billing/config/email/', ['id' => 'billing_notification_form']); ?>
        <div class="row">
          <div class="col-md-8">
            <?php echo render_input('settings[billing_email_subject]', 'subject', get_option('billing_email_subject')); ?>
            <?php echo render_textarea('settings[billing_email_message]', 'message', get_option('billing_email_message')); ?>
          </div>
          <div class="col-md-4">
            <p><?php echo _l('billing_info_tag')?>Personalizeaza mesajul cu date preluate automat de pe documente folosind termeni variabili.</p>

            <div class="form-group">
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#tip_document#"><?php echo _l('billing_type_document')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#link_document#"><?php echo _l('billing_link_document')?></button>
            </div>
            <div class="form-group">
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#numar_document#"><?php echo _l('billing_number_document')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#total#"><?php echo _l('billing_total_document')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#data_emiterii#"><?php echo _l('billing_creation_date_document')?></button>
            </div>
            <div class="form-group">
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#data_scadentei#"><?php echo _l('billing_due_date_document')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#mentiuni#"><?php echo _l('billing_mentiuni_document')?></button>
            </div>
            <div class="form-group">
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#nume_client#"><?php echo _l('billing_client_name')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#contact_client#"><?php echo _l('billing_client_contact')?></button>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col">
            <h4 class="tx-dark"><?php echo _l('billing_server_email')?></h4>
            <p><?php echo _l('billing_info_server_email')?></p>
            <label class="ckbox ckbox-info mg-b-25">
              <input type="checkbox" name="settings[use_my_billing_server_email]"
                     value="1" <?php echo get_option('use_my_billing_server_email') ? 'checked' : '' ?>>
              <span><?php echo _l('billing_ask_server_email')?></span>
            </label>
            <div class="smt_info" style="<?php echo get_option('use_my_billing_server_email') ? '' : 'display:none;' ?>">
              <?php echo render_input('settings[billing_email_user]', 'username', get_option('billing_email_user')); ?>
              <?php echo render_input('settings[billing_email_password]', 'password', get_option('billing_email_password')); ?>
              <?php echo render_input('settings[billing_email_smtp]', 'smtp', get_option('billing_email_smtp')); ?>
              <?php echo render_input('settings[billing_email_port]', 'port', get_option('billing_email_port')); ?>
              <label class="ckbox ckbox-info mg-b-25">
                <input type="checkbox" name="settings[billing_email_tls]" value="1" <?php echo get_option('billing_email_tls') ? 'checked' : '' ?>>
                <span>TLS</span>
              </label>
            </div>
          </div>
        </div>

        <div class="row mg-t-20">
          <div class="col-md-2">
            <button type="submit" class="btn btn-primary btn-block"><?php echo _l('billing_save') ?></button>
          </div>
        </div>
        <?php echo form_close(); ?>
      </div>
    </div>
  </div>
</div>

<?php show_footer(); ?><?php init_tail(); ?>
<script src="<?php echo site_url('modules/billing/assets/js/scripts.js'); ?>"></script>
<script>

  $(document).on('click', '.btn_add_tag_message', function (event) {
    event.preventDefault();
    var tag      = $(this).data('tag'),
        $txt     = $('textarea[name="settings[billing_email_message]"]'),
        position = $txt[0].selectionStart,
        text     = $txt.val();

    $txt.val(text.substring(0, position) + tag + text.substring(position));
  });

  $(document).on('change', 'input[name="settings[use_my_billing_server_email]"]', function (event) {
    event.preventDefault();
    $('.smt_info').hide();
    if ($(this)[0].checked){
      $('.smt_info').show();
    }
  });

</script>
</body>
</html>
