<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
  <div class="d-block ht-1"></div>
  <div class="content">
    <div class="panel_s mg-t-15">
      <div class="panel-body">
          <?php echo $this->load->view('config/partials/header_config', [], true); ?>
        <p><?php echo _l('billing_notification_info')?></p>
        <hr>
        <? $i = 1; ?>
        <?php foreach ($notifications as $index => $notification) : ?>
          <div class="row">
            <div class="col-md-7">
              <p>
                <?php echo $index + 1 ?> <?php echo _l('billing_notificate')?>
                <?php if (!$notification['active']) : ?>
                  <span class="badge badge-secondary"><?php echo _l('billing_deactivate')?></span>
                <?php endif ?>
                <br>
                <?php echo sprintf($this->lang->line('billing_info_notice'), $notification['days'], ($notification['type'] === 'before' ? _l('billing_notice_before') : _l('billing_notice_after')))?>
                <br>
                CC: <?php echo $notification['cc'] ?>
              </p>
            </div>
            <div class="col-md-5">
              <button type="button" class="btn btn-outline-secondary btn_edit_notification" data-index="<?php echo $index ?>"><i class="fal fa-edit fa-fw"></i>
              </button>
              <a href="<?php echo admin_url('billing/config/toggleNotification/' . $notification['id'] . '/' . !$notification['active']) ?>" type="button"
                 class="btn btn-<?php echo $notification['active'] ? 'danger' : 'success' ?>"><i
                    class="fal fa-<?php echo $notification['active'] ? 'times' : 'check' ?> fa-fw"></i></a>
            </div>
          </div>
          <hr>
        <?php endforeach ?>
        <div class="alert alert-info">
          <?php echo _l('billing_notification_alert')?>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal" id="modal_edit_notification" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><?php echo _l('billing_edit_notification')?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?php echo form_open('admin/billing/config/saveNotification/', ['id' => 'billing_notification_form']); ?>
        <input type="hidden" name="id" value="0">
        <div class="row">
          <div class="col-md-8">
            <div class="row">
              <div class="col">
                <?php echo render_input('days', 'days', ''); ?>
              </div>
              <div class="col">
                <?php echo render_select('type', [['id' => 'before', 'name' => 'Inainte de data scadentei'], ['id' => 'after', 'name' => 'Dupa data scadentei']],
                  ['id', ['name']], 'hr_employee', 'before'); ?>
              </div>
            </div>
            <?php echo render_input('subject', 'subject', ''); ?>
            <?php echo render_textarea('message', 'message', ''); ?>
            <?php echo render_input('fullname', 'from', ''); ?>
            <?php echo render_input('cc', 'cc', ''); ?>
            <?php echo render_input('bcc', 'bcc', ''); ?>
          </div>
          <div class="col-md-4">

            <p><?php echo _l('billing_info_tag')?></p>

            <div class="form-group">
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#numar_document#"><?php echo _l('billing_number_document')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#link_document#"><?php echo _l('billing_link_document')?></button>
            </div>
            <div class="form-group">
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#total#"><?php echo _l('billing_total_document')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#rest_plata#"><?php echo _l('billing_rest_pay_document')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#numar_zile#"><?php echo _l('billing_number_days')?></button>
            </div>
            <div class="form-group">
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#nume_client#"><?php echo _l('billing_client_name')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#contact_client#"><?php echo _l('billing_client_contact')?></button>
            </div>
            <div class="form-group">
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#data_scadentei#"><?php echo _l('billing_due_date_document')?></button>
              <button class="btn btn-sm btn-outline-secondary mg-r-5 btn_add_tag_message" data-tag="#data_emiterii#"><?php echo _l('billing_creation_date_document')?></button>
            </div>
          </div>
        </div>
        <?php echo form_close(); ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo _l('close') ?></button>
        <button type="button" class="btn btn-primary btn_save_notification" data-loading-text="<i class='fa fa-spinner fa-spin'></i>"><?php echo _l('save') ?></button>
      </div>
    </div>
  </div>
</div>

<?php show_footer(); ?><?php init_tail(); ?>
<script src="<?php echo site_url('modules/billing/assets/js/scripts.js'); ?>"></script>
<script>
  var notifications = <?php echo json_encode($notifications)?>;

  $(document).on('click', '.btn_edit_notification', function (event) {
    var notification = notifications[parseInt($(this).data('index'))];
    $('input[name="days"]').val(notification.days);
    $('input[name="id"]').val(notification.id);
    $('select[name="type"]').selectpicker('val', notification.type);
    $('input[name="subject"]').val(notification.subject);
    $('input[name="fullname"]').val(notification.fullname);
    $('input[name="cc"]').val(notification.cc);
    $('input[name="bcc"]').val(notification.bcc);
    $('textarea[name="message"]').val(notification.message);
    $('#modal_edit_notification').modal('show');
  });

  $('#modal_edit_notification').on('hidden.bs.modal', function (e) {
    $('input[name="id"]').val(0);
  })

  $(document).on('click', '.btn_add_tag_message', function (event) {
    event.preventDefault();
    var tag = $(this).data('tag'),
        $txt = $('textarea[name="message"]'),
        position = $txt[0].selectionStart,
        text = $txt.val();

    $txt.val(text.substring(0, position) + tag + text.substring(position) );
  });

  $(document).on('click', '.btn_save_notification', function (event) {
    var $btn = $(this).button('loading');
    $('#billing_notification_form').submit();
  });

</script>
</body>
</html>
