<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
	<div class="d-block ht-1"></div>
	<div class="content">
		<div class="panel_s mg-t-15">
			<div class="panel-body">
                <?php echo $this->load->view('config/partials/header_config', [], true); ?>
				<?php echo form_open('admin/billing/config/series/',array('id'=>'billing_series_form')); ?>
					<div class="row" style="display: flex;flex-direction: row;flex-wrap: nowrap;justify-content: flex-end;align-items: flex-end;align-content: flex-end">
						<div class="col-md-2">
							<div class="form-group">
								<label for="input-type" class="form-control-label"><?php echo _l('billing_config_type'); ?></label>
								<select name="type" id="input-type" class="form-control" required>
                  						<?php foreach ($series_type as $key => $value) : ?>
									  <option value="<?php echo $key?>"><?php echo $value; ?></option>
                  						<?php endforeach ?>
								</select>
							</div>
						</div>
						<div class="col-md-2">
							<div class="form-group">
								<label for="input-name" class="form-control-label"><?php echo _l('billing_config_series_name'); ?></label>
								<input type="text" name="name" value="" class="form-control" id="input-name" required>
							</div>
						</div>
						<div class="col-md-2">
							<div class="form-group">
								<label for="input-number" class="form-control-label"><?php echo _l('billing_config_first_number'); ?></label>
								<input type="number" name="start_number" value="1" class="form-control" id="input-number" required>
							</div>
						</div>
						<?php /*<div class="col-md-2">
							<div class="form-group">
								<label for="input-number" class="form-control-label"><?php echo _l('billing_config_current_number'); ?></label>
								<input type="number" name="current_number" value="0" class="form-control" id="current-number" required>
							</div>
						</div>*/ ?>
						<div class="col-md-4">
							<div class="form-group">
								<label for="input-description" class="form-control-label"><?php echo _l('billing_config_description'); ?></label>
								<input type="text" name="description" value="" class="form-control" id="input-description">
							</div>
						</div>


						<div class="col-md-2 p-0">
							<div class="form-group">
								<button class="btn btn-primary d-block m-0"> <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE: echo _l('billing_config_add')' ?></button>
							</div>
						</div>

				
					</div>
				<?php echo form_close(); ?>
				<table class="table table-striped">
					<thead class="thead-colored thead-dark">
					<tr>
						<th><?php echo _l('billing_config_type'); ?></th>
						<th><?php echo _l('billing_config_series_name'); ?></th>
						<th><?php echo _l('billing_config_first_number'); ?></th>
						<th><?php echo _l('billing_config_current_number'); ?></th>
						<th><?php echo _l('billing_config_default'); ?></th>
						<th><?php echo _l('billing_config_description'); ?></th>
						<th><?php echo _l('billing_config_delete_columnname'); ?></th>
					</tr>
					</thead>
					<tbody>
          <?php foreach ($billing_series as $billing_serie): ?>
            <tr>
              <td><?php echo _l('billing_config_' . $billing_serie['type']); ?></td>
              <td><?php echo $billing_serie['name'] ?></td>
              <td><?php echo $billing_serie['start_number'] ?></td>
              <td><?php echo $billing_serie['current_number'] ?></td>
              <td><input type="checkbox" name="default" data-id="<?php echo $billing_serie['id']; ?>" value="1" <?php if ($billing_serie['default']) echo 'checked'; ?>></td>
			  <td><?php echo $billing_serie['description'] ?></td>
			  <td>
				  <button class="btn btn-danger btn-rounded btn-xs mtop10 pull-right" onclick="deleteSerie(<?php echo $billing_serie['id']; ?>)"><i class="fas fa-trash"></i></button>
			  </td>
            </tr>
          <?php endforeach; ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php show_footer(); ?><?php init_tail(); ?>
<script type="text/javascript">

	$('body').on('click', 'input[name="default"]', function () {
	  var series_id = $(this).data('id');
	  if ($(this).is(":checked")) {
      var default_status = 1;
		} else {
      var default_status = 0;
		}

		$.ajax({
			method: 'post',
			url: '<?php echo admin_url('billing/config/series/'); ?>',
			dataType: 'json',
			data: {
				id: series_id,
				status: default_status
			},
			success: function (json) {
        if (json.success) {
          alert_float('success', json.message);
					location.reload();
					
        }
      }
		})
  });

  function deleteSerie(serie_id){
		$.ajax({
			method: 'post',
			url: '<?php echo admin_url('billing/config/deleteseries/'); ?>',
			dataType: 'json',
			data: {
				id: serie_id
			},
			success: function (json) {
				if (json.success) {
					alert_float('success', json.message);
					window.location.href = site_url + '/admin/billing/config/series';
				}
				if (json.error) {
					alert_float('danger', json.message);
				}
			}
		})
	}
</script>
</body>
</html>
