<html style="padding:0;margin:0;">
<head>
    <style type="text/css">
        @page {
            margin: 0px;
            padding: 0px;
            margin-header: 0;
            margin-footer: 5mm;
            footer: html_invFooter;
            header: html_invHeader;
            <?php if($invoice->options['invoice_bg'] AND (int)$invoice->options['invoice_settings']['view_background'] == 1){ ?>
            background: url(<?php echo APP_BASE_URL.'/uploads/company/'.$invoice->options['invoice_bg']; ?>) no-repeat 0 0;
            background-image-resize: 6;
            <?php } ?>
        }
        .invoiceH1 { font-weight: 500; margin-bottom: 0; font-size: 22px; color: #535353; line-height: 1.2; }

        .inv-title-1 { /*font-weight: 500; */ font-size: 14px; color: #535353; text-transform: initial !important; font-weight: bold; margin-bottom: 0.5rem; }

        .inv-from-1 {color: #535353; font-size: 12px;}
        .divHeader2 { font-weight: 400; line-height: 1.5; color: #535353; font-size: 14px; box-sizing: border-box; max-width: 100%; background: #fbf8f8;}
        .divHeaderH2 { line-height: 1.2; color: #535353; margin-bottom: 0; font-weight: 500; font-size: 18px; }        
        .tableHeader2Td { width: 50%; height: 50px; background: #fbf8f8; /*border-bottom: 1px solid #98e2ba;*/ }            
        .tableItemTh { color: #535353; font-size: 10px; text-transform: initial !important; box-sizing: border-box; font-weight: bold; padding: 8px 4px; vertical-align: top; border-top: 1px solid #bbb; border-bottom: 1px solid #bbb; text-align: center; border-spacing: 0px; }
        .tableItemTd { color: #535353; font-size: 12px; text-transform: initial !important; box-sizing: border-box; font-weight: 400; padding: 8px 8px; vertical-align: top; text-align: center; border-spacing: 0px; }
        .tableItemBottomTh { color: #535353; font-size: 15px; text-transform: initial !important; box-sizing: border-box; font-weight: 500; padding: 13px 20px; vertical-align: top; text-align: center; border-spacing: 0px; }
        .bb{ border-bottom: 1px solid #bbb; } 
        .tableItemLeftTh, { border-left: 1px solid #bbb; } 
        .tableItemRightTh, { border-right: 1px solid #bbb; } 
        .tableItemTopTh{ border-top: 1px solid #bbb; } 
        .tableBlock { width: 100%; border-spacing: 0px; border-collapse: collapse; } 
        .p { font-size: 10px; color: #535353; line-height: 1.2; } 
        .tableInfoTdleft { padding-left: 25px; padding-right: 5px; vertical-align: top; } 
        .tableInfoTdRight { padding-right: 25px; padding-left: 5px; vertical-align: top; } 
        .tableInfoTdCenter { vertical-align: middle; } 
        .invo-addr-1 { font-size: 15px; color: #535353; }
        .bank-transfer-list-1 { font-size: 13px !important; padding-left: 0px; color: #535353; } 
        .footer-text{font-size:12px;color: #535353;} 
        .invoice-logo{max-height: 90px;} 
        .b{ border:1px solid #bbb; } 
        .box{ padding: 6px; width:100% } .mb-2{ margin-bottom: 20px; }

        .table-description span{font-size:8px!important;}
    </style>
</head>

<body style="font-family: 'Poppins', sans-serif; padding: 0cm;">


<div style="padding-left: 10px;padding-right: 10px;padding-top:0px;height:14cm" >
    <table border="0" width="100%" style="border-spacing: 0px;border-collapse: collapse; z-index: 99999999">
        <thead>
        <tr>
            <th class="tableItemTh tableItemLeftTh" style="height:1cm;">#</th>
            <th class="tableItemTh "><?php echo _l('inv_item_description'); ?></th>
            <th class="tableItemTh "><?= _l('inv_item_unit'); ?></th>
            <th class="tableItemTh "><?php echo _l('inv_item_quantity'); ?></th>
            <th class="tableItemTh "><?php echo _l('inv_item_price'); ?>
                <br><span>(<?= $invoice->currency_name; ?> <?= _l('invoice_doc_vat_col'); ?>)</span></th>
            <th class="tableItemTh <?= (($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) ? '' : 'tableItemRightTh' ) ?>"><?php echo _l('inv_item_line_total'); ?>
                <br><span>(<?= $invoice->currency_name; ?> <?= _l('inv_line_amount'); ?>)
            </th>
			<?php if ($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) { ?>
                <th class="tableItemTh tableItemRightTh"><?php echo _l('inv_item_tax'); ?>
                    <br><span>(<?= $invoice->currency_name; ?>)</th>
			<?php } ?>

        </tr>
        </thead>
        <tbody>
		<?php
		$k = 1; $lines = 0;
		if ( ! empty($invoice->items))
		{
			foreach ($invoice->items as $k => $item)
			{
                $lines ++;
				?>
                <tr>
                    <td class="tableItemTd tableItemLeftTh"><?= $k + 1; ?></td>
                    <td class="tableItemTd table-description" align="left">
						<span><?php if ( ! empty($item['sku'])) { ?>
							<?= $item['sku']; ?> - 
						<?php } ?>
                        <?= $item['description']; ?></span>
                    </td>
                    <td class="tableItemTd"><?= $item['unit']; ?></td>
                    <td class="tableItemTd"><?= $item['qty']; ?></td>
                    <td class="tableItemTd"><?= round($item['rate'], 4);
						if ($item['price_converted'] != 0 AND $item['price_converted'] != '' AND (float)$item['price_converted'] != (float)$item['rate'])
						{
							/*echo '<br><span style="font-size:8px;">('.round($item['price_converted'],
									2).' '.$item['currency_name'].')</span>';*/
						} ?>
                    </td>
                    <td class="tableItemTd <?= (($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) ? '' : 'tableItemRightTh' ) ?>"><?= round($item['qty'] * $item['rate'], 4); ?></td>
					<?php if ($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) { ?>
                        <td class="tableItemTd tableItemRightTh">
							<?php
							echo round($item['tax_amount'], 4);
							?>
                        </td>
					<?php } ?>
                </tr>
				<?php
			}

            $page_lines = 14;
            while($lines < $page_lines){
                $lines++;
                ?>
                <tr>
                    <td class="tableItemTd tableItemLeftTh" style="height:1cm;"></td>
                    <td class="tableItemTd table-description" align="left"></td>
                    <td class="tableItemTd"></td>
                    <td class="tableItemTd"></td>
                    <td class="tableItemTd"></td>
                    <td class="tableItemTd tableItemRightTh"></td>
                </tr>
				<?php
            }
			$k = 1;
		}
		?>
        </tbody>
    </table>

</div>
<div style="padding-left: 10px;padding-right: 10px;padding-top:0px;height:3cm" >


    <table border="0" width="100%" style="border-spacing: 0px;border-collapse: collapse; z-index: 99999999">
        <tbody>
        <tr>
            <th class="tableItemBottomTh X-tableItemLeftTh tableItemTopTh"></th>
            <th class="tableItemBottomTh tableItemTopTh"></th>
            <th class="tableItemBottomTh tableItemTopTh"></th>
            <th class="tableItemBottomTh tableItemRightTh tableItemTopTh"></th>

			<?php if ($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) { ?>
                <th class="tableItemBottomTh bb tableItemTopTh"></th>
			<?php } ?>
            <th style="border-left: 0px !important; " class="tableItemTh bb" align="right">
				<?php echo _l('invoice_subtotal'); ?>
            </th>
            <th class="tableItemTh bb tableItemTopTh tableItemRightTh">
				<?= round($invoice->subtotal, 2); ?> <?= $invoice->currency_name ?>
            </th>
        </tr>
        <!-------------------->
        <tr>
            <th class="tableItemBottomTh X-tableItemLeftTh"></th>
            <th class="tableItemBottomTh"></th>
            <th class="tableItemBottomTh"></th>
            <th class="tableItemBottomTh tableItemRightTh"></th>

			<?php if ($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) { ?>
                <th class="tableItemBottomTh"></th>
			<?php } ?>

            <th style="border-left: 0px !important; " class="tableItemTh" align="right">
				<?php echo _l('invoice_total_tax'); ?>
            </th>
            <th class="tableItemTh tableItemRightTh">
				<?= round($invoice->total_tax, 2); ?> <?= $invoice->currency_name ?>
            </th>
        </tr>
        <!-------------------->
		<?php if (round($invoice->discount_total, 2) > 0) { ?>
            <tr>
                <th class="tableItemBottomTh X-tableItemLeftTh"></th>
                <th class="tableItemBottomTh"></th>
                <th class="tableItemBottomTh"></th>
                <th class="tableItemBottomTh tableItemRightTh"></th>

				<?php if ($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) { ?>
                    <th class="tableItemBottomTh bb"></th>
				<?php } ?>

                <th style="border-left: 0px !important; " class="tableItemTh bb" align="right">
					<?php echo _l('invoice_discount').($invoice->discount_percent > 0 ? "(".round($invoice->discount_percent,
								2)."%)" : ""); ?>
                </th>
                <th class="tableItemTh bb tableItemRightTh">
					<?= round($invoice->discount_total, 2); ?> <?= $invoice->currency_name ?>
                </th>
            </tr>
		<?php } ?>
        <!-------------------->
		<?php if (round($invoice->adjustment, 2) > 0) { ?>

            <tr>
                <th class="tableItemBottomTh X-tableItemLeftTh"></th>
                <th class="tableItemBottomTh"></th>
                <th class="tableItemBottomTh"></th>
                <th class="tableItemBottomTh tableItemRightTh"></th>

				<?php if ($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) { ?>
                    <th class="tableItemBottomTh bb"></th>
				<?php } ?>

                <th style="border-left: 0px !important; " class="tableItemTh bb" align="right">
					<?php echo _l('invoice_adjustment'); ?>
                </th>
                <th class="tableItemTh bb tableItemRightTh">
					<?= round($invoice->adjustment, 2); ?> <?= $invoice->currency_name ?>
                </th>
            </tr>
		<?php } ?>
        <!-------------------->
        <tr>
            <th class="tableItemBottomTh X-tableItemLeftTh"></th>
            <th class="tableItemBottomTh"></th>
            <th class="tableItemBottomTh"></th>
            <th class="tableItemBottomTh tableItemRightTh"></th>

			<?php if ($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) { ?>
                <th class="tableItemBottomTh bb"></th>
			<?php } ?>

            <th style="border-left: 0px !important; " class="tableItemTh bb" align="right">
				<?php echo _l('invoice_total'); ?>
            </th>
            <th class="tableItemTh bb tableItemRightTh">
				<?= round($invoice->total, 2).' '.$invoice->currency_name; ?>
            </th>
        </tr>
        <!-------------------->
        <tr>
            <th class="tableItemBottomTh X-tableItemLeftTh"></th>
            <th class="tableItemBottomTh"></th>
            <th class="tableItemBottomTh"></th>
            <th class="tableItemBottomTh tableItemRightTh"></th>

			<?php if ($settings['vat_payer'] == 1 and $settings['show_tax_per_item'] == 1) { ?>
                <th class="tableItemBottomTh bb"></th>
			<?php } ?>

            <th style="border-left: 0px !important; font-weight: bold;" class="tableItemTh bb" align="right">
				<?php echo _l('invoice_total_left_to_pay'); ?>
            </th>
            <th class="tableItemTh bb tableItemRightTh" style="font-weight: bold;">
				<?= $invoice->total_left_to_pay.' '.$invoice->currency_name; ?>
            </th>
        </tr>
        <!-------------------->
        </tbody>
    </table>


</div>


    <htmlpageheader name="invHeader" style="padding: 0mm;text-align:center;background:blue;">

        <div style="height:3cm;margin-top:0px;">
        <table border="0" class="tableBlock" align="center">
            <tbody>
            <tr>
                <td align="center" style="width: 50%;height:3cm;vertical-align:middle;">
                <?php if((int)$invoice->options['invoice_settings']['view_logo'] == 1){?>
                    <img src="<?= $invoice->logoUrl ?>" width="150" class="invoice-logo">
                <?php } ?>
                </td>
                <td align="center">
                    <div class="invoice">
                        <h1 class="invoiceH1" style="font-weight: bold;"><?= $invoice->doctitle; ?></h1>
                    </div>

                </td>
            </tr>
            </tbody>
        </table>
        </div>




        <div style="height:4cm">
            <table class="tableBlock infoBlock" border="0" >
                <tbody>
                <tr>
                <td align="left" class="tableInfoTdleft" style="width: 33%;height:4cm;">
                    <h4 class="inv-title-1"><?= _l('billing_vendor') ?></h4>
                    <p class="p"><?= mb_strtoupper($company['name']); ?></p>
                    <?php if($company['trade_no']){ echo '<p class="p">'._l('billing_registrar_of_companies').': '.$company['trade_no'].'</p>'; } ?>
                    <?php if($company['vat_eu']){ echo '<p class="p">'._l('billing_vat_code').': '.$company['vat_eu'].'</p>'; } ?>
                    <?php if($company['address'] || $company['state'] || $company['city']){ echo '<p class="p">'._l('billing_vendor_address').': '.format_address_line($company).'</p>'; } ?>

                    <?php if((int)$invoice->options['invoice_settings']['view_website'] == 1 AND $company['website']){?>
                    <?= '<p class="p">'._l('billing_vendor_web') ?>: <?= $company['website'].'</p>'; ?>
                    <?php } ?>

                    <?php if((int)$invoice->options['invoice_settings']['view_phone'] == 1 AND $company['fax']){?>
                    <?= '<p class="p">'._l('billing_vendor_tel') ?>.: <?= $company['phonenumber']; ?> // <?= $company['fax'].'</p>'; ?>
                    <?php } ?>

                    <?php if((int)$invoice->options['invoice_settings']['view_email'] == 1 AND $company['email']){?>
                    <?= '<p class="p">'._l('billing_vendor_email') ?>: <?= $company['email'].'</p>'; ?>
                    <?php } ?>


                    <?php if ( ! empty($company['share_capital']) AND $company['share_capital']) { ?>
                        <?= '<p class="p">'._l('billing_vendor_share_capital') ?>: <?= $company['share_capital'].'</p>'; ?>
                    <?php } ?>

                </td>
                <td align="center" class="tableInfoTdCenter" style="width: 33%;">
                    <?php if((int)$invoice->options['invoice_settings']['view_due_date'] == 1){ ?>
                    <table class="box b"><tr><td>
                        <h4 class="inv-title-1"><?= _l('billing_pdf_due_date') ?></h4>
                        <p class="inv-from-1"><?= $invoice->duedate ?></p>
                    </td></tr></table>
                    <?php } ?>
                    <?php if (!empty($invoice->payment_link)) { ?>
                    <p class="inv-from-1"><?= _l('billing_pdf_payment_method_card') ?> <?= $invoice->payment_link; ?> </p><br>
                    <?php } ?>
                </td>
                <td align="right" class="tableInfoTdRight" style="width: 33%;">
                        <h4 class="inv-title-1"><?= _l('billing_customer') ?></h4>
                        <p class="p"><?= mb_strtoupper($invoice->client->company); ?></p>
                        
                            <?php if ( ! empty($invoice->client->trade_number)) { ?>
                                <?= '<p class="p">'._l('billing_registrar_of_companies') ?>: <?= $invoice->client->trade_number; ?><br>
                            <?php } ?>
                            <?php if ( ! empty($invoice->client->vat)) { ?>
                                <?= '<p class="p">'._l('billing_vat_code') ?>: <?= $invoice->client->vat; ?><br>
                            <?php } ?>
                            <?php if ( ! empty($invoice->client->billing_street)) { ?>
                                <?= '<p class="p">'._l('billing_vendor_address') ?>: <?= $invoice->client->billing_street; ?><br>
                            <?php } ?>
                            <?php if ( ! empty($invoice->client->billing_city)) { ?>
                                <?= '<p class="p">'._l('billing_vendor_state') ?>:  <?= $invoice->client->billing_city; ?>,<?= get_state_name($invoice->billing_state); ?>
                                <br>
                            <?php } ?>
                            <?php if ( ! empty($invoice->client->organization_email)) { ?>
                                <?= '<p class="p">'._l('billing_vendor_email') ?>:  <?= $invoice->client->organization_email; ?>
                            <?php } ?>


                </td>
                </tr>
                <tr>
                    <td align="left" class="">
                        <br>
                    </td>
                    <td align="center" class="">
                        <br>
                    </td>
                    <td align="right" class="">
                        <br>
                    </td>
                </tr>

                </tbody>
            </table>
        </div>

        <div style="height:1cm">
            <table class="tableBlock" align="center">
                <tbody>
                <tr>
                    <td align="center" class="tableHeader2Td" style="height:1cm">
                        <div class="divHeader2">
                            <h3 class="divHeaderH2"><?= $invoice->doctitle; ?>: <span><?= $invoice_number ?></span></h3>
                        </div>
                    </td>
                    <td align="center" style="background-color:<?= $invoice->seria_settings['color'] != '' ? $invoice->seria_settings['color'] : '#25cc7e'; ?>;width: 15px; height: 60px;" class="tableHeader2Td">
                    </td>
                    <td align="center" style="background-color:<?= $invoice->seria_settings['color'] != '' ? $invoice->seria_settings['color'] : '#25cc7e'; ?>;width: 15px; height: 60px;" class="tableHeader2Td">
                    </td>
                    <td align="center" class="tableHeader2Td">
                        <div class="divHeader2">
                            <h3 class="divHeaderH2"><?= _l('invoice_data_date') ?> <span> <?= _d($invoice->date) ?></span></h3>
                        </div>

                    </td>
                </tr>
                </tbody>
            </table>
        </div>

    </htmlpageheader>

    <htmlpagefooter name="invFooter" style="padding: 0mm;text-align:center;background:yellow;">
        <div style="height:0.5cm">
            <table width="100%" style="margin-left:10mm;margin-right:10mm;">
                <tr>
                    <td width="33%" class="footer-text">{DATE d-m-Y}</td>
                    <td width="33%" align="center" class="footer-text">{PAGENO}/{nbpg}</td>
                    <td width="33%" style="text-align: right; " class="footer-text"><?= _l('invoice_doc_copy'); ?></td>
                </tr>
            </table>
        </div>
    </htmlpagefooter>

</body>
</html>
