<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Crmcon_email_builder extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        if (!has_permission('email_templates', '', 'view')) {
            access_denied('email_templates');
        }
        if(!DEFINED('EMAIL_BUILDER_MODULE_NAME')){ show_404(); }
        $this->load->model('email_builder_model');
        $this->ci = &get_instance();
    }

    protected function json_output($data)
    {
        return $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function index()
    {
        
        if (!has_permission('email_templates', '', 'view')) {
            access_denied('email_templates');
        }

        $data['title'] = _l(EMAIL_BUILDER_MODULE_NAME);
        $data['active_language'] = get_option('active_language');

        hooks()->add_action('app_admin_head', 'crmcon_email_builder_head_styles');
        hooks()->add_action('app_admin_footer', 'crmcon_email_builder_footer_scripts');

        $this->load->view(EMAIL_BUILDER_MODULE_NAME, $data);
    }

    public function languages()
    {
        return $this->json_output($this->email_builder_model->getEmailLanguages());
    }

    public function mergeFields()
    {
        $requestedType = $this->input->get('type');
        $merge_fields = [];
        if ($requestedType) {
            foreach ($this->app_merge_fields->all() as $val) {
                foreach ($val as $type => $fields) {
                    foreach ($fields as $key => $value) {
                        if ($type === $requestedType) {
                            unset($value['format']);
                            unset($value['templates']);
                            unset($value['available']);
                            $merge_fields[] = $value;
                        }
                    }
                }
            }
        }
        return $this->json_output($merge_fields);
    }

    public function options()
    {
        show_404();
        if (!has_permission('email_templates', '', 'view')) {
            access_denied('email_templates');
        }
        $data['title'] = _l(EMAIL_BUILDER_MODULE_NAME . '_options');
        if (!$this->input->is_ajax_request()) {
            $this->load->view(EMAIL_BUILDER_MODULE_NAME . '_options', $data);
        } else {
            $options = $this->input->post(null, false);

            update_option(EMAIL_BUILDER_MODULE_NAME . '_default_media_folder', $this->input->post('default_media_folder'));
            update_option('old_email_header', html_entity_decode($options['old_email_header']));
            update_option('old_email_footer', html_entity_decode($options['old_email_footer']));

            return $this->json_output(['type' => 'success', 'status' => _l('options_updated')]);
        }
    }

    public function getEmailTemplate()
    {
        $data = $this->email_builder_model->getEmailTemplate($this->input->get('id'));
        return $this->json_output($data);
    }

    public function getTemplate()
    {
        $data = [];
        $email = $this->email_builder_model->getEmailObject($this->input->get('id'));
        
        if(isset($email->emailObject)){
            $decodedData = json_decode($email->emailObject);
        } else {
            $decodedData = $email;
        }
        

        $data['template'] = ($decodedData !== null && json_last_error() === JSON_ERROR_NONE) ? $decodedData : new stdClass();


        return $this->json_output($data);
    }

    public function templates()
    {
        $data = $this->email_builder_model->getAllTemplates(
            ['language' => $this->input->get('language')],
            ['emailtemplateid', 'type', 'name', 'subject', 'active', 'fromname']
        );
        return $this->json_output($data);
    }

    public function update()
    {
        if (!has_permission('email_templates', '', 'edit')) {
            access_denied('email_templates');
        }
        if ($this->input->post() && $this->input->post('emailtemplateid') && $this->input->post('emailObject')) {
            $data = $this->input->post();
            $data['template'] = $this->input->post('template', false);
            $data['emailObject'] = $this->input->post('emailObject', false);
            $success = $this->email_builder_model->update($data);
            return $this->json_output(['success' => $success]);
        }
    }

    public function changeActiveStatus()
    {
        if (!has_permission('email_templates', '', 'edit')) {
            access_denied('email_templates');
        }
        if (!($updates = $this->input->post())) {
            $success = false;
        } else {
            $success = $this->email_builder_model->updateActiveStatus($updates);
        }
        return $this->json_output(['success' => $success]);
    }

    public function updateDetails()
    {
        if (!has_permission('email_templates', '', 'edit')) {
            access_denied('email_templates');
        }
        $updates = [];
        if (!($updates = $this->input->post())) {
            $success = false;
        } else {
            $success = $this->email_builder_model->updateDetails($updates);
            unset($updates['emailtemplateid']);
        }
        return $this->json_output(['success' => $success, 'updates' => $updates]);
    }

    public function revertTemplate($id)
    {
        $success = $this->email_builder_model->removeEditedEmail($id);
        if ($success) {
            $data = $this->email_builder_model->getEmailObject($id);
            return $this->json_output($data);
        }
        return $this->json_output(['$success' => $success]);
    }

    public function upload()
    {
        $this->load->helper('path');
        $media_folder = $this->app->get_media_folder();
        $defaultMediaFolder =  '/' . get_option(EMAIL_BUILDER_MODULE_NAME . '_default_media_folder') . '/';
        $mediaPath = FCPATH . $media_folder . $defaultMediaFolder;

        if (!is_dir($mediaPath)) {
            mkdir($mediaPath, 0755);
        }

        $config['upload_path'] = set_realpath($media_folder . $defaultMediaFolder, true);
        $config['allowed_types'] = 'jpg|jpeg|png|gif';
        $config['encrypt_name'] = true;
        $config['max_size'] = (int)get_option('media_max_file_size_upload') * 1000;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('image')) {
            $error = array('error' => $this->upload->display_errors('', ''), 'success' => false);
            return $this->json_output($error);
        } else {
            return $this->json_output(['success' => true, 'path' => site_url($media_folder) . $defaultMediaFolder . $this->upload->data('file_name')]);
        }
    }
}
