function CreateChart_Column(container, series) {
    return Highcharts.chart(container, {
        chart: {
            type: 'column',
            height: 200,
            marginTop: 0,
            spacingTop: 0,
            reflow: false,
        },
        title: {
            text: null
        },
        lang: {
            noData: "No data for selected options."
        },
        credits: false,
        xAxis: {
            enabled: false,
            showEmpty: true,
            visible: false,

        },
        yAxis: {
            enabled: false,
            showEmpty: true,
            visible: false,

        }, //axa verticala
        series: series,
        legend: {
            enabled: false
        }, //afiseaza o zona scollabila cu toate datele
        tooltip: {
            formatter: function () {
                return this.point.series.name; // '<b> ' + this.y + ' conversions o n<br/>' + this.series.name + '</b><br/>Conversions:' +  this.x;
            }
        },
        plotOptions: {
            column: {
                dataLabels: {
                    enabled: true,
                    crop: false,
                    overflow: 'none'
                }
            },
            series: {
                pointWidth: 10,
                pointPadding: 0,
                groupPadding: 0,
                borderWidth: 0,
                shadow: false,
                minPointLength: 8,
            }
        },
        lang: {
            noData: "No information to display"
        },
        noData: {
            style: {
                fontWeight: 'bold',
                fontSize: '15px',
                color: '#303030'
            }
        }
    });

}
function CreateChart_Pie(container, series) {
    return Highcharts.chart(container, {
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            type: 'pie'
        },
        title: {
            text: null
        },
        lang: {
            noData: "No data for selected options."
        },
        credits: {
            enabled: false
        },
        tooltip: {
            pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        },
        accessibility: {
            point: {
                valueSuffix: '%'
            }
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                innerSize: '60%',
                colors: ['#3D449C','#268FB2','#2DC486','#74DE00'],
                dataLabels: {
                    enabled: false
                },
                showInLegend: true
            }
        },
        series: [{
            name: 'Brands',
            colorByPoint: true,
            data: series
        }]
    });
}
function HC_Pie(container, series = [], settings = []) {

  var chart_settings = {
      chart: {
        backgroundColor: "rgba(0,0,0,0)",
        plotBackgroundColor: null,
        plotBorderWidth: 0,
        plotShadow: false,
        height:150
      },
      credits: {
        enabled:  false
      },
      navigation: {
                buttonOptions: {
                    enabled: false
                }
            },
      title: {
            text: '',
            align: 'center',
            verticalAlign: 'top',
            y: 90
        },
        lang: {
            noData: "No data for selected options."
        },
      tooltip: {
        //pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        pointFormat: '<b>{point.percentage:.0f}%</b>'
      },
      plotOptions: {
        pie: {
          dataLabels: {
            enabled: false
          },
          size: 140,
          center: ['50%', '50%']
        }
      },
      series: series
  };
  if ('plotSize' in settings) {
    chart_settings.plotOptions.pie.dataLabels.size = settings.plotSize;
  }
  if ('hasLabels' in settings) {
    chart_settings.plotOptions.pie.dataLabels.enabled = settings.hasLabels;
  }


  return Highcharts.chart(container, chart_settings);
}
function CreateChart_SemiGauge(container, data,settings = []) {
    return Highcharts.chart(container, {
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: 0,
            plotShadow: false,
            height: 170,
            pacingTop: 0,
            spacingRight: 0,
            spacingBottom: 0,
            spacingLeft: 0,
            margin: [0, 0, 0, 0],
        },
        credits: {
            enabled: false
        },

        title: {
            text: settings.title,
            align: 'center',
            verticalAlign: 'top',
            y: 90
        },
        lang: {
            noData: "No data for selected options."
        },
        tooltip: { //{series.name}:
            pointFormat: '<b>{point.percentage:.1f}%</b>'
        },
        plotOptions: {
            pie: {
                dataLabels: {
                    enabled: false
                },
                startAngle: -90,
                endAngle: 90,
                size: 150,
                center: ['50%', '60%']
            }
        },
        series: [{
            type: 'pie',
            innerSize: '80%',
            data: data
        }]
    });

}
function CreateChart_Bar(container, data, headers) {
    return Highcharts.chart(container, {
        chart: {
            type: 'bar',
            backgroundColor: "rgba(0,0,0,0)",
            height: 250,
            legend: {
                layout: 'vertical',
                align: 'center',
                verticalAlign: 'bottom',
                x: 120,
                y: 80,
                floating: true,
                shadow: false
            },
        },
        navigation: {
            buttonOptions: {
                enabled: false
            }
        },
        title: {
            text: ''
        },
        subtitle: {
            text: ''
        },
        xAxis: {
            categories: headers,
            title: {
                text: null
            }
        },
        yAxis: {
            min: 0,
            /*title: {
                text: 'Values',
                align: 'high'
            },*/
            title: {
                enabled:false
            },
            labels: {
                overflow: 'justify'
            }
        },
        tooltip: {
            // valueSuffix: ' thousands'
        },
        plotOptions: {
            bar: {
                dataLabels: {
                    enabled: true
                }
            }
        },

        credits: {
            enabled: false
        },
        series: data
    });
}
function HC_Line_Area(container, series, settings = []) {
  var chart_settings = {
      chart: {
          type: 'area',
          height:100,
          //spacingTop: 0,
          spacingRight: 0,
          spacingBottom: 0,
          spacingLeft: 0,
          plotBorderWidth: 0,
          margin: [0,0,0,0],
      },
      title: { text: null },
      lang: {
          noData: "No data for selected options."
      },
      credits: false,
      legend: {enabled:false},
      xAxis: {
          visible:false,
          allowDecimals: false,
          /*labels: {
            formatter: function () {
                return this.value; // clean, unformatted number for year
            }
          },*/
      },
      yAxis: {
          visible:false,
          title: {
          text: 'Issues'
          },
        /*labels: {
          formatter: function () {
              return this.value / 1000 + 'k';
          }
        }*/
      },
      /*tooltip: {
        pointFormat: '{series.name}: <b>{point.y}</b><br/>',
        valueSuffix: ' cm',
        shared: true
      },*/
      /*tooltip: {
           pointFormat: '{series.name} had stockpiled <b>{point.y:,.0f}</b><br/>warheads in {point.x}'
       },*/
      plotOptions: {
          area: {
            pointStart: 1,
            color: settings.plot.color,
            marker: {
                enabled: false,
                symbol: 'circle',
                radius: 2,
                states: {
                  hover: {
                      enabled: true
                  }
                }
            },
            /*tooltip: {
                pointFormat: '{series.name} <b>{point.y:,.0f}</b>',
            },*/
          }
      },
      series: series
  };

  return Highcharts.chart(container, chart_settings);


}
function HC_Column_line_percents(container, series = [], settings = []) {
  console.log(settings,series);
  var chart_settings = {
      chart: {
          zoomType: 'xy',height:250
      },
      title: { text: null },
      credits: false,
      xAxis: [{
         categories: settings.xcategories,
         crosshair: true
      }],
      yAxis: [{ // Primary yAxis
          labels: {
            format: '{value}',
            style: {
                color: Highcharts.getOptions().colors[1]
            }
          },
          title: {
            text: '%tickets',
            style: {
                color: Highcharts.getOptions().colors[1]
            }
          },
          max: 100,endOnTick: false
        },
        { // Secondary yAxis
          title: {
          text: 'Tickets',
          style: {
              color: Highcharts.getOptions().colors[0]
          }
          },
          labels: {
          format: '{value}',
          style: {
              color: Highcharts.getOptions().colors[0]
          }
          },
          opposite: true
      }],
      tooltip: {
          shared: true
      },
      legend: {
          layout: 'vertical',
          align: 'left',
          x: 120,
          verticalAlign: 'top',
          y: 100,
          floating: true,
          backgroundColor:
          Highcharts.defaultOptions.legend.backgroundColor || // theme
          'rgba(255,255,255,0.25)'
      },
      series: series
  };

  return Highcharts.chart(container, chart_settings);
}
function HC_Column_line(container, series = [], settings = []) {
  var chart_settings = {
      chart: {
          zoomType: 'xy',height:250
      },
      title: { text: null },
      credits: false,
      xAxis: [{
          crosshair: true,
          categories: settings.xcategories,
      }],
      yAxis: [{ // Primary yAxis
          labels: {
          format: '{value}',
          style: {
              color: Highcharts.getOptions().colors[1]
          }
          },
          title: {
          text: settings.ytitle_spline,
          style: {
              color: Highcharts.getOptions().colors[1]
          }
          }
      }, { // Secondary yAxis
          title: {
          text: settings.ytitle_column,
          style: {
              color: Highcharts.getOptions().colors[0]
          }
          },
          labels: {
          format: '{value}',
          style: {
              color: Highcharts.getOptions().colors[0]
          }
          },
          opposite: true
      }],
      tooltip: {
          shared: true
      },
      legend: {
          layout: 'vertical',
          align: 'left',
          x: 120,
          verticalAlign: 'top',
          y: 100,
          floating: true,
          backgroundColor:
          Highcharts.defaultOptions.legend.backgroundColor || // theme
          'rgba(255,255,255,0.25)'
      },
      series: series
  };

  //chart_settings.yAxis
  return Highcharts.chart(container, chart_settings);
}
function HC_Area(container, series = [], settings = []) {
  var chart_settings = {
      chart: {
          type: 'area',height:100,marginBottom:5
      },
      title: { text: null },
      credits: false,
      legend: {enabled:false},
      xAxis: {
         // visible:false,
          allowDecimals: false,
          labels: {
          formatter: function () {
              return this.value; // clean, unformatted number for year
          }
          },
      },
      yAxis: {
         // visible:false,
          title: {
          text: settings.yaxis.text
          },
          /*labels: {
            formatter: function () {
                return this.value / 1000 + 'k';
            }
          }*/
      },
      tooltip: {
          pointFormat: '<b>{point.y:,.0f}</b> {series.name} <br/>on monthly day number {point.x}'
          //pointFormat: '{point.y} | {point.x}'
      },

      plotOptions: {
          area: {
          pointStart: 1,
          marker: {
              enabled: false,
              symbol: 'circle',
              radius: 2,
              states: {
              hover: {
                  enabled: true
              }
              }
          }
          }
      },
      series: series
  };

  return Highcharts.chart(container, chart_settings);
}
function HC_Columns(container, series = [], settings = []) {
  var chart_settings = {
      chart: {
        height:250,type: 'column',
      },
      title: { text: null },
      credits: false,
      xAxis: [{
          crosshair: true,
          categories: settings.xcategories,
      }],
      yAxis: {
          min: 0,
          title: {
            text: settings.ytitle
          }
      },
      tooltip: {
          headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
          pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
          '<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
          footerFormat: '</table>',
          shared: true,
          useHTML: true
      },
      plotOptions: {
          column: {
          pointPadding: 0.2,
          borderWidth: 0
          }
      },
      series: series
  };

  return Highcharts.chart(container, chart_settings);
}
function HC_Columns_Stacked(container, series = [], settings = []) {
  var chart_settings = {
      chart: {
          type: 'column',height:250
      },
      title: { text: null },
      credits: false,
      xAxis: {
        categories: settings.xcategories,
      },
      yAxis: {
          visible:false,
          min: 0,
          title: {
          text: 'Total'
          },
          stackLabels: {
          enabled: true,
          style: {
              fontWeight: 'bold',
              color: ( // theme
              Highcharts.defaultOptions.title.style &&
              Highcharts.defaultOptions.title.style.color
              ) || 'gray'
          }
          }
      },
      legend: {
          align: 'right',
          x: -30,
          verticalAlign: 'top',
          y: 25,
          floating: true,
          backgroundColor:
          Highcharts.defaultOptions.legend.backgroundColor || 'white',
          borderColor: '#CCC',
          borderWidth: 1,
          shadow: false
      },
      tooltip: {
          headerFormat: '<b>{point.x}</b><br/>',
          pointFormat: '{series.name}: {point.y}<br/>Total: {point.stackTotal}'
      },
      plotOptions: {
          column: {
          stacking: 'normal',
          dataLabels: {
              enabled: true
          }
          }
      },
      series: series
  };

  return Highcharts.chart(container, chart_settings);
}
function HC_AreaSpline(container, series = [], settings = []) {
  var chart_settings = {
      chart: {
          type: 'areaspline',
          height:160
      },
      credits: {
          enabled:  false
      },
      navigation: {
              buttonOptions: {
                  enabled: false
              }
          },
      title: {
          text: ''
      },
      legend: {
          layout: 'vertical',
          align: 'left',
          verticalAlign: 'top',
          x: 150,
          y: 150,
          floating: true,
          borderWidth: 1,
          backgroundColor:
              Highcharts.defaultOptions.legend.backgroundColor || '#FFFFFF'
      },
      xAxis: {
          labels: {
                  rotation: -45,
                  style: {
                      fontSize: '13px',
                      fontFamily: 'Verdana, sans-serif'
                  }
              },
          categories: settings.xcategories
      },
      yAxis: {
          title: {
              text: ''
          }
      },
      tooltip: {
          shared: true,
          valueSuffix: ' EUR'
      },
      credits: {
          enabled: false
      },

      series: series
  };

  return Highcharts.chart(container, chart_settings);
}
function HC_Spline(container, series = [], settings = []) {
  var chart_settings = {
      chart: {
          type: 'spline',
          backgroundColor: "rgba(0,0,0,0)",
          height: 50
      },
      credits: {
          enabled:  false
      },
      navigation: {
              buttonOptions: {
                  enabled: false
              }
          },
      title: {
          text: ''
      },
      legend:{enabled:false},
      xAxis: {
          visible:false,
          /*type: 'datetime',
          dateTimeLabelFormats: {
              month: '%e. %b',
              year: '%b'
          },*/
          title: {
              text: ''
          }
      },
      yAxis: {
          visible:false,
          title: {
              text: ''
          },
          min: 0
      },
      tooltip: {
          headerFormat: '<b>{series.name}</b><br>',
          //pointFormat: '{point.x:%e. %b}: {point.y:.2f}'
          pointFormat: '{point.y:.2f}'
          //pointFormat: '{point.x}: {point.y}'
      },

      plotOptions: {
          series: {
              marker: {
                  enabled: false
              }
          }
      },

      colors: ['#6CF', '#39F', '#06C', '#036', '#000'],
      series: series,

  };

  return Highcharts.chart(container, chart_settings);
}
function HC_Area_Timeseries_LineAVG(container, series = [], settings = []) {
  var chart_settings = {
      chart: {
          type: 'area',
          backgroundColor: "rgba(0,0,0,0)",
          height:200,
          zoomType: 'xy'
      },
      scrollbar: {
        enabled: true,
        barBackgroundColor: '#17a2b8',
        barBorderRadius: 4,
        barBorderWidth: 0,
        buttonBackgroundColor: '#17a2b8',
        buttonBorderWidth: 0,
        buttonBorderRadius: 4,
        trackBackgroundColor: 'none',
        trackBorderWidth: 1,
        height: 3,
        trackBorderRadius: 4,
        trackBorderColor: '##17a2b8'
      },
      title: {
          text: ''
      },
      credits: {
          enabled:  false
      },
      legend:{enabled:false},
      navigation: {
              buttonOptions: {
                  enabled: false
              }
          },
      xAxis: {
        title: {
            text: 'Weeks'
        },
        categories:settings.categories,
        type:'category'

      },

      yAxis: {
          title: {
              text: null
          }
      },

      tooltip: {
          crosshairs: false,
          shared: false,
          valueSuffix: '',
          headerFormat: '<b>{series.name}</b><br>'
      },

      plotOptions: {
       line: {
           dataLabels: {
               enabled: true
           },
           enableMouseTracking: false
       }
     },

      series: [{
          name: '',
          data: series,
          type: 'line',
          lineWidth: 2,
          color: '#73b8bf',
          zIndex: 1,
          marker: {
              enabled: true
          },
      }]




  };

  var hc = Highcharts.chart(container, chart_settings);
  hc.xAxis[0].setExtremes(0,0);
  return hc;
}
function HC_Bar_Percent_Fill(container, series = [], settings = []) {
  var chart_settings = {
      chart: {
          type: 'bar',
          height: 120
      },
      title: {
          text: ''+settings.actual_value,
          align: 'center',
          margin: 0
      },

          credits: {enabled:false},
          legend: {enabled:false},
          tooltip: {enabled:false},
      plotOptions: {
          bar: {
          // stacking: 'normal',
          borderWidth: 0,
          borderRadius: 3
          }
      },
      xAxis: {
          visible: false
      },
      yAxis: {
          visible: false,
          min: 0,
          max: 100,
          title: {
          text: null
          },
          gridLineWidth: 0,
          labels: {
          y: -2
          }
      },
      series: [
      {
          name: "Fill",
          data: [settings.target_value],
          color: "#dee2e6",//#dee2e6 grey  roz e83e8c
          grouping: false,
          dataLabels: {
              enabled: true,
              inside: true,
              align: 'right',
              format: '{point.y}%',
              style: {
                  color: 'white',
                  textOutline: false,
              }
          }
          // enableMouseTracking: false, disable tooltip on just this data element
      },
      {
          name: "Percentage",
          data: [settings.actual_value],
          color: "#1caf9a",
          dataLabels: {
              enabled: true,
              inside: true,
              align: 'right',
              format: '{point.y}%',
              style: {
                  color: 'white',
                  textOutline: false,
              }
          }
      }
      ]
  };

  return Highcharts.chart(container, chart_settings);
}
function HC_Bar(container, series = [], settings = []) {
  var chart_settings = {
      chart: {type: 'bar',height:200},
      title: { text: null },
      credits: false,
      scrollbar: {
        enabled: true,
        barBackgroundColor: '#17a2b8',
        barBorderRadius: 4,
        barBorderWidth: 0,
        buttonBackgroundColor: '#17a2b8',
        buttonBorderWidth: 0,
        buttonBorderRadius: 4,
        trackBackgroundColor: 'none',
        trackBorderWidth: 1,
        height: 3,
        trackBorderRadius: 4,
        trackBorderColor: '##17a2b8'
      },
      xAxis: {
          categories: settings.categories
      },
      yAxis: {
          title: {
              text:  settings.text
          }
      },
      plotOptions: {
        series: {
            pointWidth: 20
        }
      },
      legend:{enabled:false},
      tooltip: {
        formatter: function() {
            return '<b>'+ this.y +'</b> '+settings.text_on_bar; // in <b>'+ this.x + '</b> ';
          }
           //pointFormat: '<b>{point.z:,.0f}</b> {series.name}'
       },
      series: [{
          name: settings.text,
          color:'#1caf9a',
          data: settings.data
      }]
  };

  return Highcharts.chart(container, chart_settings);
}
export {
    CreateChart_Column,
    CreateChart_SemiGauge,
    CreateChart_Bar,
    CreateChart_Pie,
    HC_Line_Area,
    HC_Column_line,HC_Column_line_percents,HC_Area,HC_Columns,HC_Columns_Stacked, //Helpdesk
    HC_Pie, //CFO, TeamPasswd
    HC_AreaSpline, //SalesKPI
    HC_Spline,HC_Area_Timeseries_LineAVG,  //Sales Cycle
    HC_Bar_Percent_Fill, //Inbound lead not used
    HC_Bar, //Inboond and Legal
}
