import {HC_AreaSpline,HC_Bar,HC_Pie} from "../../helpers.js";

export default {
    name: 'CeoStrategic',
    data() {
        return {
            dashcards:{},
            period_filter: '30d',
            date_from: '',
            date_to: '',

            globals:{delta_total_leads:0,delta_iql_leads:0,delta_mql_leads:0,delta_sql_leads:0,delta_total_clients:0,delta_total_contacts:0,delta_cost_per_lead:0},

            //SalesKpi
            delta_sales_num:0,delta_sales_value:0,
            delta_sales_cost:0,delta_total_sales_profit:0,


            //teampass
            total_password:0,normal_password:0,bank_account:0,credit_card:0,email:0,server:0,software_license:0,shared:0


        };
    },
    mounted: function () {
        this.load_data();

    },
    methods: {
      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
       load_data(){
         this.cards()
         this.sales_kpi()
         this.barcharts()
         this.allcharts()


      },
      async cards(){
        await axios.post(site_url + '/dashboards/ceo_strategic/cards', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
          /*HC_Bar_Percent_Fill('leads_today',null,{
            actual_value:data.data.leads.actual_value,
            target_value:data.data.leads.target_value,
          });*/

          /*var refs = Object.keys(data.data.refs);
          refs.forEach(ref => {
           this.$refs[ref].innerText = data.data.refs[ref];
          });*/

          var globals = Object.keys(data.data.globals);
          globals.forEach(global => {
            this.globals[global] = data.data.globals[global];
          });

          console.log(data.data.dashcards);
          this.dashcards = data.data.dashcards;

        });

      },
      async sales_kpi(){
        await axios.post(site_url + '/dashboards/sales_kpi/allcharts', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
            HC_AreaSpline('chart_new_generated_sales_revenue',
              [{
                  name: this.$t("ceo_strategic.all_channels"), //'All channels',
                  data: data.data.allchannels,
                  color:'#17d6b2',
                  marker: {
                      enabled: false
                  }

              },
              {
                  name: this.$t("ceo_strategic.new_revenue"), //'New Revenue',
                  data: data.data.sales_from_opp,
                  color:'#008080',
                  marker: {
                      enabled: false
                  }
              }

            ],{xcategories:data.data.xcategories}
          )

            /*var refs = Object.keys(data.data.refs);
            refs.forEach(ref => {
              this.$refs[ref].innerText = data.data.refs[ref];
            });*/

            this.delta_sales_num = data.data.delta_sales_num;

        });

      },
      async barcharts(){
        await axios.post(site_url + '/dashboards/inbound_lead_generation/barcharts', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
          /*HC_Bar_Percent_Fill('leads_today',null,{
            actual_value:data.data.leads.actual_value,
            target_value:data.data.leads.target_value,
          });*/

          /*var refs = Object.keys(data.data.refs);
          refs.forEach(ref => {
            this.$refs[ref].innerText = data.data.refs[ref];
          });*/

          var globals = Object.keys(data.data.globals);
          globals.forEach(global => {
            this.globals[global] = data.data.globals[global];
          });

          HC_Bar('leads_by_source',null,{
            categories:data.data.leads_by_source.categories,
            text:data.data.leads_by_source.text,
            data:data.data.leads_by_source.data,
            text_on_bar:'leads'
          })
          HC_Bar('leads_by_pipeline',null,{
            categories:data.data.leads_by_pipeline.categories,
            text:data.data.leads_by_pipeline.text,
            data:data.data.leads_by_pipeline.data,
            text_on_bar:'leads'
          })
          HC_Bar('leads_by_form',null,{
            categories:data.data.leads_by_form.categories,
            text:data.data.leads_by_form.text,
            data:data.data.leads_by_form.data,
            text_on_bar:'leads'
          })

        });

      },
      async allcharts(){
        await axios.post(site_url + '/dashboards/team_password/allcharts', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
            HC_Pie('password_quantity_by_category',
            [{
              type: 'pie',
              innerSize: '80%',
              data: data.data.arr_passwords_percents
            }],{plotSize:'100', 'hasLabels':true }
            )

            HC_Pie('password_total_share_by_type',
            [{
              type: 'pie',
              innerSize: '80%',
              data: data.data.arr_shared_percents
            }],{plotSize:'100', 'hasLabels':true }
            )
            /*console.log(data.data.vars);
            var vars = Object.keys(data.data.vars);
            vars.forEach(var => {
              this[var] = data.data.vars[var];
            });*/

            this.total_password = data.data.vars.total_password;
            this.normal_password = data.data.vars.normal_password;
            this.bank_account = data.data.vars.bank_account;
            this.credit_card = data.data.vars.credit_card;
            this.email = data.data.vars.email;
            this.server = data.data.vars.server;
            this.software_license = data.data.vars.software_license;
            this.shared = data.data.vars.shared;

        });

      },
      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },


      filter(data, callback) {
          return data.filter(callback);
      },
    },
    template:'#ceo_strategic',
}
