import {HC_Pie} from "../../helpers.js";

export default {
    name: 'CfoStrategic',
    data() {
        return {
            period_filter: '30d',
            date_from: '',
            date_to: '',

            has_revenue_goal:null,
            has_inc_vs_exp_ratio_goal:null,
            has_gross_margin_goal:null,
            has_addition_goal:null,
            income_expenses_ratio_target:null,

            gross_profit:'',
            addition_total:'',
            revenue_target:'',
            percent_to_target:'',
            percent_revenue:'',
            revenue_accomplished:'',
            income_expenses_ratio:'',
            income_expenses_ratio_target:'',
            percent_income:'',
            percent_expenses:'',
            percent_gross_profit_formatted:'',
            percent_gross_profit_totarget_formatted:'',
            addition_target:'',
            addition_accomplished:'',
            addition_to_target:''

        };
    },
    mounted: function () {
        this.load_data();
    },
    methods: {
      async piecharts(){
        await axios.post(site_url + '/dashboards/cfo_strategic/piecharts', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {

          this.has_revenue_goal = data.data.has_revenue_goal;
          this.has_inc_vs_exp_ratio_goal = data.data.has_inc_vs_exp_ratio_goal;
          this.has_gross_margin_goal = data.data.has_gross_margin_goal;
          this.has_addition_goal = data.data.has_addition_goal;

            HC_Pie('chart__revenue',
            [{
              type: 'pie',
              innerSize: '60%',
              data: [{
                name: this.$t('charts.chart__revenue_accomplished'),
                color: '#17A2B8',
                y: data.data.percent_revenue
              },
              {
                name: this.$t('charts.chart__revenue_to_target'),
                color: '#dee2e6',
                y: data.data.percent_to_target
              }]
            }],{}
          )


            if(this.has_revenue_goal){
              //this.$refs.revenue_target.innerText = data.data.revenue_target_formatted;
              //this.$refs.percent_to_target.innerText = data.data.percent_to_target;
              //this.$refs.percent_revenue.innerText = data.data.percent_revenue;

              this.revenue_target = data.data.revenue_target_formatted;
              this.percent_to_target = data.data.percent_to_target;
              this.percent_revenue = data.data.percent_revenue;
            }
            //this.$refs.revenue_accomplished.innerText = data.data.revenue_formatted;
            this.revenue_accomplished = data.data.revenue_formatted;

            HC_Pie('chart__income_and_expenses',
            [{
              type: 'pie',
              innerSize: '60%',
              data: [{
                name: this.$t('charts.chart__income_and_expenses_accomplished'),
                color: '#17A2B8',
                y: data.data.percent_income
              },
              {
                name: this.$t('charts.chart__income_and_expenses_to_target'),
                color: '#dee2e6',
                y: data.data.percent_expenses
              }]
            }],{}
          )

            //this.$refs.income_expenses_ratio.innerText = '2:1';
            this.income_expenses_ratio = data.data.income_expenses_ratio;

            var references = [
              'gross_profit',
            'addition_total'
            ];
              references.forEach(refference => {
                //this.$refs[refference].innerText = data.data[refference];
                this.gross_profit = data.data.gross_profit;
                this.addition_total = data.data.addition_total;

              });

            if(this.has_inc_vs_exp_ratio_goal){
              //this.$refs.income_expenses_ratio_target.innerText = data.data.income_expenses_ratio_target;
              //this.$refs.percent_income.innerText = data.data.percent_income;
              //this.$refs.percent_expenses.innerText = data.data.percent_expenses;

              this.income_expenses_ratio_target = data.data.income_expenses_ratio_target;
              this.percent_income = data.data.percent_income;
              this.percent_expenses = data.data.percent_expenses;
            }
            if(this.has_gross_margin_goal){
              //this.$refs.gross_profit_target.innerText = data.data.gross_profit_target;
              //this.$refs.percent_gross_profit_formatted.innerText = data.data.percent_gross_profit_formatted;
              //this.$refs.percent_gross_profit_totarget_formatted.innerText = data.data.percent_gross_profit_totarget_formatted;

              this.gross_profit_target = data.data.gross_profit_target;
              this.percent_gross_profit_formatted = data.data.percent_gross_profit_formatted;
              this.percent_gross_profit_totarget_formatted = data.data.percent_gross_profit_totarget_formatted;

            }
            if(this.has_addition_goal){
              //this.$refs.addition_target.innerText = data.data.addition_target;
              //this.$refs.addition_accomplished.innerText = data.data.addition_accomplished;
              //this.$refs.addition_to_target.innerText = data.data.addition_to_target;

              this.addition_target = data.data.addition_target;
              this.addition_accomplished = data.data.addition_accomplished;
              this.addition_to_target = data.data.addition_to_target;
            }

            HC_Pie('chart__gross_profit',
            [{
              type: 'pie',
              innerSize: '60%',
              data: [{
                name: this.$t('charts.chart__gross_profit_accomplished'),
                color: '#17A2B8',
                y: data.data.percent_gross_profit
              },
              {
                name: this.$t('charts.chart__gross_profit_to_target'),
                color: '#dee2e6',
                y: data.data.percent_gross_profit_totarget
              }]
            }],{}
          )

            HC_Pie('chart__ebit',
            [{
              type: 'pie',
              innerSize: '60%',
              data: [{
                name: this.$t('charts.chart__ebit_accomplished'),
                color: '#17A2B8',
                y: data.data.percent_addition_accomplished
              },
              {
                name: this.$t('charts.chart__ebit_to_target'),
                color: '#dee2e6',
                y: data.data.percent_addition_to_target
              }]
            }],{}
          )



        });

      },
      load_data(){
        this.piecharts();
      },
      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },
      filter(data, callback) {
          return data.filter(callback);
      },
    },
    template:'#cfo_strategic',
}
