import {HC_Line_Area} from "../../helpers.js";

export default {
    name: 'CmoStrategic',
    data() {
        return {
            period_filter: '30d',
            date_from: '',
            date_to: '',
            globals:{delta_total_leads:0,delta_iql_leads:0,delta_mql_leads:0,delta_sql_leads:0,delta_total_clients:0,delta_total_contacts:0,delta_cost_per_lead:0}
        };
    },
    mounted: function () {
        this.load_data();

    },
    methods: {
      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
      load_data(){
        this.cards();
      },
      async cards(){
        await axios.post(site_url + '/dashboards/cmo_strategic/cards', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
          /*HC_Bar_Percent_Fill('leads_today',null,{
            actual_value:data.data.leads.actual_value,
            target_value:data.data.leads.target_value,
          });*/

          var refs = Object.keys(data.data.refs);
          refs.forEach(ref => {
            this.$refs[ref].innerText = data.data.refs[ref];
          });

          var globals = Object.keys(data.data.globals);
          globals.forEach(global => {
            this.globals[global] = data.data.globals[global];
          });

        });

      },
      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },


      filter(data, callback) {
          return data.filter(callback);
      },
    },
    template:'#cmo_strategic',
}
