export default {
    name: 'Dashcard1',
    props: {
        data: {
          type: Object,
          default() { return {
            "title":"",
            "subtitle":"",
            "figure":0,
            "figure_delta":0,
            
          }; }
        },
    },
    template:`
        <div class="dashcard">
            <div class="dashcard__header border">
                <div class="dashcard__header_title">{{data.title}}</div>
                <div class="dashcard__header_right_title">{{data.subtitle}}</div>
            </div>
            <div class="dashcard__body">
                <div class="dashcard__widget1">
                    <h4 class="dashcard__widget1_title text-center">{{data.figure}}</h4>
                    <span class="dashcard__widget1_figures" v-if="data.figure_delta && data.figure_delta > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span>{{data.figure_delta}}</span>%</span> {{ $t("general.versus_previous_period") }} </p></span>
                    <span class="dashcard__widget1_figures" v-else-if="data.figure_delta < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span>{{data.figure_delta}}</span>%</span> {{ $t("general.versus_previous_period") }}</p></span>
                    <span class="dashcard__widget1_figures" v-else-if="data.figure_delta== 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span>{{data.figure_delta}}</span>%</span> {{ $t("general.versus_previous_period") }}</p></span>

                </div>
            </div>
        </div>
    `,
}

//<span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="">5%</span> to target ($130,233)</p></span>