import {HC_Bar} from "../../helpers.js";

export default {
    name: 'Legal',
    data() {
        return {
            period_filter: '30d',
            date_from: '',
            date_to: '',

        };
    },
    mounted: function () {
        this.load_data();
    },
    methods: {
      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
      load_data(){
        this.barcharts();
      },
      async barcharts(){
        await axios.post(site_url + '/dashboards/legal/barcharts', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
          var refs = Object.keys(data.data.refs);
          refs.forEach(ref => {
            this.$refs[ref].innerText = data.data.refs[ref];
          });

          HC_Bar('contracts_by_type',null,{
            categories:data.data.contract_num.categories,
            text:data.data.contract_num.text,
            data:data.data.contract_num.data,
            text_on_bar:'contracts'
          })
          HC_Bar('contracts_value_by_type',null,{
            categories:data.data.contract_val.categories,
            text:data.data.contract_val.text,
            data:data.data.contract_val.data,
            text_on_bar:''
          })

        });

      },
      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },


      filter(data, callback) {
          return data.filter(callback);
      },
    },
    template:'#legal',
}
