import {HC_Bar_Percent_Fill,HC_Bar} from "../../helpers.js";

export default {
    name: 'OperationalMarketing',
    data() {
        return {
            period_filter: '30d',
            date_from: '',
            date_to: '',

            globals:{delta_total_leads:0,delta_iql_leads:0,delta_mql_leads:0,delta_sql_leads:0}
        };
    },
    mounted: function () {
        this.load_data();
    },
    methods: {
      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
      load_data(){
        this.barcharts();
      },
      global(key,defaultv = ''){
        var globals = this.globals;
        if (typeof globals[key] === 'undefined') {
          return defaultv;
        }else{
          return globals[key];
        }
      },
      async barcharts(){
        await axios.post(site_url + '/dashboards/inbound_lead_generation/barcharts', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
          /*HC_Bar_Percent_Fill('leads_today',null,{
            actual_value:data.data.leads.actual_value,
            target_value:data.data.leads.target_value,
          });*/

          var refs = Object.keys(data.data.refs);
          refs.forEach(ref => {
            this.$refs[ref].innerText = data.data.refs[ref];
          });

          var globals = Object.keys(data.data.globals);
          globals.forEach(global => {
            this.globals[global] = data.data.globals[global];
          });

          HC_Bar('leads_by_source',null,{
            categories:data.data.leads_by_source.categories,
            text:data.data.leads_by_source.text,
            data:data.data.leads_by_source.data,
            text_on_bar:'leads'
          })
          HC_Bar('leads_by_pipeline',null,{
            categories:data.data.leads_by_pipeline.categories,
            text:data.data.leads_by_pipeline.text,
            data:data.data.leads_by_pipeline.data,
            text_on_bar:'leads'
          })
          HC_Bar('leads_by_form',null,{
            categories:data.data.leads_by_form.categories,
            text:data.data.leads_by_form.text,
            data:data.data.leads_by_form.data,
            text_on_bar:'leads'
          })

        });

      },

      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },


      filter(data, callback) {
          return data.filter(callback);
      },
    },
    template:'#inbound_lead_generation',
}
