import {HC_Line_Area,HC_Area_Timeseries_LineAVG } from "../../helpers.js";

export default {
    name: 'SalesCycle',
    data() {
        return {
            period_filter: '30d',
            date_from: '',
            date_to: '',
            values: [0],
            labels: [''],
            subLabels: [],
            extraData: [],

            employees:[]
        };
    },
    mounted: function () {
        this.load_data();

    },
    methods: {
      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
      load_data(){
        this.funnel();
        this.chart_avarage_sales_cycle();
        this.employee_performance();
      },
      async funnel(){
        await axios.post(site_url + '/dashboards/sales_cycle/funnel', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
          this.values = data.data.values;
          this.labels = data.data.labels;
          this.subLabels = data.data.subLabels;

          this.extraData = data.data.extraData;
        });

      },
      async chart_avarage_sales_cycle(){
        await axios.post(site_url + '/dashboards/sales_cycle/avarage_sales_cycle', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
            HC_Area_Timeseries_LineAVG('chart_avarage_sales_cycle',data.data.series,data.data.categories);

        });

      },
      async employee_performance(){
        this.employees = [];
        await axios.post(site_url + '/dashboards/sales_cycle/employee_performance', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
          this.employees = data.data.employees;

        });

      },
      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },


      filter(data, callback) {
          return data.filter(callback);
      },
    },
    template:'#sales_cycle',
}
