import {HC_AreaSpline} from "../../helpers.js";

export default {
    name: 'SalesKpi',
    data() {
        return {
            period_filter: '30d',
            date_from: '',
            date_to: '',

            delta_sales_num:0,delta_sales_value:0,
            delta_sales_cost:0,delta_total_sales_profit:0,

        };
    },
    mounted: function () {
        this.load_data();

    },
    methods: {
      async allcharts(){
        await axios.post(site_url + '/dashboards/sales_kpi/allcharts', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
            HC_AreaSpline('chart_new_generated_sales_revenue',
              [{
                  name: this.$t('charts.all_channels'),
                  data: data.data.allchannels,
                  color:'#17d6b2',
                  marker: {
                      enabled: false
                  }

              },
              {
                  name: this.$t('charts.new_revenue'),
                  data: data.data.sales_from_opp,
                  color:'#008080',
                  marker: {
                      enabled: false
                  }
              }

            ],{xcategories:data.data.xcategories}
          )

            var refs = Object.keys(data.data.refs);
            refs.forEach(ref => {
              this.$refs[ref].innerText = data.data.refs[ref];
            });

            this.delta_sales_num = data.data.delta_sales_num;

        });

      },
      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
      load_data(){
        this.allcharts();
      },
      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },


      filter(data, callback) {
          return data.filter(callback);
      },
    },
    template:'#sales_kpi',
}
