export default {
    name: 'TableCustomerSales',
    data() {
        return {
            endpoint:site_url + '/dashboards/tactical_finance/customer_sales',
            page: 1,
            list: [],
            infiniteId: +new Date(),
        };
    },
    props:{
      period_filter: {
        default: '30d',
        type: String,
      },
      date_from: {
        default: null,
        type: String,
      },
      date_to: {
        default: null,
        type: String,
      },
    },
    mounted: function () {

    },
    created: function() {
     this.$parent.$on('load_data', this.reload_data);
    },
    methods: {
      reload_data(period_filter = null){
        this.page = 1;
        this.list = [];
        this.infiniteId += 1;
      },
      notEmptyObject(someObject) {
        return Object.keys(someObject).length
      },
      infiniteHandler($state) {
        setTimeout(() => {
          axios.post(this.endpoint, {
              params: {
                  period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
              },
              [csrf_token_name]: csrf_hash,
              page: this.page,
            })
            .then(({
              data
            }) => {
              if (data.results.length) {
                this.page += 1;
                this.list.push(...data.results);
                $state.loaded();
              } else {
                $state.complete();
              }
            })
            .catch(err => {
              console.log(err);
            });
        }, 800);
      },
    },
  template:'#table_customer_sales',
  beforeDestroy() {
    //clearInterval(this.timer)
  },
  components: {
    VueInfiniteLoading
  }
}
