import {HC_Pie} from "../../helpers.js";

export default {
    name: 'TeamPassword',
    data() {
        return {
            loaded:false,
            period_filter: 'all',
            date_from: '',
            date_to: '',
            total_password:0,normal_password:0,bank_account:0,credit_card:0,email:0,server:0,software_license:0,shared:0
        };
    },
    mounted: function () {
        this.load_data();

    },
    methods: {
      async allcharts(){
        await axios.post(site_url + '/dashboards/team_password/allcharts', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
            HC_Pie('password_quantity_by_category',
            [{
              type: 'pie',
              innerSize: '80%',
              data: data.data.arr_passwords_percents
            }],{plotSize:'100', 'hasLabels':true }
            )

            HC_Pie('password_total_share_by_type',
            [{
              type: 'pie',
              innerSize: '80%',
              data: data.data.arr_shared_percents
            }],{plotSize:'100', 'hasLabels':true }
            )
            /*console.log(data.data.vars);
            var vars = Object.keys(data.data.vars);
            vars.forEach(var => {
              this[var] = data.data.vars[var];
            });*/

            this.total_password = data.data.vars.total_password;
            this.normal_password = data.data.vars.normal_password;
            this.bank_account = data.data.vars.bank_account;
            this.credit_card = data.data.vars.credit_card;
            this.email = data.data.vars.email;
            this.server = data.data.vars.server;
            this.software_license = data.data.vars.software_license;
            this.shared = data.data.vars.shared;

        });

      },
      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
      load_data(){
        this.loaded = false;
        this.allcharts();
        this.loaded = true;
      },
      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },


      filter(data, callback) {
          return data.filter(callback);
      },
    },
    template:'#team_password',
}
