export default {
  name: 'VAppDatePicker',
  template: '#vue-datepicker',
    props:['dateFrom', 'dateTo'],
    data: function(){
        return {
            frm: this.date_from,
            to: this.date_to
        }
    },
    mounted: function(){
        var self = this;
        this.$nextTick(function(){
            $(this.$el).find('#date-from').datepicker({
                dateFormat: "yy-mm-dd",
                onSelect: function(selectedDate){
                    if (selectedDate){
                        self.frm = selectedDate;
                        self.selectDate(selectedDate, true);
                    }
                }
            });
            $(this.$el).find('#date-to').datepicker({
                dateFormat: "yy-mm-dd",
                onSelect: function(selectedDate){
                    if (selectedDate) {
                        self.to = selectedDate;
                        self.selectDate(selectedDate, false);
                    }
                }
            });
        });
    },
    methods: {
        selectDate: function(selectedDate, isFrom){
            if (isFrom){
                $(this.$el).find("#date-to").datepicker("option", "minDate", selectedDate);
            } else {
                $(this.$el).find("#date-from").datepicker("option", "maxDate", selectedDate);
            }
            this.$emit('selected-date', selectedDate, isFrom)
        },
        changeFrom: function(){
            $(this.$el).find("#date-from").datepicker("setDate",  this.frm);
            this.frm = $(this.$el).find("#date-from").val();
            this.selectDate(this.frm, true);
        },
        changeTo: function(){
            $(this.$el).find("#date-to").datepicker("setDate",  this.to);
            this.to = $(this.$el).find("#date-to").val();
            this.selectDate(this.to, false);
        }
    }

}
