import {HC_Column_line_percents,HC_Column_line,HC_Area,HC_Columns,HC_Columns_Stacked} from "../../helpers.js";

export default {
    name: 'HelpDesk',
    data() {
        return {
            period_filter: '30d',
            date_from: '',
            date_to: '',

            title_chart__daily_support_trends:'',
            title_chart__daily_support_trends2:'',

        };
    },
    mounted: function () {
        this.load_data();
    },
    methods: {
      load_data(){
        this.num_tickets_by_hour();
        this.daily_support_trends();
        this.hourly_tickets_by_month();
        this.daily_tickets_by_month();
        this.response_time_trend();
        this.response_time_groupped();
      },
      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },

        async num_tickets_by_hour() {
            await axios.post(site_url + '/dashboards/helpdesk/num_tickets_by_hour', {
                params: {
                    period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

                }, //page: this.page,
                [csrf_token_name]: csrf_hash,

            })
            .then(data => {
                //this.current_opportunities = data.data;
                HC_Column_line_percents('chart__tickets_by_h',
                [{
                    name: this.$t('charts.chart__tickets_by_h__num_tickets'),
                    type: 'column',
                    color:'#1caf9a',
                    yAxis: 1,
                    data: data.data.tickets, //[26,4,5,8,4,7,9,0,2],
                    tooltip: {
                    valueSuffix: ' '
                  },
                    //  max: data.data.max_tickets,endOnTick: false
                }, {
                    name: this.$t('charts.chart__tickets_by_h__perc_tickets'),
                    color:'#17A2B8',
                    type: 'spline',
                    data: data.data.perc_of_all_tickets, //[3,10,4,6,1,14,16,2,2],
                    tooltip: {
                    valueSuffix: '%'
                    }
                }],
                {'xcategories':data.data.xcategories}
              )

            });
        },
        async daily_support_trends() {
            await axios.post(site_url + '/dashboards/helpdesk/trend_daily_tickets', {
                params: {
                    period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

                }, //page: this.page,
                [csrf_token_name]: csrf_hash,

            })
            .then(data => {
                HC_Area('chart__daily_support_trends',
                [{
                    name: data.data.title_xaxis_chart__daily_support_trends,
                    color:'#1caf9a',
                    data:  data.data.values_daily_support_trends,
                }],
                {'yaxis':{'text':data.data.title_xaxis_chart__daily_support_trends} }
                )
                HC_Area('chart__daily_support_trends2',
                [{
                    name: data.data.title_xaxis_chart__daily_support_trends2,
                    color:'#1caf9a',
                    data:  data.data.values_daily_support_trends2,
                }],
                {'yaxis':{'text':data.data.title_xaxis_chart__daily_support_trends2} }
                )
                this.title_chart__daily_support_trends = data.data.title_chart__daily_support_trends;
                this.title_chart__daily_support_trends2 = data.data.title_chart__daily_support_trends2;
            });
        },
        async hourly_tickets_by_month() {
            await axios.post(site_url + '/dashboards/helpdesk/hourly_tickets_by_month', {
                params: {
                    period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

                }, //page: this.page,
                [csrf_token_name]: csrf_hash,

            })
            .then(data => {
                HC_Column_line('chart__hourly_tickets_by_month',
                [{
                    name: this.$t('charts.chart__hourly_tickets_by_month__tickets'),
                    color:'#1caf9a',
                    type: 'column',
                    yAxis: 1,
                    data: data.data.num_tickets,
                    tooltip: {
                      valueSuffix: ' ',
                    }

                }, {
                    name: this.$t('charts.chart__hourly_tickets_by_month__of_all'),
                    color:'#17A2B8',
                    type: 'spline',
                    data: data.data.perc_of_all_tickets,
                    tooltip: {
                      valueSuffix: ''
                    }
                }],
                {'ytitle_column':this.$t('charts.chart__hourly_tickets_by_month__y_tickets_filtered'),'ytitle_spline':this.$t('charts.chart__hourly_tickets_by_month__y_all_tickets')}
                //{'yaxis':{'text':data.data.title_xaxis_chart__daily_support_trends} }
                )
            });
        },
        async daily_tickets_by_month() {
          await axios.post(site_url + '/dashboards/helpdesk/daily_tickets_by_month', {
              params: {
                  period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

              }, //page: this.page,
              [csrf_token_name]: csrf_hash,

          })
          .then(data => {
            HC_Columns('chart__daily_tickets_by_month',
            [{
                name: this.$t('charts.chart__daily_tickets_by_month__per_day'),
                color:'#17A2B8',
                data: data.data.avg_filtered_tickets

            }, {
                name: this.$t('charts.chart__daily_tickets_by_month__all_time_per_day'),
                color:'#1caf9a',
                data: data.data.avg_all_tickets

            }],
            {'xcategories':[
              this.$t('general.mo_Jan'),
              this.$t('general.mo_Feb'),
              this.$t('general.mo_Mar'),
              this.$t('general.mo_Apr'),
              this.$t('general.mo_May'),
              this.$t('general.mo_Jun'),
              this.$t('general.mo_Jul'),
              this.$t('general.mo_Aug'),
              this.$t('general.mo_Sep'),
              this.$t('general.mo_Oct'),
              this.$t('general.mo_Nov'),
              this.$t('general.mo_Dec')
          ],'ytitle':this.$t('charts.chart__daily_tickets_by_month___title_per_day') }

            )
          });


        },
        async response_time_trend(){
          await axios.post(site_url + '/dashboards/helpdesk/response_time_trend', {
              params: {
                  period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

              }, //page: this.page,
              [csrf_token_name]: csrf_hash,

          })
          .then(data => {

            HC_Column_line('chart__response_time_trend',
            [{
                name: this.$t('charts.chart__response_time_trend__minutes'),
                color:'#17A2B8',
                type: 'column',
                yAxis: 1,
                data: data.data.filtered_response_time,
                tooltip: {
                valueSuffix: ' '
                }

            }, {
                name: this.$t('charts.chart__response_time_trend__alltime_trend'),
                color:'#1caf9a',
                type: 'spline',
                data: data.data.alltime_response_time,
                tooltip: {
                valueSuffix: ''
                }
            }],
            {'xcategories':['00','01','02','03','04','05','06','07'],'ytitle_column':this.$t('charts.chart__response_time_trend__ytitle_column'),'ytitle_spline':this.$t('charts.chart__response_time_trend__ytitle_spline')}
            )

          });

        },
        async response_time_groupped(){
          await axios.post(site_url + '/dashboards/helpdesk/response_time_groupped', {
              params: {
                  period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

              }, //page: this.page,
              [csrf_token_name]: csrf_hash,

          })
          .then(data => {

            /*  HC_Columns_Stacked('chart__response_time_groupped',
              [{
                  name: '< 1 Hour',
                  color:'#17A2B8',
                  data: data.data.group_1
              }, {
                  name: '1 - 4 Hours',
                  color:'#1caf9a',
                  data: data.data.group_2
              }, {
                  name: '4 - 24 Hours',
                  color:'#5058ab',
                  data: data.data.group_3
              }, {
                  name: '> 24 Hours',
                  color:'#6f42c1',
                  data: data.data.group_4
              }

              ],
              {'xcategories':[
              'Jan',
              'Feb',
              'Mar',
              'Apr',
              'May',
              'Jun',
              'Jul',
              'Aug',
              'Sep',
              'Oct',
              'Nov',
              'Dec'
            ]}
          )*/

          });
        },
        filter(data, callback) {
            return data.filter(callback);
        },
    },
    template:'#helpdesk',
}
