import {CreateChart_Pie} from "../../helpers.js";

export default {
    name: 'OkrDashboard',
    template: `
      <div class="x-content">

      <div class="row pl-5 pr-5">
        <div class="col-md-4">
          <div class="dashcard-2">
            <div class="dashcard__header border">
              <div class="dashcard__header_title">{{ $t("okr_dashboard.okr_progressing_well") }}</div>
              <div class="dashcard__header_right_title"></div>
            </div>
            <div class="dashcard__body">
              <div class="dashcard__widget1">
                <h4 class="dashcard__widget1_title text-center">+{{ data.progress_good }}</h4>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="dashcard-2">
            <div class="dashcard__header border">
              <div class="dashcard__header_title">{{ $t("okr_dashboard.okr_developing") }}</div>
              <div class="dashcard__header_right_title"></div>
            </div>
            <div class="dashcard__body">
              <div class="dashcard__widget1">
                <h4 class="dashcard__widget1_title text-center">+{{ data.progress_develope }}</h4>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="dashcard-2">
            <div class="dashcard__header border">
              <div class="dashcard__header_title">{{ $t("okr_dashboard.okr_risk") }}</div>
              <div class="dashcard__header_right_title"></div>
            </div>
            <div class="dashcard__body">
              <div class="dashcard__widget1">
                <h4 class="dashcard__widget1_title text-center">+{{ data.progress_risk }}</h4>
              </div>
            </div>
          </div>
        </div>
        <br>
      </div>
      <br>
      <div class="row pl-5 pr-5">
      <div class="col-md-12">
        <div class="dashcard-2">
          <div class="dashcard__header border">
            <div class="dashcard__header_title">{{ $t("okr_dashboard.check_in_status") }}</div>
            <div class="dashcard__header_right_title"></div>
          </div>
          <div id="container_ck" class="col-12"></div>
        </div>
        <br>
        <div class="row">
          <div class="col-md-6">
            <div class="dashcard-2">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><i class="fal fa-group mright5"></i>{{ $t("okr_dashboard.okrs_company") }}
                </div>
                <div class="dashcard__header_right_title"></div>
              </div>
              <div class="dashcard__body">
                <div class="dashcard__widget1">
                  <span class="dashcard__widget1_figures text-center">
                      <h4 class="mg-b-0 tx-sm">{{ $t("okr_dashboard.objective") }}:{{ data.okrs_company.okrs_count }}
                      </h4>
                  </span>
                  <span class="dashcard__widget1_figures text-center">
                    <h4 class="mg-b-0 tx-sm">{{ $t("okr_dashboard.progress") }}
                        <div class="progress progress_cus_tranform">
                            <div class="progress-bar" role="progressbar"
                                 v-bind:aria-valuenow="data.okrs_company.okrs_progress"
                                v-bind:style="'width:' + data.okrs_company.okrs_progress + '%;'"
                                v-bind:data-percent="data.okrs_company.okrs_progress">
                              {{ data.okrs_company.okrs_progress != undefined ? Math.round(data.okrs_company.okrs_progress) + '%' : 0 + '%' }}
                            </div>
                        </div>
                    </h4>
                  </span>
                  <span class="dashcard__widget1_figures text-center  tx-good">
                      <h4 class="mg-b-0 tx-sm">{{ $t("okr_dashboard.confidence_level") }}
                    <div class="progress progress_cus_tranform">
                      <div class="progress-bar progress-bar-success" role="progressbar"
                           v-bind:aria-valuenow="Math.round(data.okrs_company.html[2], -1)"
                           v-bind:style="'width:'+data.okrs_company.html[2]+'%;'"
                           v-bind:data-percent="Math.round(data.okrs_company.html[2], -1)">
                        {{ data.okrs_company.html[2] != null ? Math.round(data.okrs_company.html[2], -1) + '%' : 0 + '%' }}
                      </div>
                  <div class="progress-bar progress-bar-warning" role="progressbar"
                       v-bind:aria-valuenow="Math.round(data.okrs_company.html[0], -1)"
                       v-bind:style="'width:'+data.okrs_company.html[0]+'%;'"
                       v-bind:data-percent="Math.round(data.okrs_company.html[0], -1)">
                    {{ data.okrs_company.html[0] != null ? Math.round(data.okrs_company.html[0], -1) + '%' : 0 + '%' }}
                  </div>
                  <div class="progress-bar progress-bar-danger" role="progressbar"
                       v-bind:aria-valuenow="Math.round(data.okrs_company.html[1], -1)"
                       v-bind:style="'width:'+data.okrs_company.html[1]+'%;'"
                       v-bind:data-percent="Math.round(data.okrs_company.html[1], -1)">
                    {{ data.okrs_company.html[1] != null ? Math.round(data.okrs_company.html[1], -1) + '%' : 0 + '%' }}
                  </div>
                </div>
                    </h4>
                  </span>
                  <span class="dashcard__widget1_figures text-center">
                      <h4 class="mg-b-0 tx-sm">{{ $t("okr_dashboard.key_results") }} :{{ data.okrs_company.okrs_keyres }}
                      </h4>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="dashcard-2">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><i class="fal fa-group mright5"></i>{{ $t("okr_dashboard.my_okrs") }}
                </div>
                <div class="dashcard__header_right_title"></div>
              </div>
              <div class="dashcard__body">
                <div class="dashcard__widget1">
                  <span class="dashcard__widget1_figures text-center">
                      <h4 class="mg-b-0 tx-sm">{{ $t("okr_dashboard.objective") }}:{{ data.okrs_user.okrs_count }}
                      </h4>
                  </span>
                  <span class="dashcard__widget1_figures text-center">
                    <h4 class="mg-b-0 tx-sm">{{ $t("okr_dashboard.progress") }}
                      <div class="progress progress_cus_tranform">
                            <div class="progress-bar" role="progressbar"
                                 v-bind:aria-valuenow="data.okrs_user.okrs_progress"
                                 v-bind:style="'width:' + data.okrs_user.okrs_progress + '%;'"
                                 v-bind:data-percent="data.okrs_user.okrs_progress">
                              {{ data.okrs_user.okrs_progress != undefined ? Math.round(data.okrs_user.okrs_progress) + '%' : 0 + '%' }}
                            </div>
                        </div>
                    </h4>
                  </span>
                  <span class="dashcard__widget1_figures text-center  tx-good">
                      <h4 class="mg-b-0 tx-sm">{{ $t("okr_dashboard.confidence_level") }}
                    <div class="progress progress_cus_tranform">
                      <div class="progress-bar progress-bar-success" role="progressbar"
                           v-bind:aria-valuenow="Math.round(data.okrs_user.html[2], -1)"
                           v-bind:style="'width:'+data.okrs_user.html[2]+'%;'"
                           v-bind:data-percent="Math.round(data.okrs_user.html[2], -1)">
                        {{ data.okrs_user.html[2] != null ? Math.round(data.okrs_user.html[2], -1) + '%' : 0 + '%' }}
                      </div>
                  <div class="progress-bar progress-bar-warning" role="progressbar"
                       v-bind:aria-valuenow="Math.round(data.okrs_user.html[0], -1)"
                       v-bind:style="'width:'+data.okrs_user.html[0]+'%;'"
                       v-bind:data-percent="Math.round(data.okrs_user.html[0], -1)">
                    {{ data.okrs_user.html[0] != null ? Math.round(data.okrs_user.html[0], -1) + '%' : 0 + '%' }}
                  </div>
                  <div class="progress-bar progress-bar-danger" role="progressbar"
                       v-bind:aria-valuenow="Math.round(data.okrs_user.html[1], -1)"
                       v-bind:style="'width:'+data.okrs_user.html[1]+'%;'"
                       v-bind:data-percent="Math.round(data.okrs_user.html[1], -1)">
                    {{ data.okrs_user.html[1] != null ? Math.round(data.okrs_user.html[1], -1) + '%' : 0 + '%' }}
                  </div>
                </div>
                    </h4>
                  </span>
                  <span class="dashcard__widget1_figures text-center">
                      <h4 class="mg-b-0 tx-sm">{{ $t("okr_dashboard.key_results") }} :{{ data.okrs_user.okrs_keyres }}
                      </h4>
                  </span>
                </div>
              </div>
            </div>
          </div>
        </div>
        </div>
      </div>
        </div>
    `,
    data() {
        return {
            data: {'progress_good':0,'progress_develope':0,'progress_risk':0},
            checkinStatus: null,
            period_filter: '30d',
            chart: {
                'checkin_status': null
            },
        };
    },
    mounted: function () {
        this.load_data();
    },
    updated: function () {
        this.$nextTick(function () {
            CreateChart_Pie('container_ck', JSON.parse(this.data.checkin_status));
        })
    },
    methods: {
        load_data() {
            let self = this;
            axios.get(site_url + 'index.php/dashboards/okrDashboardController/get_data', {
                params: {
                    period_filter: self.period_filter,
                }
            })
                .then(data => {
                    self.data = data.data;
                    // let yahooOnly = self.data.okrs.filter(function (entry) {
                    //     return entry.datecreator === "2021-12-27 13:46:04";
                    // });
                    // console.log(yahooOnly);
                });
        },
    },

};
