import {CreateChart_Column, CreateChart_SemiGauge} from '../../helpers.js'


export default {
    name: 'SalesConversion',
    data() {
        return {
            is_loading: true,
            global: {},
            period_filter: '30d',
            date_from: '',
            date_to: '',

            show_percent: false,
            chartData_1: [],


            sales_agents: [],
            statuses: {},
            valid_conversion_ratio:false,
            leads_for_a_win:0,
            base_ration_leads_for_client:0
        };
    },
    mounted: function () {
        this.load_data();
        this.load_statuses();
    },
    methods: {
        updated(selectedDate, isFrom) {
            if (isFrom) {
                this.date_from = selectedDate;
            } else {
                this.date_to = selectedDate;
            }
        },
        load_statuses() {
            axios.get(site_url + 'index.php/dashboards/salesConversionController/get_statuses')
                .then(data => {
                    //console.table(data.data);
                    this.statuses = data.data;
                });
        },
        load_data() {
            if (this.period_filter == 'p') {
                //appDatepicker();
                //$('.datepicker').datepicker({});
            }
            if (!this.date_from && this.period_filter == 'p') {
                return;
            }
            if (!this.date_to && this.period_filter == 'p') {
                return;
            }
            this.is_loading = true;

            //this.chart.leads_to_opportunity = CreateChart_SemiGauge('chart-2', this.chartData.leads_to_opportunity)
            //this.chart.opportunity_to_win = CreateChart_SemiGauge('chart-3', this.chartData.opportunity_to_win)
            this.sales_agents = []

            // setTimeout(() => {
            axios.post(site_url + 'index.php/dashboards/api/get_sales_conversion', {
                params: {
                    period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

                }, //page: this.page,
                [csrf_token_name]: csrf_hash,

            })
                .then(({
                           data
                       }) => {
                    if (data.results) {
                        //this.list.push(...data.results);

                        //$state.loaded();

                        // this.$set(this.global, 'global', data.results.global);
                        this.global = data.results.global;
                        this.sales_agents = data.results.sales_agents;

                        /*
                        this.chartData.converted_leads = data.results.converted_leads;
                        this.chartData.leads_to_opportunity = data.results.leads_to_opportunity;
                        this.chartData.leads_to_opportunity__title_text = data.results.leads_to_opportunity__title_text;

                        this.chartData.opportunity_to_win = data.results.opportunity_to_win;
                        this.chartData.opportunity_to_win__title_text = data.results.opportunity_to_win__title_text;
                        */

                        this.is_loading = false;
                        //CreateChart_Column('chart-1', this.chartData.converted_leads)
                        CreateChart_Column('chart-1', data.results.converted_leads)
                        this.valid_conversion_ratio = data.results.valid_conversion_ratio;
                        this.leads_for_a_win = data.results.leads_for_a_win;
                        this.base_ration_leads_for_client = data.results.base_ration_leads_for_client;




                        CreateChart_SemiGauge('chart-2', data.results.leads_to_opportunity,{title:data.results.leads_to_opportunity__title_text})
                        CreateChart_SemiGauge('chart-3',  data.results.opportunity_to_win,{title:data.results.opportunity_to_win__title_text})

                    } else {
                        //$state.complete();
                        //console.log('An error occurred 2');
                    }
                })
                .catch(err => {
                    //console.log('An error occurred');
                    //console.log(err);
                });
            // }, 200);
        }

    },
    template: '#sales_conversion'
};
