import {CreateChart_Bar} from "../../helpers.js";
//import {loadLanguageAsync} from '../../i18n_func.js';

export default {
    name: 'SalesOpportunity',
    data() {
        return {
          period_filter: '30d',
          date_from: '',
          date_to: '',

          base_currency:'',
          count_opportunities:0,
          previous_opportunities:0,
          opportunities_change:0,
          tx_opportunities_change:'',

          current_purchase_value_otf:0,
          previous_purchase_value_otf:0,
          tx_purchase_value_change_otf:'',
          current_purchase_value_mrr:0,
          previous_purchase_value_mrr:0,
          tx_purchase_value_change_mrr:'',

          avg_current_purchase_value_otf:0,
          avg_previous_purchase_value_otf:0,
          tx_avg_purchase_value_change_otf:'',
          avg_current_purchase_value_mrr:0,
          avg_previous_purchase_value_mrr:0,
          tx_avg_purchase_value_change_mrr:'',

          current_win_rate:0,
          previous_win_rate:0,
          tx_win_rate_change:'',

          stages:[],
          opp_status:'',

          //table loading
          opportunities: [],
          endpoint:site_url + '/dashboards/sales_opportunity/list_opportunities',
          page: 1,
          infiniteId: +new Date(),
        };
    },
    mounted: function () {
        this.load_data();

    },
    methods: {


      load_data(){
        this.load_oop_stages();
        this.load_OPAW();
        this.reload_table_data();
      },
      async load_oop_stages() {
          await axios.get(site_url + '/dashboards/salesOpportunityController/get_oop_stages')
              .then(data => {
                  this.stages = data.data;
              });
      },
      async load_OPAW() {
        await axios.post(site_url + '/dashboards/sales_opportunity/load_opaw', {
            params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
            },
            [csrf_token_name]: csrf_hash,
        })
        .then(data => {
          var result = data.data;
          Object.keys(result).forEach(key => {
            this[key] = result[key];
          });
          CreateChart_Bar('chart_reasons_lost_opportunities', [{
              name: 'OTF',
              data: data.data.reasons_ot,
              color: '#17A2B8',
          }, {
              name: 'MRR',
              data: data.data.reasons_mo,
              color: '#5058ab'
          }/*, {
              type: 'area',
              name: 'Count',
              data: data.data.reasons_total_count,
              color: '#5058ab'
          }*/], data.data.reasons_categories)

        });
      },
      reload_table_data(period_filter = null){
        this.page = 1;
        this.opportunities = [];
        this.infiniteId += 1;
      },
      infiniteHandler($state) {
        setTimeout(() => {
          axios.post(this.endpoint, {
              params: {
                period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,
                opp_status:this.opp_status
              },
              [csrf_token_name]: csrf_hash,
              page: this.page,
            })
            .then(({
              data
            }) => {
              if (data.results.length) {
                this.page += 1;
                this.opportunities.push(...data.results);
                $state.loaded();
              } else {
                $state.complete();
              }
            })
            .catch(err => {
              console.log(err);
            });
        }, 800);
      },

      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
      filter(data, callback) {
          return data.filter(callback);
      },
    },
    template: '#sales_opportunity',
}
