export default {
    template: '#skeleton',
    name: `Skeleton`,
    data() {
        return {
            is_active: false,
        };
    },
     props: {
       maxWidth: {
         default: 100,
         type: Number,
       },
       minWidth: {
         default: 80,
         type: Number,
       },
       height: {
         default: `1em`,
         type: String,
       },
       width: {
         default: null,
         type: String,
       },
       bgcolor: {
         default: null,
         type: String,
       },
     },
     computed: {
       computedWidth() {
         if(!this.is_active){ return 0; }
         return this.width || `${Math.floor((Math.random() * (this.maxWidth - this.minWidth)) + this.minWidth)}%`;
       },
     },


}
