import {HC_Line_Area} from "../../helpers.js";

export default {
    name: 'TacticalFinance',
    data() {
        return {
            period_filter: '30d',
            date_from: '',
            date_to: '',

            income_total_sum:'',
            income_total_sum_prev:'',
            income_delta:'',
            expenses_total_sum: '',
            expenses_total_sum_prev:'',
            expenses_delta:'',
            net_profit_total_sum: '',
            net_profit_total_sum_prev:'',
            net_profit_delta:'',
        };
    },
    mounted: function () {
        this.load_data();

    },
    methods: {
      filter_on_change(){
        this.$emit('load_data',this.period_filter);
        this.load_data();
      },
      load_data(){
        this.load_income();
        this.load_expenses();
        this.load_net_profit();
      },
      updated(selectedDate, isFrom) {
          if (isFrom) {
              this.date_from = selectedDate;
          } else {
              this.date_to = selectedDate;
          }
      },

        async load_income() {
            await axios.post(site_url + '/dashboards/tactical_finance/load_income', {
                params: {
                    period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

                }, //page: this.page,
                [csrf_token_name]: csrf_hash,

            })
            .then(data => {
                //this.current_opportunities = data.data;
                HC_Line_Area('chart__income',
                [
                  {
                    name: this.$t('charts.chart__income__sales'),
                    data: data.data.values
                  },
                  {
                    color: 'transparent',
                    enableMouseTracking: false,
                    showInLegend: false,
                    data: [1]
                  }
                ],{plot:{color:'#17A2B8'}}
              )
              this.income_total_sum = data.data.total_sum
              this.income_total_sum_prev = data.data.total_sum_prev
              this.income_delta = data.data.delta


            });
        },
        async load_expenses() {
            await axios.post(site_url + '/dashboards/tactical_finance/load_expenses', {
                params: {
                    period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

                }, //page: this.page,
                [csrf_token_name]: csrf_hash,

            })
            .then(data => {
                //this.current_opportunities = data.data;
                HC_Line_Area('chart__expenses',
                [
                  {
                    name: this.$t('charts.chart__expenses__title'),
                    data: data.data.values
                  },
                  {
                    color: 'transparent',
                    enableMouseTracking: false,
                    showInLegend: false,
                    data: [1]
                  }
                ],{plot:{color:'#e83e8c'}}
              )
                this.expenses_total_sum = data.data.total_sum
                this.expenses_total_sum_prev = data.data.total_sum_prev
                this.expenses_delta = data.data.delta
            });
        },
        async load_net_profit() {
            await axios.post(site_url + '/dashboards/tactical_finance/load_net_profit', {
                params: {
                    period_filter: this.period_filter, date_from: this.date_from, date_to: this.date_to,

                }, //page: this.page,
                [csrf_token_name]: csrf_hash,

            })
            .then(data => {
                //this.current_opportunities = data.data;
                HC_Line_Area('chart__net_profit',
                [
                  {
                    name: this.$t('charts.chart__net_profit__title'),
                    data: data.data.values
                  },
                  {
                    color: 'transparent',
                    enableMouseTracking: false,
                    showInLegend: false,
                    data: [1]
                  }
                ],{plot:{color:'#1caf9a'}}
              )
              this.net_profit_total_sum = data.data.total_sum
              this.net_profit_total_sum_prev = data.data.total_sum_prev
              this.net_profit_delta = data.data.delta

            });
        },
        filter(data, callback) {
            return data.filter(callback);
        },
    },
    template:'#tactical_finance',
}
