<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';
class Ceo_strategic extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit(blank_page());
        $this->load->model('dashboard_model');
        $this->load->model('dashboard_period_filter');
        $this->load->library('dashboard');
        $this->load->model('currencies_model');
        $this->base_currency = $this->currencies_model->get_base_currency();
        
    }

    public function index()
    {
        close_setup_menu();
        $data['title']  = _l(DASHBOARDS_MODULE.'_'.$this->router->fetch_class());
        if (!has_permission(DASHBOARDS_MODULE, '', $this->router->fetch_class())  && !is_admin()) {
            access_denied(DASHBOARDS_MODULE);
        }
        $this->load->view($this->router->fetch_class(), $data);
    }
    public function cards(){
        if(get_option('demo_mode') == '1'){
          $faker = Faker\Factory::create();
          $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));

            $return = [
                'dashcards'=>[
                    'leads'=>[
                      "title"=> _l('title_leads'),
                      "subtitle"=>"",
                      "figure"=>$faker->leads(),
                      "figure_delta"=>$faker->change_leads(),
                    ],
                  'iql'=>[
                    "title"=> _l('title_iql'),
                    "subtitle"=>"",
                    "figure"=>$faker->iql(),
                    "figure_delta"=>$faker->change_iql(),
                  ],
                  'mql'=>[
                    "title"=> _l('title_mql'),
                    "subtitle"=>"",
                    "figure"=>$faker->mql(),
                    "figure_delta"=>$faker->change_mql(),
                  ],
                  'sql'=>[
                    "title"=> _l('title_sql'),
                    "subtitle"=>"",
                    "figure"=>$faker->sql(),
                    "figure_delta"=>$faker->change_sql(),
                  ],
                  'clients'=>[
                    "title"=> _l('title_clients'),
                    "subtitle"=>"",
                    "figure"=>$faker->converted_clients,
                    "figure_delta"=>$faker->lead_conversion_rate_change,
                  ],
                'contacts'=>[
                  "title"=> _l('title_contacts'),
                  "subtitle"=>"",
                  "figure"=>$faker->num_contacts,
                  "figure_delta"=>$faker->contacts_change,
                ],
                'cpost_per_lead'=>[
                  "title"=> _l('title_cost_per_lead'),
                  "subtitle"=>"",
                  "figure"=>strtoupper(_l('total')).': '. $faker->numberBetween(10,100) .' '.$this->base_currency->symbol,
                  "figure_delta"=>$faker->random_change_percent(),
                ],
                'cost_per_mql'=>[
                  "title"=> _l('title_cost_per_mql'),
                  "subtitle"=>"",
                  "figure"=>strtoupper(_l('total')).': '. $faker->numberBetween(20,200) .' '.$this->base_currency->symbol,
                  "figure_delta"=>$faker->random_change_percent(),
                ],


                'number_of_sales'=>[
                  "title"=> _l('title_number_of_sales'),
                  "subtitle"=>"",
                  "figure"=>$faker->numberBetween(1,120),
                  "figure_delta"=>$faker->random_change_percent(),
                ],
              'new_revenue'=>[
                "title"=> _l('title_new_revenue'),
                "subtitle"=>"",
                "figure"=>$faker->numberBetween(1000,100000).' '.$this->base_currency->symbol,
                "figure_delta"=>$faker->random_change_percent(),
              ],
              'cost'=>[
                "title"=> _l('title_cost'),
                "subtitle"=>"",
                "figure"=>$faker->numberBetween(1000,100000) .' '.$this->base_currency->symbol,
                "figure_delta"=>$faker->random_change_percent(),
              ],
              'profit_by_sale'=>[
                "title"=> _l('title_profit_by_sale'),
                "subtitle"=>"",
                "figure"=>$faker->numberBetween(1000/5,10000/5) .' '.$this->base_currency->symbol,
                "figure_delta"=>$faker->random_change_percent(),
              ],


                ],
                'translations'=>[

                ],


                'total_leads_prev'=>$faker->previous_leads,
        
                'globals'=>[
                  'delta_total_leads'=>$faker->random_change_percent(),
                  'delta_iql_leads'=>$faker->random_change_percent(),
                  'delta_mql_leads'=>$faker->random_change_percent(),
                  'delta_sql_leads'=>$faker->random_change_percent(),
                  'delta_total_clients'=>$faker->random_change_percent(),
                  'delta_total_contacts'=>$faker->random_change_percent(),
                  'delta_cost_per_lead'=>$faker->random_change_percent(),
                  'delta_cost_per_mql'=>$faker->random_change_percent(),
        
                ],
        
                'refs'=>[
                  'total_leads'=>$faker->leads(),
                  'delta_total_leads'=>$faker->random_change_percent(),
        
                  'iql_leads'=>$faker->iql(),
                  'delta_iql_leads'=>$faker->change_iql(),
        
                    'mql_leads'=>$faker->mql(),
                  'delta_mql_leads'=>$faker->change_mql(),
        
                  'sql_leads'=>$faker->sql(),
                  'delta_sql_leads'=>$faker->change_sql(),
        
                  'total_clients'=>$faker->converted_clients(),
                  'delta_total_clients'=>$faker->lead_conversion_rate_change(),
        
                  'total_contacts'=>$faker->converted_clients(),
                  'delta_total_contacts'=>$faker->lead_conversion_rate_change(),
        
                  'cost_per_lead'=>$faker->numberBetween(10,100),
                  'delta_cost_per_lead'=>$faker->random_change_percent(),
        
                  'cost_per_mql'=>$faker->numberBetween(20,200),
                  'delta_cost_per_mql'=>$faker->random_change_percent(),
                ]
        
              ];
              echo json_encode($return); exit;
        
         }
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);


      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $sales = $this->dashboard_period_filter
        ->prepare_filter()
        ->add_select('sum(tblinvoices.total) as sales_value')
        ->add_select('count(tblinvoices.id) as sales_num')
        //->add_select('sum(tblitems.purchase_price) as total_cost')
        //->add_select('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id) as profit_by_sale')

        //->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        //->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        //->join('tblitems','tblitems.id = tblitemable.item_id','LEFT')
        //->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency','LEFT')

        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->where('tblinvoices.clientid IN (SELECT opp.client_id FROM tblleads as opp WHERE opp.client_id = tblinvoices.clientid AND opp.is_opportunity = 1) ')
        //->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        //->group_by('tblinvoices.id')//->where('tblclients.active',1)
        ->row_fields(['sales_value','sales_num'],'number');

        //pre($this->db->last_query());

      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $this->dashboard_period_filter->set_prev_filtering();
      $prev_sales = $this->dashboard_period_filter
        ->prepare_filter()
        ->add_select('sum(tblinvoices.total) as sales_value')
        ->add_select('count(tblinvoices.id) as sales_num')

        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->where('tblinvoices.clientid IN (SELECT opp.client_id FROM tblleads as opp WHERE opp.client_id = tblinvoices.clientid AND opp.is_opportunity = 1) ')
        //->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        //->group_by('tblinvoices.id')//->where('tblclients.active',1)
        ->row_fields(['sales_value','sales_num'],'number');

        //pre($this->dashboard_period_filter->to_date);



      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $sales_cost = $this->dashboard_period_filter
        ->prepare_filter()
        ->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        ->join('tblitems','tblitems.id = tblitemable.item_id')
        ->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency')

        //Oportunitati
        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        ->group_by('tblinvoices.id')//->where('tblclients.active',1)
        //->group_by('sum(tblitems.purchase_price)')
        ->add_select('sum(tblitems.purchase_price) as total')->number('total');


      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $this->dashboard_period_filter->set_prev_filtering();
      $sales_cost_prev = $this->dashboard_period_filter
        ->prepare_filter()
        ->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        ->join('tblitems','tblitems.id = tblitemable.item_id')
        ->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency')

        //Oportunitati
        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        ->group_by('tblinvoices.id')//->where('tblclients.active',1)
        //->group_by('sum(tblitems.purchase_price)')
        ->add_select('sum(tblitems.purchase_price) as total')->number('total');


      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $total_sales_profit = $this->dashboard_period_filter
        ->prepare_filter()
        ->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        ->join('tblitems','tblitems.id = tblitemable.item_id')
        ->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency')

        //Oportunitati
        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        ->group_by('tblinvoices.id')//->where('tblclients.active',1)
        //->group_by('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id)')
        ->add_select('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id) as total')->number('total');

      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $this->dashboard_period_filter->set_prev_filtering();
      $total_sales_profit_prev = $this->dashboard_period_filter
        ->prepare_filter()
        ->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        ->join('tblitems','tblitems.id = tblitemable.item_id')
        ->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency')

        //Oportunitati
        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        ->group_by('tblinvoices.id')//->where('tblclients.active',1)
        //->group_by('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id)')
        ->add_select('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id) as total')->number('total');


      $this->dashboard_period_filter_v2->set_params($payload['params']);
      $filtered = $this->dashboard_period_filter_v2
        ->from('(SELECT "1") as faketbl')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as total_leads
        ')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0 AND qualification_type = 1
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as iql_leads
        ')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0 AND qualification_type = 2
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as mql_leads
        ')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0 AND qualification_type = 3
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as sql_leads
        ')

        ->select('
          (SELECT count(userid) FROM tblclients
            WHERE
            active IS NOT NULL
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreated','and').'
          ) as total_clients
        ')
        ->select('
          (SELECT count(id) FROM tblcontacts
            WHERE
            active IS NOT NULL
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreated','and').'
          ) as total_contacts
        ')

        ->select('
          (SELECT round(sum(total_budget),2) FROM tblleads
          JOIN tblmarketing_campaigns ON tblmarketing_campaigns.id = tblleads.id_from_campaign
            WHERE
            tblleads.status != 0
          ) as total_budget
        ')
        ->row_array();

        if($filtered['total_budget'] == 0 OR $filtered['total_leads'] == 0){
          $filtered['cost_per_lead'] = 0;
        }else{
          $filtered['cost_per_lead'] = round($filtered['total_budget']/$filtered['total_leads'],2);
        }

        if($filtered['total_budget'] == 0 OR $filtered['mql_leads'] == 0){
          $filtered['cost_per_mql'] = 0;
        }else{
          $filtered['cost_per_mql'] = round($filtered['total_budget']/$filtered['mql_leads'],2);
        }

        $this->dashboard_period_filter_v2->reset();
        $this->dashboard_period_filter_v2->set_params($payload['params']);
        $prev = $this->dashboard_period_filter_v2
          ->from('(SELECT "1") as faketbl')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as total_leads
          ')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0 AND qualification_type = 1
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as iql_leads
          ')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0 AND qualification_type = 2
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as mql_leads
          ')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0 AND qualification_type = 3
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as sql_leads
          ')

          ->select('
            (SELECT count(userid) FROM tblclients
              WHERE
              active IS NOT NULL
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreated','and',true).'
            ) as total_clients
          ')
          ->select('
            (SELECT count(id) FROM tblcontacts
              WHERE
              active IS NOT NULL
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreated','and',true).'
            ) as total_contacts
          ')

          ->select('
            (SELECT round(sum(total_budget),2) FROM tblleads
            JOIN tblmarketing_campaigns ON tblmarketing_campaigns.id = tblleads.id_from_campaign
              WHERE
              tblleads.status != 0
            ) as total_budget
          ')

          ->row_array();

          if($prev['total_budget'] == 0 OR $prev['total_leads'] == 0){
            $prev['cost_per_lead'] = 0;
          }else{
            $prev['cost_per_lead'] = round($prev['total_budget']/$prev['total_leads'],2);
          }
          if($prev['total_budget'] == 0 OR $prev['mql_leads'] == 0){
            $prev['cost_per_mql'] = 0;
          }else{
            $prev['cost_per_mql'] = round($prev['total_budget']/$prev['mql_leads'],2);
          }

      $delta_sales = [
        'total_leads'=>$this->dashboard->delta($filtered['total_leads'],$prev['total_leads']),
        'iql_leads'=>$this->dashboard->delta($filtered['iql_leads'],$prev['iql_leads']),
        'mql_leads'=>$this->dashboard->delta($filtered['mql_leads'],$prev['mql_leads']),
        'sql_leads'=>$this->dashboard->delta($filtered['sql_leads'],$prev['sql_leads']),
        'total_clients'=>$this->dashboard->delta($filtered['total_clients'],$prev['total_clients']),
        'total_contacts'=>$this->dashboard->delta($filtered['total_contacts'],$prev['total_contacts']),
        'cost_per_lead'=>$this->dashboard->delta($filtered['cost_per_lead'],$prev['cost_per_lead']),
        'cost_per_mql'=>$this->dashboard->delta($filtered['cost_per_mql'],$prev['cost_per_mql']),

        'sales_num'=>$this->dashboard->delta($sales['sales_num'],$prev_sales['sales_num']),
        'sales_value'=>$this->dashboard->delta($sales['sales_value'],$prev_sales['sales_value']),
        'sales_cost'=>$this->dashboard->delta($sales_cost,$sales_cost_prev),
        //'total_sales_profit'=>$this->dashboard->delta($total_sales_profit,$total_sales_profit_prev),
        'profit_per_sale'=>round(($this->dashboard->delta($sales['sales_value'],$prev_sales['sales_value']) - $this->dashboard->delta($sales_cost,$sales_cost_prev))/$this->dashboard->delta($sales['sales_num'],$prev_sales['sales_num']),0),

      ];


      $return = [
        'dashcards'=>[
                'leads'=>[
                  "title"=> _l('title_leads'),
                  "subtitle"=>"",
                  "figure"=>(int)$filtered['total_leads'],
                  "figure_delta"=>(int)$delta_sales['total_leads'],
                ],
              'iql'=>[
                "title"=> _l('title_iql'),
                "subtitle"=>"",
                "figure"=>(int)$filtered['iql_leads'],
                "figure_delta"=>(int)$delta_sales['iql_leads'],
              ],
              'mql'=>[
                "title"=> _l('title_mql'),
                "subtitle"=>"",
                "figure"=>(int)$filtered['mql_leads'],
                "figure_delta"=>(int)$delta_sales['mql_leads'],
              ],
              'sql'=>[
                "title"=> _l('title_sql'),
                "subtitle"=>"",
                "figure"=>(int)$filtered['sql_leads'],
                "figure_delta"=>(int)$delta_sales['sql_leads'],
              ],
              'clients'=>[
                "title"=> _l('title_clients'),
                "subtitle"=>"",
                "figure"=>(int)$filtered['total_clients'],
                "figure_delta"=>(int)$delta_sales['total_clients'],
              ],
            'contacts'=>[
              "title"=> _l('title_contacts'),
              "subtitle"=>"",
              "figure"=>(int)$filtered['total_contacts'],
              "figure_delta"=>(int)$delta_sales['total_contacts'],
            ],
            'cpost_per_lead'=>[
              "title"=> _l('title_cost_per_lead'),
              "subtitle"=>"",
              "figure"=>strtoupper(_l('total')).': '. (int)$filtered['cost_per_lead'] .' '.$this->base_currency->symbol,
              "figure_delta"=>(int)$delta_sales['cost_per_lead'],
            ],
            'cost_per_mql'=>[
              "title"=> _l('title_cost_per_mql'),
              "subtitle"=>"",
              "figure"=>strtoupper(_l('total')).': '. (int)$filtered['cost_per_mql'] .' '.$this->base_currency->symbol,
              "figure_delta"=>(int)$delta_sales['cost_per_mql'],
            ],


            'number_of_sales'=>[
              "title"=> _l('title_number_of_sales'),
              "subtitle"=>"",
              "figure"=>(int)$sales['sales_num'],
              "figure_delta"=>(int)$delta_sales['sales_num'],
            ],
          'new_revenue'=>[
            "title"=> _l('title_new_revenue'),
            "subtitle"=>"",
            "figure"=>(int)$filtered['sales_value'].' '.$this->base_currency->symbol,
            "figure_delta"=>(int)$delta_sales['sales_value'],
          ],
          'cost'=>[
            "title"=> _l('title_cost'),
            "subtitle"=>"",
            "figure"=>(int)$sales_cost .' '.$this->base_currency->symbol,
            "figure_delta"=>(int)$delta_sales['sales_cost'],
          ],
          'profit_by_sale'=>[
            "title"=> _l('title_profit_by_sale'),
            "subtitle"=>"",
            "figure"=>(int)$total_sales_profit .' '.$this->base_currency->symbol,
            "figure_delta"=>(int)$delta_sales['profit_per_sale'],
          ],


      ],


        'total_leads_prev'=>$prev['total_leads'],

        'globals'=>[
          'delta_total_leads'=>(int)$delta_sales['total_leads'],
          'delta_iql_leads'=>(int)$delta_sales['iql_leads'],
          'delta_mql_leads'=>(int)$delta_sales['mql_leads'],
          'delta_sql_leads'=>(int)$delta_sales['sql_leads'],
          'delta_total_clients'=>(int)$delta_sales['total_clients'],
          'delta_total_contacts'=>(int)$delta_sales['total_contacts'],
          'delta_cost_per_lead'=>(int)$delta_sales['cost_per_lead'],
          'delta_cost_per_mql'=>(int)$delta_sales['cost_per_mql'],

        ],
        '$delta_sales' => $delta_sales,
        '$filtered' => $filtered,
        
        'refs'=>[
        'total_leads'=>$filtered['total_leads'],
          'delta_total_leads'=>(int)$delta_sales['total_leads'],

        'iql_leads'=>$filtered['iql_leads'],
          'delta_iql_leads'=>(int)$delta_sales['iql_leads'],

            'mql_leads'=>$filtered['mql_leads'],
          'delta_mql_leads'=>(int)$delta_sales['mql_leads'],

          'sql_leads'=>$filtered['sql_leads'],
          'delta_sql_leads'=>(int)$delta_sales['sql_leads'],

          'total_clients'=>$filtered['total_clients'],
          'delta_total_clients'=>(int)$delta_sales['total_clients'],

          'total_contacts'=>$filtered['total_contacts'],
          'delta_total_contacts'=>(int)$delta_sales['total_contacts'],

          'cost_per_lead'=>$filtered['cost_per_lead'],
          'delta_cost_per_lead'=>(int)$delta_sales['cost_per_lead'],

          'cost_per_mql'=>$filtered['cost_per_mql'],
          'delta_cost_per_mql'=>(int)$delta_sales['cost_per_mql'],
        ]

      ];
      echo json_encode($return); exit;
    }


    public function load_figures(){
      $payload = file_get_contents('php://input'); //$this->input->post('params');
      $payload = json_decode($payload,true);

      $this->dashboard_period_filter->table = 'tblexpenses';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $costs = $this->dashboard_period_filter->prepare_filter()->add_select('sum(tblexpenses.amount) as total')->number('total');

      $this->dashboard_period_filter->table = 'tblinvoicepaymentrecords';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $revenue_total = $this->dashboard_period_filter->prepare_filter()->add_select('sum(tblinvoicepaymentrecords.amount) as total')->number('total');

      $return = [
          'status'=>true,
          'costs_total'=>$costs,
          'revenue_total'=>$revenue_total,

      ];

      echo json_encode($return);


    }


}
