<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';
class Cmo_strategic extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit(blank_page());
        $this->load->model('dashboard_model');
        $this->load->library('dashboard');
    }

    public function index()
    {
        close_setup_menu();
        $data['title']  = _l(DASHBOARDS_MODULE.'_'.$this->router->fetch_class());
        if (!has_permission(DASHBOARDS_MODULE, '', $this->router->fetch_class())  && !is_admin()) {
            access_denied(DASHBOARDS_MODULE);
        }
        $this->load->view($this->router->fetch_class(), $data);
    }

    public function cards(){
      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));
        $leads = $faker->leads();

        $return = [
          'total_leads_prev'=>200,
  
          'globals'=>[

  
              'delta_total_leads'=>$faker->random_change_percent(),
                'delta_iql_leads'=>$faker->random_change_percent(),
                'delta_mql_leads'=>$faker->random_change_percent(),
                'delta_sql_leads'=>$faker->random_change_percent(),
                'delta_total_clients'=>$faker->random_change_percent(),
                'delta_total_contacts'=>$faker->random_change_percent(),
                'delta_cost_per_lead'=>$faker->random_change_percent(),
                'delta_cost_per_mql'=>$faker->random_change_percent(),

          ],
  
          'refs'=>[
              'total_leads'=>$faker->leads(),
                  'delta_total_leads'=>$faker->random_change_percent(),
        
                  'iql_leads'=>$faker->iql(),
                  'delta_iql_leads'=>$faker->change_iql(),
        
                    'mql_leads'=>$faker->mql(),
                  'delta_mql_leads'=>$faker->change_mql(),
        
                  'sql_leads'=>$faker->sql(),
                  'delta_sql_leads'=>$faker->change_sql(),
        
                  'total_clients'=>$faker->converted_clients(),
                  'delta_total_clients'=>$faker->lead_conversion_rate_change(),
        
                  'total_contacts'=>$faker->converted_clients(),
                  'delta_total_contacts'=>$faker->lead_conversion_rate_change(),
        
                  'cost_per_lead'=>$faker->numberBetween(10,100),
                  'delta_cost_per_lead'=>$faker->random_change_percent(),
        
                  'cost_per_mql'=>$faker->numberBetween(20,200),
                  'delta_cost_per_mql'=>$faker->random_change_percent(),
          ]
  
        ];
        echo json_encode($return); exit;
      }


      
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);

      $this->dashboard_period_filter_v2->set_params($payload['params']);
      $filtered = $this->dashboard_period_filter_v2
        ->from('(SELECT "1") as faketbl')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as total_leads
        ')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0 AND qualification_type = 1
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as iql_leads
        ')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0 AND qualification_type = 2
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as mql_leads
        ')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0 AND qualification_type = 3
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as sql_leads
        ')

        ->select('
          (SELECT count(userid) FROM tblclients
            WHERE
            active IS NOT NULL
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreated','and').'
          ) as total_clients
        ')
        ->select('
          (SELECT count(id) FROM tblcontacts
            WHERE
            active IS NOT NULL
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreated','and').'
          ) as total_contacts
        ')

        ->select('
          (SELECT round(sum(total_budget),2) FROM tblleads
          JOIN tblmarketing_campaigns ON tblmarketing_campaigns.id = tblleads.id_from_campaign
            WHERE
            tblleads.status != 0
          ) as total_budget
        ')

        ->row_array();

        if($filtered['total_budget'] == 0 OR $filtered['total_leads'] == 0){
          $filtered['cost_per_lead'] = 0;
        }else{
          $filtered['cost_per_lead'] = round($filtered['total_budget']/$filtered['total_leads'],2);
        }

        if($filtered['total_budget'] == 0 OR $filtered['mql_leads'] == 0){
          $filtered['cost_per_mql'] = 0;
        }else{
          $filtered['cost_per_mql'] = round($filtered['total_budget']/$filtered['mql_leads'],2);
        }

        $this->dashboard_period_filter_v2->reset();
        $this->dashboard_period_filter_v2->set_params($payload['params']);
        $prev = $this->dashboard_period_filter_v2
          ->from('(SELECT "1") as faketbl')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as total_leads
          ')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0 AND qualification_type = 1
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as iql_leads
          ')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0 AND qualification_type = 2
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as mql_leads
          ')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0 AND qualification_type = 3
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as sql_leads
          ')

          ->select('
            (SELECT count(userid) FROM tblclients
              WHERE
              active IS NOT NULL
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreated','and',true).'
            ) as total_clients
          ')
          ->select('
            (SELECT count(id) FROM tblcontacts
              WHERE
              active IS NOT NULL
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreated','and',true).'
            ) as total_contacts
          ')

          ->select('
            (SELECT round(sum(total_budget),2) FROM tblleads
            JOIN tblmarketing_campaigns ON tblmarketing_campaigns.id = tblleads.id_from_campaign
              WHERE
              tblleads.status != 0
            ) as total_budget
          ')

          ->row_array();

          if($prev['total_budget'] == 0 OR $prev['total_leads'] == 0){
            $prev['cost_per_lead'] = 0;
          }else{
            $prev['cost_per_lead'] = round($prev['total_budget']/$prev['total_leads'],2);
          }
          if($prev['total_budget'] == 0 OR $prev['mql_leads'] == 0){
            $prev['cost_per_mql'] = 0;
          }else{
            $prev['cost_per_mql'] = round($prev['total_budget']/$prev['mql_leads'],2);
          }

      $delta_sales = [
        'total_leads'=>$this->dashboard->delta($filtered['total_leads'],$prev['total_leads']),
        'iql_leads'=>$this->dashboard->delta($filtered['iql_leads'],$prev['iql_leads']),
        'mql_leads'=>$this->dashboard->delta($filtered['mql_leads'],$prev['mql_leads']),
        'sql_leads'=>$this->dashboard->delta($filtered['sql_leads'],$prev['sql_leads']),
        'total_clients'=>$this->dashboard->delta($filtered['total_clients'],$prev['total_clients']),
        'total_contacts'=>$this->dashboard->delta($filtered['total_contacts'],$prev['total_contacts']),
        'cost_per_lead'=>$this->dashboard->delta($filtered['cost_per_lead'],$prev['cost_per_lead']),
        'cost_per_mql'=>$this->dashboard->delta($filtered['cost_per_mql'],$prev['cost_per_mql']),

      ];


      $return = [
        'total_leads_prev'=>$prev['total_leads'],

        'globals'=>[
          'delta_total_leads'=>(int)$delta_sales['total_leads'],
          'delta_iql_leads'=>(int)$delta_sales['iql_leads'],
          'delta_mql_leads'=>(int)$delta_sales['mql_leads'],
          'delta_sql_leads'=>(int)$delta_sales['sql_leads'],
          'delta_total_clients'=>(int)$delta_sales['total_clients'],
          'delta_total_contacts'=>(int)$delta_sales['total_contacts'],
          'delta_cost_per_lead'=>(int)$delta_sales['cost_per_lead'],
          'delta_cost_per_mql'=>(int)$delta_sales['cost_per_mql'],

        ],

        'refs'=>[
          'total_leads'=>$filtered['total_leads'],
          'delta_total_leads'=>(int)$delta_sales['total_leads'],

          'iql_leads'=>$filtered['iql_leads'],
          'delta_iql_leads'=>(int)$delta_sales['iql_leads'],

          'mql_leads'=>$filtered['mql_leads'],
          'delta_mql_leads'=>(int)$delta_sales['mql_leads'],

          'sql_leads'=>$filtered['sql_leads'],
          'delta_sql_leads'=>(int)$delta_sales['sql_leads'],

          'total_clients'=>$filtered['total_clients'],
          'delta_total_clients'=>(int)$delta_sales['total_clients'],

          'total_contacts'=>$filtered['total_contacts'],
          'delta_total_contacts'=>(int)$delta_sales['total_contacts'],

          'cost_per_lead'=>$filtered['cost_per_lead'],
          'delta_cost_per_lead'=>(int)$delta_sales['cost_per_lead'],

          'cost_per_mql'=>$filtered['cost_per_mql'],
          'delta_cost_per_mql'=>(int)$delta_sales['cost_per_mql'],
        ]

      ];
      echo json_encode($return); exit;
    }

}
