<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';
class Helpdesk extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit(blank_page());
        $this->load->model('dashboard_model');
        //$this->load->model('sql_model');
        $this->load->library('dashboard');
        $this->load->model('dashboard_period_filter');

    }

    public function index()
    {
        close_setup_menu();
        $data['title']  = _l(DASHBOARDS_MODULE.'_'.$this->router->fetch_class());
        if (!has_permission(DASHBOARDS_MODULE, '', $this->router->fetch_class())  && !is_admin()) {
            access_denied(DASHBOARDS_MODULE);
        }

        $this->load->view($this->router->fetch_class(), $data);
    }

    public function num_tickets_by_hour(){
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);

        if(get_option('demo_mode') == '1'){
          $faker = Faker\Factory::create();
          $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));


          $return = [
            'status'=>true,
            'tickets'=>$faker->random_numbers_sum(24,100),
            'alltime_tickets'=>$faker->random_numbers_sum(31,1000),
            'perc_of_all_tickets'=>$faker->random_numbers_sum(24,100),
            'xcategories'=>[1, 2, 3, 4, 5, 6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24]
          ];

          echo json_encode($return);
          exit;
        }


        $this->dashboard_period_filter->table = 'tbltickets';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('COUNT(ticketid)/24');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthday();

        $tickets = $this->dashboard_period_filter->select()->all_monthdays();

        $this->dashboard_period_filter->unset_filtering();
        $alltime_tickets = $this->dashboard_period_filter->select()->all_monthdays();

        //pre([$tickets,$alltime_tickets]);
        $percents = [];

        foreach($tickets as $k=>$num){
          if(!isset($alltime_tickets[$k])){
            $alltime_tickets[$k] = 0;
          }
        }
        foreach($alltime_tickets as $k=>$num){
          //different daynames, eg february
          if(!isset($tickets[$k])){
            $tickets[$k] = 0;
          }
          if($tickets[$k] == 0 OR $alltime_tickets[$k] == 0){
            $percents[$k] = 0; continue;
          }
          $percents[$k] = round(($tickets[$k]/$alltime_tickets[$k])*100,0);
        }

        $return = [
          'status'=>true,
          'tickets'=>$tickets,
          'alltime_tickets'=>$alltime_tickets,

          'perc_of_all_tickets'=>$percents,
          'xcategories'=>$this->dashboard->days_of_month()
        ];
      
      echo json_encode($return);
      exit;
    }

    public function trend_daily_tickets(){
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);


      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));


        $return = '{
          "status": true,
          "title_chart__daily_support_trends": "'.$faker->numberBetween(0,100).' tickets",
          "title_chart__daily_support_trends2": "'.$faker->numberBetween(0,100).' responses",
          "title_xaxis_chart__daily_support_trends": "Issues",
          "title_xaxis_chart__daily_support_trends2": "Responses",
          "values_daily_support_trends": '.json_encode($faker->random_numbers_sum(31,1000)).',
          "values_daily_support_trends2": '.json_encode($faker->random_numbers_sum(31,1000)).'
        }';

        echo ($return);
        exit;
      }

        $this->dashboard_period_filter->table = 'tbltickets';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('COUNT(ticketid)');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthday();
        $tickets = $this->dashboard_period_filter->select()->all_monthdays();

        $this->dashboard_period_filter->reset();
        $this->dashboard_period_filter->table = 'tblticket_replies';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('COUNT(id)');
        $this->dashboard_period_filter->group_only_by_monthday();
        $responses = $this->dashboard_period_filter->select()->all_monthdays();

        $count_tickets = 0;
        $count_responses = 0;
        if(!empty($tickets)){
          foreach($tickets as $num){
            $count_tickets += $num;
          }
        }
        if(!empty($responses)){
          foreach($responses as $num){
            $count_responses += $num;
          }
        }

        $return = [
            'status'=>true,
            'title_chart__daily_support_trends'=>$count_tickets.' tickets',
            'title_chart__daily_support_trends2'=>$count_responses.' responses',
            'title_xaxis_chart__daily_support_trends'=>'Issues',
            'title_xaxis_chart__daily_support_trends2'=>'Responses',
            'values_daily_support_trends'=>$tickets,
            'values_daily_support_trends2'=>$responses,
        ];
      
      echo json_encode($return);
    }

    public function hourly_tickets_by_month(){
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);

      if(get_option('demo_mode') == '1'){
          $faker = Faker\Factory::create();
          $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));


          $return = '{
            "status": true,
            "num_tickets": '.json_encode($faker->random_numbers_sum(24,1000)).',
            "perc_of_all_tickets": '.json_encode($faker->random_numbers_sum(31,3100)).'
            
          }';

          echo ($return);
          exit;
        }

        $this->dashboard_period_filter->table = 'tbltickets';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('COUNT(ticketid)');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthday();
        $tickets = $this->dashboard_period_filter->select()->all_monthdays();

        $this->dashboard_period_filter->unset_filtering();
        $alltime_tickets = $this->dashboard_period_filter->select()->all_monthdays();
        $percents = [];

        foreach($tickets as $k=>$num){
          if(!isset($alltime_tickets[$k])){
            $alltime_tickets[$k] = 0;
          }
        }
        foreach($alltime_tickets as $k=>$num){
          //different daynames, eg february
          if(!isset($tickets[$k])){
            $tickets[$k] = 0;
          }
          if($tickets[$k] == 0 OR $alltime_tickets[$k] == 0){
            $percents[$k] = 0; continue;
          }
          $percents[$k] = round(($tickets[$k]/$alltime_tickets[$k])*100,0);
        }
        $return = [
            'status'=>true,
            'num_tickets'=>$tickets,
            'perc_of_all_tickets'=>$percents,
        ];
      
      echo json_encode($return);
    }
    public function daily_tickets_by_month(){
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);

      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));


        $return = [
          'status'=>true,
          'avg_filtered_tickets'=>$faker->random_numbers_sum(12,1000),
          'avg_all_tickets'=>$faker->random_numbers_sum(12,1000),
      ];
    
      echo json_encode($return);
        exit;
      }
      
        $this->dashboard_period_filter->table = 'tbltickets';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('COUNT(ticketid)');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthname();
        $avg_filtered_tickets = $this->dashboard_period_filter->select()->all_months();

        $this->dashboard_period_filter->unset_filtering();
        $avg_all_tickets = $this->dashboard_period_filter->select()->all_months();

        $return = [
            'status'=>true,
            'avg_filtered_tickets'=>$avg_filtered_tickets,
            'avg_all_tickets'=>$avg_all_tickets,
        ];
      
      echo json_encode($return);
    }



    public function response_time_trend(){
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);
    

      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));


        $return = [
          'status'=>true,
          'filtered_response_time'=>$faker->random_numbers_sum(24,1000),
          'alltime_response_time'=>$faker->random_numbers_sum(24,1000),

      ];
    
        echo json_encode($return);
        exit;
      }

        $this->dashboard_period_filter->table = 'tbltickets';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('SUM(TIMESTAMPDIFF(MINUTE, tbltickets.date, tblticket_replies.date))/60');
        $this->dashboard_period_filter->join('tblticket_replies','tbltickets.ticketid = tblticket_replies.ticketid');
        //$this->dashboard_period_filter->join_first('tbltickets','ticketid','tblticket_replies','id','ticketid','LEFT');

        $this->dashboard_period_filter->group_only_by_hours();
        $avg_filtered_tickets = $this->dashboard_period_filter->select()->all_hours();

        $this->dashboard_period_filter->unset_filtering();
        $this->dashboard_period_filter->formula('SUM(TIMESTAMPDIFF(MINUTE, tbltickets.date, tblticket_replies.date))/count(tbltickets.ticketid)/60');
        $this->dashboard_period_filter->join('tblticket_replies','tbltickets.ticketid = tblticket_replies.ticketid');
        $alltime_response_time = $this->dashboard_period_filter->select()->all_hours();

        $return = [
            'status'=>true,
            'filtered_response_time'=>$avg_filtered_tickets,
            'alltime_response_time'=>$alltime_response_time,

        ];
      
      echo json_encode($return);
    }
    public function response_time_groupped(){
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);

      

      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));


        $return = [
          'status'=>true,
          'group_1'=>$faker->random_numbers_sum(12,1000),
          'group_2'=>$faker->random_numbers_sum(12,1000),
          'group_3'=>$faker->random_numbers_sum(12,1000),
          'group_4'=>$faker->random_numbers_sum(12,1000),

      ];
    
      echo json_encode($return);
        exit;
      }

        $this->dashboard_period_filter->table = 'tblticket_replies';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('ABS((SUM(TIMESTAMPDIFF(MINUTE, tbltickets.date, tblticket_replies.date))/count(tblticket_replies.ticketid))/60)');
        $this->dashboard_period_filter->join('tbltickets','tbltickets.ticketid = tblticket_replies.ticketid','LEFT');
        $this->dashboard_period_filter->having('SUM(TIMESTAMPDIFF(MINUTE, tbltickets.date, tblticket_replies.date)) <= 60');
        $this->dashboard_period_filter->group_only_by_monthname();
        $group_1 = $this->dashboard_period_filter->select()->group_by('DATE(tblticket_replies.ticketid)')->all_months();


        $this->dashboard_period_filter->join('tbltickets','tbltickets.ticketid = tblticket_replies.ticketid','LEFT');
        $this->dashboard_period_filter->having('SUM(TIMESTAMPDIFF(MINUTE, tbltickets.date, tblticket_replies.date)) BETWEEN 60*1 AND 60*4');
        $group_2 = $this->dashboard_period_filter->select()->group_by('DATE(tblticket_replies.ticketid)')->all_months();

        $this->dashboard_period_filter->join('tbltickets','tbltickets.ticketid = tblticket_replies.ticketid','LEFT');
        $this->dashboard_period_filter->having('SUM(TIMESTAMPDIFF(MINUTE, tbltickets.date, tblticket_replies.date)) BETWEEN 60*4 AND 60*24');
        $group_3 = $this->dashboard_period_filter->select()->group_by('DATE(tblticket_replies.ticketid)')->all_months();

        $this->dashboard_period_filter->join('tbltickets','tbltickets.ticketid = tblticket_replies.ticketid','LEFT');
        $this->dashboard_period_filter->having('SUM(TIMESTAMPDIFF(MINUTE, tbltickets.date, tblticket_replies.date)) > 60*24');
        $group_4 = $this->dashboard_period_filter->select()->group_by('DATE(tblticket_replies.ticketid)')->all_months();
        $return = [
            'status'=>true,
            'group_1'=>$group_1,
            'group_2'=>$group_2,
            'group_3'=>$group_3,
            'group_4'=>$group_4,

        ];
      
      echo json_encode($return);
    }

}
