<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';

class Inbound_lead_generation extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit(blank_page());
        $this->load->model('dashboard_model');
        $this->load->library('dashboard');
        $this->load->model('dashboard_period_filter');
        $this->load->model('dashboard_period_filter_v2');
    }

    public function index()
    {
        close_setup_menu();
        $data['title']  = _l(DASHBOARDS_MODULE.'_'.$this->router->fetch_class());
        if (!has_permission(DASHBOARDS_MODULE, '', $this->router->fetch_class())  && !is_admin()) {
            access_denied(DASHBOARDS_MODULE);
        }
        $this->load->view($this->router->fetch_class(), $data);
    }
    public function barcharts(){
      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));
        $leads = $faker->leads();

        $return = [
          'leads'=>[
            'actual_value'=>600,
            'target_value'=>400,
          ],
  
          'leads_by_source'=>[
            'categories'=>['Cold Calling','Email','Social'],
            'text'=>'Leads',
            'data'=>$faker->random_numbers_sum(3,$leads),
          ],
          'leads_by_pipeline'=>[
            'categories'=>['Cold Calling','Email','Social'],
            'text'=>'Leads',
            'data'=>$faker->random_numbers_sum(3,$leads),
          ],
          'leads_by_form'=>[
            'categories'=>['Cold Calling','Email','Social'],
            'text'=>'Leads',
            'data'=>$faker->random_numbers_sum(3,$leads),
          ],
  
          'total_leads_prev'=>$faker->numberBetween(10,50),


          'globals'=>[
            'delta_total_leads'=>$faker->numberBetween(10,50),
            'delta_iql_leads'=>$faker->numberBetween(10,50),
            'delta_mql_leads'=>$faker->numberBetween(10,50),
            'delta_sql_leads'=>$faker->numberBetween(10,50),
          ],
  
          'refs'=>[
            'total_leads'=>$faker->numberBetween(10,50),
            'delta_total_leads'=>$faker->numberBetween(10,50),
  
            'iql_leads'=>$faker->numberBetween(10,50),
            'delta_iql_leads'=>$faker->numberBetween(10,50),
  
            'mql_leads'=>$faker->numberBetween(10,50),
            'delta_mql_leads'=>$faker->numberBetween(10,50),
  
            'sql_leads'=>$faker->numberBetween(10,50),
            'delta_sql_leads'=>$faker->numberBetween(10,50)
          ]
  
        ];
        echo json_encode($return); exit;



      }
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);

      $this->dashboard_period_filter_v2->set_params($payload['params']);
      $filtered = $this->dashboard_period_filter_v2
        ->from('(SELECT "1") as faketbl')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as total_leads
        ')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0 AND qualification_type = 1
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as iql_leads
        ')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0 AND qualification_type = 2
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as mql_leads
        ')
        ->select('
          (SELECT count(*) FROM tblleads
            WHERE
            tblleads.status != 0 AND qualification_type = 3
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').'
          ) as sql_leads
        ')
        ->row_array();

        $this->dashboard_period_filter_v2->reset();
        $this->dashboard_period_filter_v2->set_params($payload['params']);
        $prev = $this->dashboard_period_filter_v2
          ->from('(SELECT "1") as faketbl')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as total_leads
          ')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0 AND qualification_type = 1
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as iql_leads
          ')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0 AND qualification_type = 2
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as mql_leads
          ')
          ->select('
            (SELECT count(*) FROM tblleads
              WHERE
              tblleads.status != 0 AND qualification_type = 3
              '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).'
            ) as sql_leads
          ')
          ->row_array();

      $delta_sales = [
        'total_leads'=>$this->dashboard->delta($filtered['total_leads'],$prev['total_leads']),
        'iql_leads'=>$this->dashboard->delta($filtered['iql_leads'],$prev['iql_leads']),
        'mql_leads'=>$this->dashboard->delta($filtered['mql_leads'],$prev['mql_leads']),
        'sql_leads'=>$this->dashboard->delta($filtered['sql_leads'],$prev['sql_leads']),


      ];

      $this->dashboard_period_filter_v2->reset();
      $leads_by_source = $this->dashboard_period_filter_v2
        ->from('tblleads')->set_period_on($payload['params'],'dateadded')
        ->select('IFNULL(tblleads_sources.name,"None")  as name')
        ->select('count(tblleads.id) as total_num')
        ->join('tblleads_sources','tblleads_sources.id = tblleads.source','LEFT')
        ->group_by('tblleads_sources.id')
        ->having('count(tblleads.id) > 0')
        ->result_array();
      $series['leads_by_source']['categories'] = array_column($leads_by_source,'name');
      $series['leads_by_source']['values'] = array_column($leads_by_source,'total_num');
      $series['leads_by_source']['values'] = $this->dashboard->cast_int($series['leads_by_source']['values']);

      $this->dashboard_period_filter_v2->reset();
      $leads_by_pipeline = $this->dashboard_period_filter_v2
        ->from('tblleads')->set_period_on($payload['params'],'dateadded')
        ->select('IFNULL(tblleads_pipeline.name,"None")  as name')
        ->select('count(tblleads.id) as total_num')
        ->join('tblleads_pipeline','tblleads_pipeline.id = tblleads.pipeline','LEFT')
        ->group_by('tblleads_pipeline.id')
        ->having('count(tblleads.id) > 0')
        ->result_array();
      $series['leads_by_pipeline']['categories'] = array_column($leads_by_pipeline,'name');
      $series['leads_by_pipeline']['values'] = array_column($leads_by_pipeline,'total_num');
      $series['leads_by_pipeline']['values'] = $this->dashboard->cast_int($series['leads_by_pipeline']['values']);
      $this->dashboard_period_filter_v2->reset();
      $leads_by_form = $this->dashboard_period_filter_v2
        ->from('tblleads')->set_period_on($payload['params'],'dateadded')
        ->select('IFNULL(tblweb_to_lead.name,"None") as name')
        ->select('count(tblleads.id) as total_num')
        ->join('tblweb_to_lead','tblweb_to_lead.id = tblleads.from_form_id','LEFT')
        ->group_by('tblweb_to_lead.id')
        ->having('count(tblleads.id) > 0')
        ->result_array();
      $series['leads_by_form']['categories'] = array_column($leads_by_form,'name');
      $series['leads_by_form']['values'] = array_column($leads_by_form,'total_num');
      $series['leads_by_form']['values'] = $this->dashboard->cast_int($series['leads_by_form']['values']);

      $return = [
        'leads'=>[
          'actual_value'=>200,
          'target_value'=>400,
        ],

        'leads_by_source'=>[
          'categories'=>$series['leads_by_source']['categories'],
          'text'=>'Leads',
          'data'=>$series['leads_by_source']['values'],
        ],
        'leads_by_pipeline'=>[
          'categories'=>$series['leads_by_pipeline']['categories'],
          'text'=>'Leads',
          'data'=>$series['leads_by_pipeline']['values'],
        ],
        'leads_by_form'=>[
          'categories'=>$series['leads_by_form']['categories'],
          'text'=>'Leads',
          'data'=>$series['leads_by_form']['values'],
        ],

        'total_leads_prev'=>$prev['total_leads'],

        'globals'=>[
          'delta_total_leads'=>(int)$delta_sales['total_leads'],
          'delta_iql_leads'=>(int)$delta_sales['iql_leads'],
          'delta_mql_leads'=>(int)$delta_sales['mql_leads'],
          'delta_sql_leads'=>(int)$delta_sales['sql_leads'],
        ],

        'refs'=>[
          'total_leads'=>$filtered['total_leads'],
          'delta_total_leads'=>(int)$delta_sales['total_leads'],

          'iql_leads'=>$filtered['iql_leads'],
          'delta_iql_leads'=>(int)$delta_sales['iql_leads'],

          'mql_leads'=>$filtered['mql_leads'],
          'delta_mql_leads'=>(int)$delta_sales['mql_leads'],

          'sql_leads'=>$filtered['sql_leads'],
          'delta_sql_leads'=>(int)$delta_sales['sql_leads'],
        ]

      ];
      echo json_encode($return); exit;
    }

}
