<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';
class Legal extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit(blank_page());
        $this->load->model('dashboard_model');
        $this->load->library('dashboard');
        $this->load->model('dashboard_period_filter_v2');
    }

    public function index()
    {
        close_setup_menu();
        $data['title']  = _l(DASHBOARDS_MODULE.'_'.$this->router->fetch_class());
        if (!has_permission(DASHBOARDS_MODULE, '', $this->router->fetch_class())  && !is_admin()) {
            access_denied(DASHBOARDS_MODULE);
        }
        $this->load->view($this->router->fetch_class(), $data);
    }
    public function barcharts(){
      $payload = file_get_contents('php://input');
      $payload = json_decode($payload,true);

      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));
        
        $return = [

          'contract_num'=>[
            'categories'=>['contract','anexa','proces verbal'],
            'text'=>_l('contracts_by_type'),
            'data'=>$faker->random_numbers_sum(3,100),
          ],
          'contract_val'=>[
            'categories'=>['contract','anexa','proces verbal'],
            'text'=>_l('contracts_value_by_type'),
            'data'=>$faker->random_numbers_sum(3,10000),
          ],
          'refs'=>[
  
          ]
  
        ];
        echo json_encode($return); exit;

      }

      
      $this->dashboard_period_filter_v2->reset();
      $contracts = $this->dashboard_period_filter_v2
        ->from('tblcontracts')->set_period_on($payload['params'],'dateadded')
        ->select('IFNULL(tblcontracts_types.name,"None")  as name')
        ->select('count(tblcontracts.id) as total_num')
        ->select('sum(tblcontracts.contract_value) as total_value')
        ->join('tblcontracts_types','tblcontracts_types.id = tblcontracts.contract_type','LEFT')
        ->group_by('tblcontracts_types.id')
        ->having('count(tblcontracts.id) > 0')
        ->result_array();
      $series['contracts']['categories'] = array_column($contracts,'name');
      $series['contracts']['num'] = array_column($contracts,'total_num');
      $series['contracts']['num'] = $this->dashboard->cast_int($series['contracts']['num']);
      $series['contracts']['values'] = array_column($contracts,'total_value');
      $series['contracts']['values'] = $this->dashboard->cast_float($series['contracts']['values']);

      $return = [

        'contract_num'=>[
          'categories'=>$series['contracts']['categories'],
          'text'=>_l('contracts_by_type'),
          'data'=>$series['contracts']['num'],
        ],
        'contract_val'=>[
          'categories'=>$series['contracts']['categories'],
          'text'=>_l('contracts_value_by_type'),
          'data'=>$series['contracts']['values'],
        ],
        'refs'=>[

        ]

      ];
      echo json_encode($return);
    }

}
