<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';
class OkrDashboardController extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit('You are not allowed to access this page.');
        $this->load->model('okr_dashboard_model');
        $this->load->library('dashboard');
    }

    public function get_data()
    {

        if(get_option('demo_mode') == '1'){
            $faker = Faker\Factory::create();
            $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));
            
            die('{
                "okrs": [
              
                ],
                "progress_good": "'.$faker->numberBetween(0,100).'",
                "progress_risk": "'.$faker->numberBetween(0,100).'",
                "progress_develope": "0",
                "checkin_status": "[{\"name\":\"E bine\",\"y\":'.$faker->numberBetween(0,100).'},{\"name\":\"Nu a\\u0219a de bine\",\"y\":'.$faker->numberBetween(0,100).'},{\"name\":\"Foarte bine\",\"y\":'.$faker->numberBetween(0,100).'}]",
                "okrs_company": {
                  "okrs_count": "'.$faker->numberBetween(0,300).'",
                  "okrs_progress": null,
                  "okrs_keyres": "'.$faker->numberBetween(0,100).'",
                  "html": [
                    '.$faker->numberBetween(0,100).',
                    '.$faker->numberBetween(0,100).',
                    '.$faker->numberBetween(0,100).'
                  ]
                },
                "okrs_user": {
                    "okrs_count": "'.$faker->numberBetween(0,300).'",
                    "okrs_progress": null,
                  "okrs_keyres": "'.$faker->numberBetween(0,100).'",
                  "html": [
                    '.$faker->numberBetween(0,100).',
                    '.$faker->numberBetween(0,100).',
                    '.$faker->numberBetween(0,100).'
                  ]
                },
                "circulation": [
              
                ],
                "category": [
              
                ]
              }');
    
          }

          
        $data['okrs'] = $this->okr_dashboard_model->get_okrs();
        $data['progress_good'] = $this->okr_dashboard_model->get_progress_dashboard(1)->count;
        $data['progress_risk'] = $this->okr_dashboard_model->get_progress_dashboard(2)->count;
        $data['progress_develope'] = $this->okr_dashboard_model->get_progress_dashboard(3)->count;
        $data['checkin_status'] = json_encode($this->okr_dashboard_model->checkin_status_dashboard());
        $data['okrs_company'] = $this->okr_dashboard_model->okrs_company_dasdboard();
        $data['okrs_user'] = $this->okr_dashboard_model->okrs_user_dasdboard();
//        $data['person_assigned'] = $this->staff_model->get();
        $data['circulation'] = $this->okr_dashboard_model->get_circulation();
        $data['category'] = $this->okr_dashboard_model->get_category();
//        $data['department'] = $this->departments_model->get();

//        $data = $this->sales_opportunity_model->current_opportunities();
        echo json_encode($data);
        exit;
    }

}