<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';


class SalesOpportunityController extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit('You are not allowed to access this page.');
        $this->load->model('sales_opportunity_model');
        $this->load->library('dashboard');
    }

    public function get_current_opportunities()
    {
        $data = $this->sales_opportunity_model->current_opportunities();
        echo json_encode($data);
        exit;
    }

    public function get_current_purchase_value()
    {
        $data = $this->sales_opportunity_model->current_purchase_value();
        echo json_encode($data);
        exit;
    }

    public function get_current_average_purchase_rate()
    {
        $data = $this->sales_opportunity_model->average_purchase_rate();
        echo json_encode($data);
        exit;
    }


    public function get_details_opportunity()
    {
        $payload = $this->input->get('status');
        $period = $this->input->get('period_filter');

        $data = $this->sales_opportunity_model->details($payload, $period);
        echo json_encode($data);
        exit;
    }

    public function get_oop_stages()
    {

        $data = $this->sales_opportunity_model->OOP_stages();
        if($data){

            foreach ($data as  &$d){
                $d['name'] = _l($d['name']);
            }
        }
        echo json_encode($data);
        exit;
    }

    public function get_sales_persons()
    {
        $data = $this->sales_opportunity_model->Sales_persons();
        echo json_encode($data);
        exit;
    }

    public function get_winrate_values()
    {
        $data = $this->sales_opportunity_model->win_rate();
        echo json_encode($data);
        exit;
    }

    public function get_lost_opportunities()
    {
        $data = $this->sales_opportunity_model->lost_opportunities();
        echo json_encode($data);
        exit;
    }

    public function get_lost_opportunities_otf()
    {
        $data = $this->sales_opportunity_model->lost_opportunities_otf();
        echo json_encode($data);
        exit;
    }

    public function get_lost_opportunities_mrr()
    {
        $data = $this->sales_opportunity_model->lost_opportunities_mrr();
        echo json_encode($data);
        exit;
    }

    public function get_lost_statuses()
    {
        $data = $this->sales_opportunity_model->lost_statuses();
        echo json_encode($data);
        exit;
    }

    public function lost_reasons_data()
    {
        $period = $this->input->get('period_filter');
        $name = $this->input->get('sales_person');
        $data = $this->sales_opportunity_model->lost_reasons_data($period, $name);
        echo json_encode($data);
        exit;
    }

}
