<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';

class Sales_kpi extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit(blank_page());
        $this->load->model('dashboard_period_filter');
        $this->load->library('dashboard');
    }

    public function index()
    {
        close_setup_menu();
        $data['title']  = _l(DASHBOARDS_MODULE.'_'.$this->router->fetch_class());
        if (!has_permission(DASHBOARDS_MODULE, '', $this->router->fetch_class())  && !is_admin()) {
            access_denied(DASHBOARDS_MODULE);
        }
        $this->load->view($this->router->fetch_class(), $data);
    }
    public function allcharts(){
      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));
        $leads = $faker->leads();
        $sales = $faker->numberBetween(100,1000);
        
        $sales_value = $faker->numberBetween(10000,1000000);
        $sales_cost = $faker->numberBetween(10000,100000);
        $cps =round($sales_cost/$sales,2);

        $return = [
            'status'=>true,

            'xcategories'=>[
                'Jan',
                'Feb',
                'Mar',
                'Apr',
                'May',
                'Jun',
                'Jul',
                'Aug',
                'Sep',
                'Oct',
                'Nov',
                'Dec',
            ],
            'allchannels'=>[],
            'sales_from_opp'=>$faker->random_numbers_sum(12,$sales),

            'refs'=>
            [
              'sales_num'=>$sales,
              'sales_value'=>$sales_value,
              'total_sales_cost'=>$sales_cost,
              //'total_sales_profit'=>$sales_value - $sales_cost,
              'profit_per_sale'=>round(($sales_value - $sales_cost)/$sales,2),
              
              //'total_sales_cost'=>$sales_cost,
              //'total_sales_profit'=>$total_sales_profit,


              //'perc_of_total_events'=>$perc_of_total_events,
              //'perc_of_total_costs'=>$perc_of_total_costs,
              //'perc_of_total_sales_profit'=>$perc_of_total_sales_profit,
            ],
            'delta_sales_num'=>$faker->random_change_percent(),
            'delta_sales_value'=>$faker->random_change_percent(),
            'delta_sales_cost'=>$faker->random_change_percent(),
            'delta_total_sales_profit'=>$faker->random_change_percent(),

        ];
        echo json_encode($return); exit;
      }
      
      $payload = file_get_contents('php://input'); //$this->input->post('params');
      $payload = json_decode($payload,true);

      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $sales = $this->dashboard_period_filter
        ->prepare_filter()
        ->add_select('sum(tblinvoices.total) as sales_value')
        ->add_select('count(tblinvoices.id) as sales_num')
        //->add_select('sum(tblitems.purchase_price) as total_cost')
        //->add_select('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id) as profit_by_sale')

        //->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        //->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        //->join('tblitems','tblitems.id = tblitemable.item_id','LEFT')
        //->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency','LEFT')

        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->where('tblinvoices.clientid IN (SELECT opp.client_id FROM tblleads as opp WHERE opp.client_id = tblinvoices.clientid AND opp.is_opportunity = 1) ')
        //->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        //->group_by('tblinvoices.id')//->where('tblclients.active',1)
        ->row_fields(['sales_value','sales_num'],'number');

        //pre($this->db->last_query());

      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $this->dashboard_period_filter->set_prev_filtering();
      $prev_sales = $this->dashboard_period_filter
        ->prepare_filter()
        ->add_select('sum(tblinvoices.total) as sales_value')
        ->add_select('count(tblinvoices.id) as sales_num')

        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->where('tblinvoices.clientid IN (SELECT opp.client_id FROM tblleads as opp WHERE opp.client_id = tblinvoices.clientid AND opp.is_opportunity = 1) ')
        //->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        //->group_by('tblinvoices.id')//->where('tblclients.active',1)
        ->row_fields(['sales_value','sales_num'],'number');

        //pre($this->dashboard_period_filter->to_date);



      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $sales_cost = $this->dashboard_period_filter
        ->prepare_filter()
        ->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        ->join('tblitems','tblitems.id = tblitemable.item_id')
        ->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency')

        //Oportunitati
        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        ->group_by('tblinvoices.id')//->where('tblclients.active',1)
        //->group_by('sum(tblitems.purchase_price)')
        ->add_select('sum(tblitems.purchase_price) as total')->number('total');


      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $this->dashboard_period_filter->set_prev_filtering();
      $sales_cost_prev = $this->dashboard_period_filter
        ->prepare_filter()
        ->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        ->join('tblitems','tblitems.id = tblitemable.item_id')
        ->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency')

        //Oportunitati
        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        ->group_by('tblinvoices.id')//->where('tblclients.active',1)
        //->group_by('sum(tblitems.purchase_price)')
        ->add_select('sum(tblitems.purchase_price) as total')->number('total');


      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $total_sales_profit = $this->dashboard_period_filter
        ->prepare_filter()
        ->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        ->join('tblitems','tblitems.id = tblitemable.item_id')
        ->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency')

        //Oportunitati
        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        ->group_by('tblinvoices.id')//->where('tblclients.active',1)
        //->group_by('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id)')
        ->add_select('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id) as total')->number('total');

      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $this->dashboard_period_filter->set_prev_filtering();
      $total_sales_profit_prev = $this->dashboard_period_filter
        ->prepare_filter()
        ->join('tblitemable','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice"')
        ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        ->join('tblitems','tblitems.id = tblitemable.item_id')
        ->join('tblcurrencies as item_curr','item_curr.id = tblitems.item_currency')

        //Oportunitati
        ->join('tblclients','tblinvoices.clientid = tblclients.userid')
        ->join('tblleads as opp','opp.client_id = tblclients.userid AND opp.is_opportunity = 1')
        ->group_by('tblinvoices.id')//->where('tblclients.active',1)
        //->group_by('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id)')
        ->add_select('sum(tblinvoices.total) - sum(tblitems.purchase_price)/count(tblinvoices.id) as total')->number('total');

      $delta_sales = [
        'sales_num'=>$this->dashboard->delta($sales['sales_num'],$prev_sales['sales_num']),
        'sales_value'=>$this->dashboard->delta($sales['sales_value'],$prev_sales['sales_value']),
        'sales_cost'=>$this->dashboard->delta($sales_cost,$sales_cost_prev),
        //'total_sales_profit'=>$this->dashboard->delta($total_sales_profit,$total_sales_profit_prev),
        'profit_per_sale'=>round(($this->dashboard->delta($sales['sales_value'],$prev_sales['sales_value']) - $this->dashboard->delta($sales_cost,$sales_cost_prev))/$this->dashboard->delta($sales['sales_num'],$prev_sales['sales_num']),0),
      ];

      /*pre([
        $delta_sales,
        $sales,$prev_sales
      ]);*/

      $this->dashboard_period_filter->reset();
      $this->dashboard_period_filter->table = 'tblinvoices';
      $this->dashboard_period_filter->date_field = 'date';
      $this->dashboard_period_filter->set_filtering($payload['params']);
      $this->dashboard_period_filter->formula('sum(tblinvoices.total)');
      $this->dashboard_period_filter
      ->group_only_by_monthname();
      $sales_from_opp = $this->dashboard_period_filter->select()
      ->join('tblclients','tblinvoices.clientid = tblclients.userid')
      ->where('tblinvoices.clientid IN (SELECT opp.client_id FROM tblleads as opp WHERE opp.client_id = tblinvoices.clientid AND opp.is_opportunity = 1) ')
        //->group_by('tblinvoices.id')//->where('tblclients.active',1)
        ->all_months();

      $return = [
          'status'=>true,

          'xcategories'=>[
              'Jan',
              'Feb',
              'Mar',
              'Apr',
              'May',
              'Jun',
              'Jul',
              'Aug',
              'Sep',
              'Oct',
              'Nov',
              'Dec',
          ],
          'allchannels'=>[],
          'sales_from_opp'=>$sales_from_opp,

          'refs'=>
          [
            'sales_num'=>$sales['sales_num'],
            'sales_value'=>$sales['sales_value'],
            'total_sales_cost'=>$sales_cost,
            'total_sales_profit'=>$total_sales_profit,
            //'total_sales_cost'=>$sales_cost,
            //'total_sales_profit'=>$total_sales_profit,


            //'perc_of_total_events'=>$perc_of_total_events,
            //'perc_of_total_costs'=>$perc_of_total_costs,
            //'perc_of_total_sales_profit'=>$perc_of_total_sales_profit,
          ],
          'delta_sales_num'=>$delta_sales['sales_num'],
          'delta_sales_value'=>$delta_sales['sales_value'],
          'delta_sales_cost'=>$delta_sales['sales_cost'],
          'delta_total_sales_profit'=>$delta_sales['total_sales_profit'],

      ];
      echo json_encode($return); exit;


    }

}
