<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';
class Sales_opportunity extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit('You are not allowed to access this page.');
        $this->load->model('dashboard_model');
        //$this->load->model('sql_model');
        $this->load->library('dashboard');
        $this->load->model('currencies_model');
        
        $this->base_currency = $this->currencies_model->get_base_currency();
    }

    public function index()
    {
        close_setup_menu();
        $data['title']  = _l(DASHBOARDS_MODULE.'_'.$this->router->fetch_class());
        if (!has_permission(DASHBOARDS_MODULE, '', $this->router->fetch_class())  && !is_admin()) {
            access_denied(DASHBOARDS_MODULE);
        }
        $this->load->model('opportunities_model');
        $this->load->model('staff_model');

        $data['statuses'] = $this->opportunities_model->get_status();
        $data['sales_persons'] = $this->staff_model->get('',['sales_kpi_category != 0']);
        $this->load->library('dashboard');
        $this->load->model('dashboard_period_filter_v2');

        $this->load->view($this->router->fetch_class(), $data);
    }
    public function load_opaw(){
      $this->load->model('goals/goals_model');
      $payload = file_get_contents('php://input'); //$this->input->post('params');
      $payload = json_decode($payload,true);



      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));
        
        die('{
          "status": true,
          "base_currency": "lei",
          "count_opportunities": '.$faker->numberBetween(10,1000).',
          "previous_opportunities": '.$faker->numberBetween(10,1000).',
          "tx_opportunities_change": "'.$faker->numberBetween(10,1000).'",
          "opportunities_change": '.$faker->numberBetween(10,1000).',
          "current_purchase_value_otf": '.$faker->numberBetween(10,1000).',
          "previous_purchase_value_otf": '.$faker->numberBetween(10,1000).',
          "tx_purchase_value_change_otf": "'.$faker->numberBetween(10,1000).'",
          "purchase_value_change_otf": '.$faker->numberBetween(10,1000).',
          "current_purchase_value_mrr": '.$faker->numberBetween(10,1000).',
          "previous_purchase_value_mrr": '.$faker->numberBetween(10,1000).',
          "tx_purchase_value_change_mrr": "'.$faker->numberBetween(10,1000).'",
          "purchase_value_change_mrr": '.$faker->numberBetween(10,1000).',
          "avg_current_purchase_value_otf": '.$faker->numberBetween(10,1000).',
          "avg_previous_purchase_value_otf": '.$faker->numberBetween(10,1000).',
          "tx_avg_purchase_value_change_otf": "'.$faker->numberBetween(10,1000).'",
          "avg_purchase_value_change_otf": '.$faker->numberBetween(10,1000).',
          "avg_current_purchase_value_mrr": '.$faker->numberBetween(10,1000).',
          "avg_previous_purchase_value_mrr": '.$faker->numberBetween(10,1000).',
          "tx_avg_purchase_value_change_mrr": "'.$faker->numberBetween(10,1000).'",
          "avg_purchase_value_change_mrr": '.$faker->numberBetween(10,1000).',
          "current_wins": '.$faker->numberBetween(10,1000).',
          "previous_wins": '.$faker->numberBetween(10,1000).',
          "current_win_rate": '.$faker->numberBetween(10,1000).',
          "previous_win_rate": '.$faker->numberBetween(10,1000).',
          "win_rate_change": '.$faker->numberBetween(10,1000).',
          "tx_win_rate_change": "'.$faker->numberBetween(10,1000).'",
          "reasons_ot":  '.json_encode($faker->randomElements([1,2,3,4,5,6,7,8,9],5)).',
          "reasons_mo": '.json_encode($faker->randomElements([1,2,3,4,5,6,7,8,9],5)).',
          "reasons_total_count": [
        
          ],
          "reasons_categories": '.json_encode($faker->randomElements(['Lost to competitor','No budget/lost funding','No decision / Non-responsive','Price','Other'],5)).'
        }');

      }


      $this->dashboard_period_filter_v2->reset();
      $this->dashboard_period_filter_v2->set_params($payload['params']);
      $count_opportunities = $this->dashboard_period_filter_v2
        ->from('tblleads')//->set_period_on($payload['params'],null)
        //->where(' (tblleads.status = 0 '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').') OR (tblleads.status != 0 '.  $this->dashboard_period_filter_v2->return_date_filtering_on('date_converted_to_opp','and').' ) ')
        ->where($this->dashboard_period_filter_v2->return_date_filtering_on('opportunity_date','',false).'')
        ->where('lost',0)
        ->where('is_opportunity',1)
        ->select('count(tblleads.id) as count_opportunities')
        ->select('sum(opportunity_ot_value) as sum_otf')
        ->select('sum(opportunity_mo_value) as sum_mrr')
        ->select('avg(opportunity_ot_value) as avg_otf')
        ->select('avg(opportunity_mo_value) as avg_mrr')
        ->number('count_opportunities');

        $current_purchase_value_otf = $this->dashboard_period_filter_v2->number('sum_otf');
        $current_purchase_value_mrr = $this->dashboard_period_filter_v2->number('sum_mrr');
        $avg_current_purchase_value_otf = $this->dashboard_period_filter_v2->number('avg_otf');
        $avg_current_purchase_value_mrr = $this->dashboard_period_filter_v2->number('avg_mrr');

      $previous_opportunities = $this->dashboard_period_filter_v2
        ->from('tblleads')//->set_period_on($payload['params'],null)
        //->where(' (tblleads.status = 0 '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).') OR (tblleads.status != 0 '.  $this->dashboard_period_filter_v2->return_date_filtering_on('date_converted_to_opp','and',true).' ) ')
        ->where($this->dashboard_period_filter_v2->return_date_filtering_on('opportunity_date','',true).'')

        ->where('lost',0)
        ->where('is_opportunity',1)
        ->select('count(tblleads.id) as count_opportunities')
        ->select('sum(opportunity_ot_value) as sum_otf')
        ->select('sum(opportunity_mo_value) as sum_mrr')
        ->select('avg(opportunity_ot_value) as avg_otf')
        ->select('avg(opportunity_mo_value) as avg_mrr')
        ->number('count_opportunities');
        $previous_purchase_value_otf = $this->dashboard_period_filter_v2->number('sum_otf');
        $previous_purchase_value_mrr = $this->dashboard_period_filter_v2->number('sum_mrr');
        $avg_previous_purchase_value_otf = $this->dashboard_period_filter_v2->number('avg_otf');
        $avg_previous_purchase_value_mrr = $this->dashboard_period_filter_v2->number('avg_mrr');


        $opportunities_change = $this->dashboard->delta($count_opportunities,$previous_opportunities);
        $tx_opportunities_change = '';
        if($opportunities_change > 0){
          $tx_opportunities_change = '+'.(string)round($opportunities_change).'%';
        }else if($opportunities_change < 0){
          $tx_opportunities_change = ''.(string)round($opportunities_change).'%';
        }

        $purchase_value_change_otf = $this->dashboard->delta($current_purchase_value_otf,$previous_purchase_value_otf);
        $tx_purchase_value_change_otf = '';
        if($purchase_value_change_otf > 0){
          $tx_purchase_value_change_otf = '+'.(string)round($purchase_value_change_otf).'%';
        }else if($purchase_value_change_otf < 0){
          $tx_purchase_value_change_otf = ''.(string)round($purchase_value_change_otf).'%';
        }

        $purchase_value_change_mrr = $this->dashboard->delta($current_purchase_value_mrr,$previous_purchase_value_mrr);
        $tx_purchase_value_change_mrr = '';
        if($purchase_value_change_mrr > 0){
          $tx_purchase_value_change_mrr = '+'.(string)round($purchase_value_change_mrr).'%';
        }else if($purchase_value_change_mrr < 0){
          $tx_purchase_value_change_mrr = ''.(string)round($purchase_value_change_mrr).'%';
        }

        $avg_purchase_value_change_otf = $this->dashboard->delta($avg_current_purchase_value_otf,$avg_previous_purchase_value_otf);
        $tx_avg_purchase_value_change_otf = '';
        if($avg_purchase_value_change_otf > 0){
          $tx_avg_purchase_value_change_otf = '+'.(string)round($avg_purchase_value_change_otf).'%';
        }else if($avg_purchase_value_change_otf < 0){
          $tx_avg_purchase_value_change_otf = ''.(string)round($avg_purchase_value_change_otf).'%';
        }

        $avg_purchase_value_change_mrr = $this->dashboard->delta($avg_current_purchase_value_mrr,$avg_previous_purchase_value_mrr);
        $tx_avg_purchase_value_change_mrr = '';
        if($avg_purchase_value_change_mrr > 0){
          $tx_avg_purchase_value_change_mrr = '+'.(string)round($avg_purchase_value_change_mrr).'%';
        }else if($avg_purchase_value_change_mrr < 0){
          $tx_avg_purchase_value_change_mrr = ''.(string)round($avg_purchase_value_change_mrr).'%';
        }




        $this->dashboard_period_filter_v2->reset();
        $this->dashboard_period_filter_v2->set_params($payload['params']);
        $current_wins = $this->dashboard_period_filter_v2
          ->from('tblleads')//->set_period_on($payload['params'],'last_opportunity_status_change')
          //->where(' (tblleads.status = 0 '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and').') OR (tblleads.status != 0 '.  $this->dashboard_period_filter_v2->return_date_filtering_on('date_converted_to_opp','and').' ) ')
          ->where($this->dashboard_period_filter_v2->return_date_filtering_on('opportunity_date','',true).'')

          ->where('status_opportunity',9)
          ->where('is_opportunity',1)
          ->where('lost',0)
          ->select('count(tblleads.id) as count_all')
          ->number('count_all');

        $this->dashboard_period_filter_v2->reset();
        $this->dashboard_period_filter_v2->set_params($payload['params']);
        $previous_wins = $this->dashboard_period_filter_v2
        ->from('tblleads')//->set_period_on($payload['params'],'last_opportunity_status_change',true)
        //->where(' (tblleads.status = 0 '.  $this->dashboard_period_filter_v2->return_date_filtering_on('dateadded','and',true).') OR (tblleads.status != 0 '.  $this->dashboard_period_filter_v2->return_date_filtering_on('date_converted_to_opp','and',true).' ) ')
        ->where($this->dashboard_period_filter_v2->return_date_filtering_on('opportunity_date','',true).'')

        ->where('status_opportunity',9)
        ->where('lost',0)
        ->where('is_opportunity',1)
        ->select('count(tblleads.id) as count_all')
        ->number('count_all');

        $current_win_rate = $this->dashboard->percent_in($current_wins,$count_opportunities);
        $previous_win_rate = $this->dashboard->percent_in($previous_wins,$previous_opportunities);
        $win_rate_change = $this->dashboard->delta($current_win_rate,$previous_win_rate);
        $tx_win_rate_change = '';
        if($win_rate_change > 0){
          $tx_win_rate_change = '+'.(string)round($win_rate_change).'%';
        }else if($win_rate_change < 0){
          $tx_win_rate_change = ''.(string)round($win_rate_change).'%';
        }



        $this->dashboard_period_filter_v2->reset();
        $lost_reason_data = $this->dashboard_period_filter_v2
          ->from('tblleads')->set_period_on($payload['params'],'opportunity_date')
          ->where('is_opportunity',1)
          ->where('lost',1)
          ->select('count(tblleads.id) as count_per_reason')
          ->select('sum(opportunity_ot_value) as sum_otf')
          ->select('sum(opportunity_mo_value) as sum_mrr')
          ->select('avg(opportunity_ot_value) as avg_otf')
          ->select('avg(opportunity_mo_value) as avg_mrr')
          ->select('IFNULL(tbllead_lost_reasons.name,"None")  as name')
          ->join('tbllead_lost_reasons','tbllead_lost_reasons.id = tblleads.id_lost_reason','LEFT')
          ->group_by('tblleads.id_lost_reason')
          ->result_array();

          $reasons_categories = array_column($lost_reason_data,'name');
          $reasons_total_count = array_column($lost_reason_data,'count_per_reason');
          $reasons_total_count = $this->dashboard->cast_int($reasons_total_count);
          $reasons_ot = array_column($lost_reason_data,'sum_otf');
          $reasons_ot = $this->dashboard->cast_int($reasons_ot);
          $reasons_mo = array_column($lost_reason_data,'sum_mrr');
          $reasons_mo = $this->dashboard->cast_int($reasons_mo);

        $return = [
            'status'=>true,
            'base_currency'=>get_base_currency()->symbol,

            'count_opportunities'=>$count_opportunities,
            'previous_opportunities'=>$previous_opportunities,
            'tx_opportunities_change'=>$tx_opportunities_change,
            'opportunities_change'=>$opportunities_change,

            'current_purchase_value_otf'=>$current_purchase_value_otf,
            'previous_purchase_value_otf'=>$previous_purchase_value_otf,
            'tx_purchase_value_change_otf'=>$tx_purchase_value_change_otf,
            'purchase_value_change_otf'=>$purchase_value_change_otf,

            'current_purchase_value_mrr'=>$current_purchase_value_mrr,
            'previous_purchase_value_mrr'=>$previous_purchase_value_mrr,
            'tx_purchase_value_change_mrr'=>$tx_purchase_value_change_mrr,
            'purchase_value_change_mrr'=>$purchase_value_change_mrr,

            'avg_current_purchase_value_otf'=>$avg_current_purchase_value_otf,
            'avg_previous_purchase_value_otf'=>$avg_previous_purchase_value_otf,
            'tx_avg_purchase_value_change_otf'=>$tx_avg_purchase_value_change_otf,
            'avg_purchase_value_change_otf'=>$avg_purchase_value_change_otf,

            'avg_current_purchase_value_mrr'=>$avg_current_purchase_value_mrr,
            'avg_previous_purchase_value_mrr'=>$avg_previous_purchase_value_mrr,
            'tx_avg_purchase_value_change_mrr'=>$tx_avg_purchase_value_change_mrr,
            'avg_purchase_value_change_mrr'=>$avg_purchase_value_change_mrr,

            'current_wins'=>$current_wins,
            'previous_wins'=>$previous_wins,
            'current_win_rate'=>$current_win_rate,
            'previous_win_rate'=>$previous_win_rate,
            'win_rate_change'=>$win_rate_change,
            'tx_win_rate_change'=>$tx_win_rate_change,

            'reasons_ot'=>$reasons_ot,
            'reasons_mo'=>$reasons_mo,
            'reasons_total_count'=>$reasons_total_count,
            'reasons_categories'=>$reasons_categories,


        ];
      echo json_encode($return);
    }

    public $perPage = 20;
    public function list_opportunities(){
          $config['per_page']    = $this->perPage;
          $config['table']    = 'tblleads';
          $config['id_field']    = 'id';


          if(get_option('demo_mode') == '1'){
            $faker = Faker\Factory::create();
            $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));
            $this->load->library('tmg/fakerlib');
            $array_list['clients'] = $this->fakerlib->get_data('clients','userid');
            $array_list['zones'] = $this->fakerlib->get_data('zones','id');
            $array_list['designations'] = $this->fakerlib->get_data('designations','id');
            
            $demo_data = [];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $demo_data[] = ['hash'=>$faker->uuid,'name'=>$faker->text(191),'subject'=>null,'position_id'=>$faker->numberBetween(0,2147483647),'title'=>$faker->randomElement([null,$faker->text(100)]),'company'=>$faker->company,'description'=>$faker->text(rand(100,100000)),'country'=>1,'zip'=>$faker->postcode,'city'=>$faker->city,'state'=>$faker->state,'state_id'=>$faker->state,'address'=>$faker->address,'assigned'=>$faker->numberBetween(0,2147483647),'dateadded'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'opportunity_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'from_form_id'=>$faker->numberBetween(0,2147483647),'status'=>$faker->numberBetween(0,2147483647),'pipeline'=>$faker->numberBetween(0,2147483647),'assigment'=>$faker->numberBetween(0,2147483647),'source'=>$faker->numberBetween(0,2147483647),'lastcontact'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'dateassigned'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'last_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'addedfrom'=>$faker->numberBetween(0,2147483647),'email'=>$faker->companyEmail,'website'=>$faker->url,'leadorder'=>$faker->numberBetween(0,2147483647),'phonenumber'=>$faker->phoneNumber,'date_converted'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'date_converted_to_opp'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'lost'=>$faker->randomElement([0,1]),'junk'=>$faker->numberBetween(0,2147483647),'last_lead_status'=>$faker->numberBetween(0,8),'is_imported_from_email_integration'=>$faker->randomElement([0,1]),'email_integration_uid'=>$faker->randomElement([null,$faker->text(30)]),'is_public'=>$faker->randomElement([0,1]),'default_language'=>$faker->randomElement([null,$faker->text(40)]),'client_id'=>1,'lead_value'=>$faker->randomFloat(4,0,1000),'opportunity_ot_value'=>$faker->randomFloat(4,0,1000),'opportunity_mo_value'=>$faker->randomFloat(4,0,1000),'vat'=>1234,'city_id'=>$faker->city,'zone_id'=>1,'industry_id'=>$faker->numberBetween(0,2147483647),'number_employees'=>$faker->numberBetween(0,2147483647),'turnovers'=>$faker->numberBetween(0,2147483647),'designation_id'=>$faker->randomElement($array_list['designations']),'score'=>$faker->numberBetween(0,2147483647),'is_opportunity'=>$faker->randomElement([0,1]),'qualification_type'=>$faker->randomElement([0,1]),'estimated_close_date'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d'),'budged_confirmed'=>$faker->randomElement([0,1]),'discovery_completed'=>$faker->randomElement([0,1]),'roi_analysis_completed'=>$faker->randomElement([0,1]),'next_step'=>null,'status_opportunity'=>$faker->numberBetween(0,8),'last_opportunity_status_change'=>$faker->dateTimeBetween('-1 year','now','Europe/Bucharest')->format('Y-m-d H:i:s'),'last_opportunity_status'=>$faker->numberBetween(0,8),'id_lost_reason'=>$faker->numberBetween(0,4),'id_from_campaign'=>$faker->numberBetween(0,3),];
            $r = rand(1,10);
            if($r < 4){
              $demo_data = [];
            }

            $response['html'] = '';
            $response['results'] = $demo_data;
            $response['totalRec'] = count($demo_data);
            echo json_encode($response); exit;
    
          }


          $request_body = file_get_contents('php://input');
          $request = json_decode($request_body);

          $this->load->model('filtering_model');
          // Per page limit
          $page = $request->page;
          if (!$page) {
              $offset = 0;
          } else {
              $offset = ($page*$this->perPage)-$this->perPage;
          }
          $searchValue = $this->input->post('searchValue');
          $filter_inputs = $this->input->post('filter_inputs[]');
          $serialized = $this->input->post('serialized');
          $attributes = $this->input->post('attributes');

          if ($searchValue != '') {
              $conditions['heur_search'] = $searchValue;
          }
          $conditions['attributes'] = $attributes;

          if(isset($request->params->period_filter)){
            $conditions['period_filter'] = $request->params->period_filter;
          }
          if(isset($request->params->date_from)){
            $conditions['date_from'] = $request->params->date_from;
          }
          if(isset($request->params->date_to)){
            $conditions['date_to'] = $request->params->date_to;
          }


          $conditions['where'] =
          [
            'lost = 0'
          ];
          if(isset($request->params->opp_status)){
            if($request->params->opp_status != ''){
              $conditions['where'][] = 'status_opportunity = "'.$request->params->opp_status.'"';
            }
          }


          if(isset($request->params->query->order)){
              $conditions['order_by'] = $request->params->query->order;
          }
          if(isset($request->params->query->filter)){
              $conditions['custom_filter'] = $request->params->query->filter;
          }

          if(empty($conditions['custom_filter'])){
            $conditions['custom_filter'] = new stdClass();
          }

          $conditions['returnType'] = 'count';

          $this->filtering_model->set_date_field('tblleads.opportunity_date');
          $totalRec = $this->filtering_model
          ->filter_api($conditions,$config)

          ->where('is_opportunity',1)
          ->get();




          $conditions = array(
              'start' => $offset,
              'limit' => $this->perPage,
              'heur_search' => $searchValue,
              'attributes'=>$attributes
          );
          $conditions['where'] =
          [
            'lost = 0'
          ];

          if(isset($request->params->opp_status)){
            if($request->params->opp_status != ''){
              $conditions['where'][] = 'status_opportunity = "'.$request->params->opp_status.'"';
            }
          }

          if(isset($request->params->period_filter)){
            $conditions['period_filter'] = $request->params->period_filter;
          }
          if(isset($request->params->date_from)){
            $conditions['date_from'] = $request->params->date_from;
          }
          if(isset($request->params->date_to)){
            $conditions['date_to'] = $request->params->date_to;
          }
          if(isset($request->params->query->order)){
              $conditions['order_by'] = $request->params->query->order;
          }
          if(isset($request->params->query->filter)){
              $conditions['custom_filter'] = $request->params->query->filter;
          }

          if(empty($conditions['custom_filter'])){
            $conditions['custom_filter'] = new stdClass();
          }


          $data['results'] = $this->filtering_model
            ->filter_api($conditions,$config)
            ->where('is_opportunity',1)
            ->select('tblleads.*')
            ->get();

          if(!empty($data['results'])){
            foreach($data['results'] as $k=>$result){

            }
          }
          $response['html'] = '';
          $response['results'] = $data['results'];
          $response['totalRec'] = $totalRec;
          echo json_encode($response); exit;
    }
}
