<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';
class Tactical_finance extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit(blank_page());
        $this->load->model('dashboard_model');
        //$this->load->model('sql_model');
        $this->load->library('dashboard');
    }

    public function index()
    {
        close_setup_menu();
        $data['title']  = _l(DASHBOARDS_MODULE.'_'.$this->router->fetch_class());
        if (!has_permission(DASHBOARDS_MODULE, '', $this->router->fetch_class())  && !is_admin()) {
            access_denied(DASHBOARDS_MODULE);
        }
        $this->load->model('filtering_model');



        $this->load->view($this->router->fetch_class(), $data);
    }

    public function load_income(){
      $payload = file_get_contents('php://input'); //$this->input->post('params');
      $payload = json_decode($payload,true);


      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));

                
        $total_sum = $faker->numberBetween(900,1000);
        $total_sum_prev = $faker->numberBetween(900,1000);

        $return = '{
          "status": true,
          "values": '.json_encode($faker->random_numbers_sum(31,10000)).',
          "total_sum": '.$total_sum.',
          "total_sum_prev": '.$total_sum_prev.',
          "delta": '.$faker->delta($total_sum,$total_sum_prev).'
        }';
    
        echo ($return);
        exit;
      }
      
      
        $this->load->model('dashboard_period_filter');
        $this->dashboard_period_filter->table = 'tblinvoices';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('sum(tblinvoices.total)');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthday();
        $data = $this->dashboard_period_filter->select()->add_select('sum(tblinvoices.total) as sum_total')->all_monthdays();


        $this->dashboard_period_filter->reset();
        $this->dashboard_period_filter->table = 'tblinvoices';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->set_prev_filtering();
        $this->dashboard_period_filter->formula('sum(tblinvoices.total)');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthday();
        $data_prev = $this->dashboard_period_filter->select()->add_select('sum(tblinvoices.total) as sum_total')->all_monthdays();
      

      $return = [
          'status'=>true,
          'values'=>$data,
          'total_sum'=>array_sum($data),
          'total_sum_prev'=>array_sum($data_prev),
      ];
      if($return['total_sum']-$return['total_sum_prev'] == 0 OR $return['total_sum'] == 0){
        $return['delta'] = 0;
      }else{
        $return['delta'] = round(($return['total_sum']-$return['total_sum_prev'])/$return['total_sum'] * 100);
      }

      echo json_encode($return);
      exit;
    }

    public function load_expenses(){
      $payload = file_get_contents('php://input'); //$this->input->post('params');
      $payload = json_decode($payload,true);

      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));

                
        $total_sum = $faker->numberBetween(900,1000);
        $total_sum_prev = $faker->numberBetween(900,1000);

        $return = '{
          "status": true,
          "values": '.json_encode($faker->random_numbers_sum(31,10000)).',
          "total_sum": '.$total_sum.',
          "total_sum_prev": '.$total_sum_prev.',
          "delta": '.$faker->delta($total_sum,$total_sum_prev).'
        }';
    
        echo ($return);
        exit;
      }
      
        $this->load->model('dashboard_period_filter');
        $this->dashboard_period_filter->table = 'tblexpenses';
        $this->dashboard_period_filter->date_field = 'dateadded';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('sum(tblexpenses.amount)');
        $this->dashboard_period_filter->group_only_by_monthday();
        $data = $this->dashboard_period_filter->select()->all_monthdays();

        $this->dashboard_period_filter->reset();
        $this->dashboard_period_filter->table = 'tblinvoices';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->set_prev_filtering();
        $this->dashboard_period_filter->formula('sum(tblinvoices.total)');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthday();
        $data_prev = $this->dashboard_period_filter->select()->add_select('sum(tblinvoices.total) as sum_total')->all_monthdays();
      

      $return = [
          'status'=>true,
          'values'=>$data,
          'total_sum'=>array_sum($data),
          'total_sum_prev'=>array_sum($data_prev),
      ];
      if($return['total_sum']-$return['total_sum_prev'] == 0 OR $return['total_sum'] == 0){
        $return['delta'] = 0;
      }else{
        $return['delta'] = ($return['total_sum']-$return['total_sum_prev'])/$return['total_sum'] * 100;
      }
      echo json_encode($return);
      exit;
    }

    public function load_net_profit(){
      $payload = file_get_contents('php://input'); //$this->input->post('params');
      $payload = json_decode($payload,true);

      if(get_option('demo_mode') == '1'){
        $faker = Faker\Factory::create();
        $faker->addProvider(new  Faker\Provider\LeadsProvider($faker));

                
        $total_sum = $faker->numberBetween(900,1000);
        $total_sum_prev = $faker->numberBetween(900,1000);

        $return = '{
          "status": true,
          "values": '.json_encode($faker->random_numbers_sum(31,10000)).',
          "total_sum": '.$total_sum.',
          "total_sum_prev": '.$total_sum_prev.',
          "delta": '.$faker->delta($total_sum,$total_sum_prev).'
        }';
    
        echo ($return);
        exit;
      }


        $this->load->model('dashboard_period_filter');
        $this->dashboard_period_filter->table = 'tblinvoices';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('sum(tblinvoices.total)');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthday();
        $data_inv = $this->dashboard_period_filter->select()->add_select('sum(tblinvoices.total) as sum_total')->all_monthdays();


        $this->dashboard_period_filter->reset();
        $this->dashboard_period_filter->table = 'tblinvoices';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->set_prev_filtering();
        $this->dashboard_period_filter->formula('sum(tblinvoices.total)');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthday();
        $data_prev_inv = $this->dashboard_period_filter->select()->add_select('sum(tblinvoices.total) as sum_total')->all_monthdays();

        $this->dashboard_period_filter->reset();
        $this->load->model('dashboard_period_filter');
        $this->dashboard_period_filter->table = 'tblexpenses';
        $this->dashboard_period_filter->date_field = 'dateadded';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->formula('sum(tblexpenses.amount)');
        $this->dashboard_period_filter->group_only_by_monthday();
        $data_exp = $this->dashboard_period_filter->select()->all_monthdays();

        $this->dashboard_period_filter->reset();
        $this->dashboard_period_filter->table = 'tblinvoices';
        $this->dashboard_period_filter->date_field = 'date';
        $this->dashboard_period_filter->set_filtering($payload['params']);
        $this->dashboard_period_filter->set_prev_filtering();
        $this->dashboard_period_filter->formula('sum(tblinvoices.total)');
        $this->dashboard_period_filter->general_condition('status != 0 AND status IS NOT NULL');
        $this->dashboard_period_filter->group_only_by_monthday();
        $data_prev_exp = $this->dashboard_period_filter->select()->add_select('sum(tblinvoices.total) as sum_total')->all_monthdays();

        $data = [];$data_prev = [];
        foreach($data_inv as $k=>$daily_income){
          $data[$k] = $daily_income-$data_exp[$k];
        }
        foreach($data_prev_inv as $k=>$daily_income){
          $data_prev[$k] = $daily_income-$data_prev_exp[$k];
        }


      

      $return = [
          'status'=>true,
          'values'=>$data,
          'total_sum'=>array_sum($data),
          'total_sum_prev'=>array_sum($data_prev),
      ];
      if($return['total_sum']-$return['total_sum_prev'] == 0 OR $return['total_sum'] == 0){
        $return['delta'] = 0;
      }else{
        $return['delta'] = round(($return['total_sum']-$return['total_sum_prev'])/$return['total_sum'] * 100,2);
      }
      echo json_encode($return);
      exit;
    }

    public $perPage = 20;
    function products_sold(){
      $config['base_url']    = base_url($this->router->fetch_module().'/'.$this->router->fetch_class().'/ajaxPaginationData');
      $config['per_page']    = $this->perPage;
      $config['table']    = 'tblitemable';
      $config['id_field']    = 'id';

      $request_body = file_get_contents('php://input');
      $request = json_decode($request_body);
      $this->load->model('filtering_model');
      // Per page limit
      $page = $request->page;
      if (!$page) {
          $offset = 0;
      } else {
          $offset = ($page*$this->perPage)-$this->perPage;
      }
      $searchValue = $this->input->post('searchValue');
      $filter_inputs = $this->input->post('filter_inputs[]');
      $serialized = $this->input->post('serialized');
      $attributes = $this->input->post('attributes');

      if ($searchValue != '') {
          $conditions['heur_search'] = $searchValue;
      }
      $conditions['attributes'] = $attributes;
      $conditions['where'] =
      [

      ];
      if(isset($request->params->period_filter)){
        $conditions['period_filter'] = $request->params->period_filter;
      }
      if(isset($request->params->date_from)){
        $conditions['date_from'] = $request->params->date_from;
      }
      if(isset($request->params->date_to)){
        $conditions['date_to'] = $request->params->date_to;
      }
      if(isset($request->params->query->order)){
          $conditions['order_by'] = $request->params->query->order;
      }
      if(isset($request->params->query->filter)){
          $conditions['custom_filter'] = $request->params->query->filter;
      }

      if(empty($conditions['custom_filter'])){
        $conditions['custom_filter'] = new stdClass();
      }

      $conditions['returnType'] = 'count';
      $this->filtering_model->set_date_field('tblinvoices.date');
      $totalRec = $this->filtering_model
        ->filter_api($conditions,$config)
        ->join('tblinvoices','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice" ')
        ->group_by('tblitemable.sku,IF((sku = ""),tblitemable.id,0)')
        ->get();


      $conditions = array(
          'start' => $offset,
          'limit' => $this->perPage,
          'heur_search' => $searchValue,
          'attributes'=>$attributes
      );
      $conditions['where'] =
      [

      ];
      if(isset($request->params->period_filter)){
        $conditions['period_filter'] = $request->params->period_filter;
      }
      if(isset($request->params->date_from)){
        $conditions['date_from'] = $request->params->date_from;
      }
      if(isset($request->params->date_to)){
        $conditions['date_to'] = $request->params->date_to;
      }
      if(isset($request->params->query->order)){
          $conditions['order_by'] = $request->params->query->order;
      }
      if(isset($request->params->query->filter)){
          $conditions['custom_filter'] = $request->params->query->filter;
      }

      if(empty($conditions['custom_filter'])){
        $conditions['custom_filter'] = new stdClass();
      }


      $data['results'] = $this->filtering_model
        ->filter_api($conditions,$config)
        ->join('tblinvoices','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice" ')
        ->join('tblitems','tblitems.id = tblitemable.item_id','LEFT')
        ->join('tblinventory_manage','tblinventory_manage.commodity_id = tblitems.id','LEFT')


        ->group_by('tblitemable.sku,IF((sku = ""),tblitemable.id,0)')
        ->select('tblitemable.description, sum(qty) as total_sold,sku,date,sum(inventory_number) as total_stock')
        ->calc_delta_as('sum(qty)','previous_total_sold','delta_sold',
        'tblitemable.sku = item.sku',
        [
          'tblinvoices'=>'inv',
          'tblitemable'=>'item',
          'tblitems'=>'iten_nom',
          'tblinventory_manage'=>'item_in_wh',

        ])
        ->get();

      if(!empty($data['results'])){
        foreach($data['results'] as $k=>$result){
          $t1 = $result['total_sold'];
          $t0 = $result['previous_total_sold'];
          if($t1 != 0 and $t0 != 0){
            $data['results'][$k]['delta'] = round(($t1-$t0)/$t0,2);
          }else{
            $data['results'][$k]['delta'] = 0;
          }
          $data['results'][$k]['image'] = CDN.'/static/icons/business-and-trade.png';
          $inv_date = $data['results'][$k]['date'];
          $has_tag = false;
          if      (strpos($data['results'][$k]['description'], '[SAPTAMANA]') !== false) {
              $replaced_value = _l('weeknumber') .' '. date("W", strtotime($inv_date));

              $data['results'][$k]['description']  = str_replace('[SAPTAMANA]',$replaced_value,$data['results'][$k]['description']);
              $has_tag = true;
          }else if (strpos($data['results'][$k]['description'], '[SAPTAMANA TRECUTA]') !== false) {
              $replaced_value = _l('weeknumber') .' '. date('W', strtotime('-1 week', strtotime($inv_date)));

              $data['results'][$k]['description']  = str_replace('[SAPTAMANA TRECUTA]',$replaced_value,$data['results'][$k]['description']);
              $has_tag = true;
          }else if (strpos($data['results'][$k]['description'], '[SAPTAMANA URMATOARE]') !== false) {
              $replaced_value = _l('weeknumber') .' '. date('W', strtotime('+1 week', strtotime($inv_date)));

              $data['results'][$k]['description']  = str_replace('[SAPTAMANA URMATOARE]',$replaced_value,$data['results'][$k]['description']);
              $has_tag = true;
          }else if (strpos($data['results'][$k]['description'], '[LUNA]') !== false) {
              $replaced_value = ' '. date("M Y", strtotime($inv_date));

              $data['results'][$k]['description']  = str_replace('[LUNA]',$replaced_value,$data['results'][$k]['description']);
              $has_tag = true;
          }else if (strpos($data['results'][$k]['description'], '[LUNA VIITOARE]') !== false) {
              $replaced_value = date("M Y",mktime(0,0,0,date("m", strtotime($inv_date))+1,1,date("Y", strtotime($inv_date))));

              $data['results'][$k]['description']  = str_replace('[LUNA VIITOARE]',$replaced_value,$data['results'][$k]['description']);
              $has_tag = true;
          }else if (strpos($data['results'][$k]['description'], '[LUNA TRECUTA]') !== false) {
              $replaced_value = date("M Y",mktime(0,0,0,date("m", strtotime($inv_date))-1,1,date("Y", strtotime($inv_date))));

              $data['results'][$k]['description']  = str_replace('[LUNA TRECUTA]',$replaced_value,$data['results'][$k]['description']);
              $has_tag = true;
          }else if (strpos($data['results'][$k]['description'], '[AN]') !== false) {
              $replaced_value = ' '. date("Y", strtotime($inv_date));

              $data['results'][$k]['description']  = str_replace('[AN]',$replaced_value,$data['results'][$k]['description']);
              $has_tag = true;
          }else if (strpos($data['results'][$k]['description'], '[ANUL TRECUT]') !== false) {
              $replaced_value =  date('Y', strtotime('-1 year', strtotime($inv_date)));

              $data['results'][$k]['description']  = str_replace('[ANUL TRECUT]',$replaced_value,$data['results'][$k]['description']);
              $has_tag = true;
          }else if (strpos($data['results'][$k]['description'], '[ANUL URMATOR]') !== false) {
              $replaced_value =  date('Y', strtotime('+1 year', strtotime($inv_date)));

              $data['results'][$k]['description']  = str_replace('[ANUL URMATOR]',$replaced_value,$data['results'][$k]['description']);
              $has_tag = true;
          }


          if($has_tag){
          $data['results'][$k]['description'] .= '<span class="badge badge-primary" style="margin-left:6px;">'._l('recurring_tag').'</span>';
          }



        }
      }
      $response['html'] = '';
      $response['results'] = $data['results'];
      echo json_encode($response); exit;
    }
    function customer_sales(){
        $config['base_url']    = base_url($this->router->fetch_module().'/'.$this->router->fetch_class().'/ajaxPaginationData');
        $config['per_page']    = $this->perPage;
        $config['table']    = 'tblitemable';
        $config['id_field']    = 'id';

        $request_body = file_get_contents('php://input');
        $request = json_decode($request_body);

        $this->load->model('filtering_model');
        // Per page limit
        $page = $request->page;
        if (!$page) {
            $offset = 0;
        } else {
            $offset = ($page*$this->perPage)-$this->perPage;
        }
        $searchValue = $this->input->post('searchValue');
        $filter_inputs = $this->input->post('filter_inputs[]');
        $serialized = $this->input->post('serialized');
        $attributes = $this->input->post('attributes');

        if ($searchValue != '') {
            $conditions['heur_search'] = $searchValue;
        }
        $conditions['attributes'] = $attributes;

        if(isset($request->params->period_filter)){
          $conditions['period_filter'] = $request->params->period_filter;
        }
        if(isset($request->params->date_from)){
          $conditions['date_from'] = $request->params->date_from;
        }
        if(isset($request->params->date_to)){
          $conditions['date_to'] = $request->params->date_to;
        }

        $conditions['where'] =
        [

        ];
        if(isset($request->params->query->order)){
            $conditions['order_by'] = $request->params->query->order;
        }
        if(isset($request->params->query->filter)){
            $conditions['custom_filter'] = $request->params->query->filter;
        }

        if(empty($conditions['custom_filter'])){
          $conditions['custom_filter'] = new stdClass();
        }

        $conditions['returnType'] = 'count';

        $this->filtering_model->set_date_field('tblinvoices.date');
        $totalRec = $this->filtering_model
        ->filter_api($conditions,$config)
        ->join('tblinvoices','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice" ')
        ->join('tblclients','tblclients.userid = tblinvoices.clientid')
        ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
        ->group_by('tblclients.userid,tblitemable.currency')
        ->get();




        $conditions = array(
            'start' => $offset,
            'limit' => $this->perPage,
            'heur_search' => $searchValue,
            'attributes'=>$attributes
        );
        $conditions['where'] =
        [

        ];
        if(isset($request->params->period_filter)){
          $conditions['period_filter'] = $request->params->period_filter;
        }
        if(isset($request->params->date_from)){
          $conditions['date_from'] = $request->params->date_from;
        }
        if(isset($request->params->date_to)){
          $conditions['date_to'] = $request->params->date_to;
        }
        if(isset($request->params->query->order)){
            $conditions['order_by'] = $request->params->query->order;
        }
        if(isset($request->params->query->filter)){
            $conditions['custom_filter'] = $request->params->query->filter;
        }

        if(empty($conditions['custom_filter'])){
          $conditions['custom_filter'] = new stdClass();
        }


        $data['results'] = $this->filtering_model
          ->filter_api($conditions,$config)
          ->join('tblinvoices','tblinvoices.id = tblitemable.rel_id and rel_type = "invoice" ')
          ->join('tblclients','tblclients.userid = tblinvoices.clientid')
          ->join('tblcurrencies','tblcurrencies.id = tblitemable.currency')
          ->group_by('tblclients.userid,tblitemable.currency')
          ->select('tblclients.vat,count(tblitemable.id) as sales_count,sum(tblitemable.qty) as total_sales,tblcurrencies.symbol')
          ->calc_delta_as('sum(tblitemable.qty)','previous_total_sold','delta_sold',
          'tblitemable.sku = item.sku',
          [
            'tblinvoices'=>'inv',
            'tblitemable'=>'item',
            'tblclients'=>'cl',
            'tblcurrencies'=>'cur'
          ])
          ->get();

        if(!empty($data['results'])){
          foreach($data['results'] as $k=>$result){
            $data['results'][$k]['image'] = CDN.'/static/icons/business-and-trade.png';

          }
        }
        $response['html'] = '';
        $response['results'] = $data['results'];
        echo json_encode($response); exit;
  }

}
