<?php
defined('BASEPATH') or exit('No direct script access allowed');
include APPPATH.'/third_party/faker/autoload.php';
class Team_password extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        defined('DASHBOARDS_MODULE') or exit(blank_page());
        $this->load->model('dashboard_model');
        $this->load->library('dashboard');
        $this->load->model('dashboard_period_filter_v2');
    }

    public function index()
    {
        close_setup_menu();
        $data['title']  = _l(DASHBOARDS_MODULE.'_'.$this->router->fetch_class());
        if (!has_permission(DASHBOARDS_MODULE, '', $this->router->fetch_class())  && !is_admin()) {
            access_denied(DASHBOARDS_MODULE);
        }
        $this->load->model('team_password/team_password_model');
        $data['tp_count'] = $this->team_password_model->get_count_password_dashboard();
        $data['password_by_cate'] = json_encode($this->team_password_model->count_password_by_category());
        $data['share_by_type'] = json_encode($this->team_password_model->count_share_by_type());
        $data['your_password_shared'] = $this->team_password_model->get_your_password_shared();
        $data['password_expire'] = $this->team_password_model->get_password_expire();
        $this->load->model('filtering_model');
        $this->load->view($this->router->fetch_class(), $data);
    }
    public function allcharts(){
      $this->load->model('goals/goals_model');
      $payload = file_get_contents('php://input'); //$this->input->post('params');
      $payload = json_decode($payload,true);


      if(get_option('demo_mode') == '1'){
        $total_password = 100;
        $arr_passwords_percents = [
          ['name'=> _l('normal_password'),'color'=>'#17A2B8','y'=>$this->dashboard->percent_in(20,$total_password)],
          ['name'=> _l('bank_account'),'color'=>'#4a17b8','y'=>$this->dashboard->percent_in(10,$total_password)],
          ['name'=> _l('credit_card'),'color'=>'#b81789','y'=>$this->dashboard->percent_in(5,$total_password)],
          ['name'=> _l('email'),'color'=>'#b81757','y'=>$this->dashboard->percent_in(25,$total_password)],
          ['name'=> _l('server'),'color'=>'#17b85e','y'=>$this->dashboard->percent_in(20,$total_password)],
          ['name'=> _l('software_license'),'color'=>'#17b8b8','y'=>$this->dashboard->percent_in(20,$total_password)]
        ];
        $arr_shared_percents = [
            ['name'=> _l('normal_password'),'color'=>'#17A2B8','y'=>$this->dashboard->percent_in(20,$total_password)],
            ['name'=> _l('bank_account'),'color'=>'#4a17b8','y'=>$this->dashboard->percent_in(10,$total_password)],
            ['name'=> _l('credit_card'),'color'=>'#b81789','y'=>$this->dashboard->percent_in(5,$total_password)],
            ['name'=> _l('email'),'color'=>'#b81757','y'=>$this->dashboard->percent_in(25,$total_password)],
            ['name'=> _l('server'),'color'=>'#17b85e','y'=>$this->dashboard->percent_in(20,$total_password)],
            ['name'=> _l('software_license'),'color'=>'#17b8b8','y'=>$this->dashboard->percent_in(20,$total_password)]
          ];

      $return = [
        'status'=>true,
        'vars'=>[
          'total_password'=>100,
          'normal_password'=>20,
          'bank_account'=>10,
          'credit_card'=>5,
          'email'=>25,
          'server'=>20,
          'software_license'=>20,
          'shared'=>10,
        ],
        'arr_passwords_percents'=>$arr_passwords_percents,
        'arr_shared_percents'=>$arr_shared_percents,

    ];
    echo json_encode($return); exit;
    }


      $this->dashboard_period_filter_v2->reset();
      $this->dashboard_period_filter_v2->set_params($payload['params']);
      $rs = $this->dashboard_period_filter_v2
        ->from('(SELECT "1") as faketbl')
        ->select('
          (SELECT count(*) FROM tbltp_normal
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','WHERE').'
          ) as normal
        ')
        ->select('
          (SELECT count(*) FROM tbltp_bank_account
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','WHERE').'
          ) as bank_account
        ')
        ->select('
          (SELECT count(*) FROM tbltp_credit_card
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','WHERE').'
          ) as credit_card
        ')
        ->select('
          (SELECT count(*) FROM tbltp_email
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','WHERE').'
          ) as email
        ')
        ->select('
          (SELECT count(*) FROM tbltp_server
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','WHERE').'
          ) as server
        ')
        ->select('
          (SELECT count(*) FROM tbltp_software_license
            '.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','WHERE').'
          ) as software_license
        ')


        ->select('(SELECT count(*) FROM tbltp_share WHERE type = "normal"'.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','and').') as shared_normal')
        ->select('(SELECT count(*) FROM tbltp_share WHERE type = "bank_account"'.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','and').') as shared_bank_account')
        ->select('(SELECT count(*) FROM tbltp_share WHERE type = "credit_card"'.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','and').') as shared_credit_card')
        ->select('(SELECT count(*) FROM tbltp_share WHERE type = "email"'.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','and').') as shared_email')
        ->select('(SELECT count(*) FROM tbltp_share WHERE type = "server"'.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','and').') as shared_server')
        ->select('(SELECT count(*) FROM tbltp_share WHERE type = "software_license"'.  $this->dashboard_period_filter_v2->return_date_filtering_on('datecreator','and').') as shared_software_license')

        ->row_array();
        foreach($rs as $k=>$v){
          $rs[$k] = (int)$v;
        }
        $total_password = $rs['normal'] + $rs['bank_account'] + $rs['credit_card'] + $rs['email'] + $rs['server'] + $rs['software_license'];
        $total_shared_passwords = $rs['shared_normal'] + $rs['shared_bank_account'] + $rs['shared_credit_card'] + $rs['shared_email'] + $rs['shared_server'] + $rs['shared_software_license'];

      $arr_passwords_percents = [
          ['name'=> _l('normal_password'),'color'=>'#17A2B8','y'=>$this->dashboard->percent_in($rs['normal'],$total_password)],
          ['name'=> _l('bank_account'),'color'=>'#4a17b8','y'=>$this->dashboard->percent_in($rs['bank_account'],$total_password)],
          ['name'=> _l('credit_card'),'color'=>'#b81789','y'=>$this->dashboard->percent_in($rs['credit_card'],$total_password)],
          ['name'=> _l('email'),'color'=>'#b81757','y'=>$this->dashboard->percent_in($rs['email'],$total_password)],
          ['name'=> _l('server'),'color'=>'#17b85e','y'=>$this->dashboard->percent_in($rs['server'],$total_password)],
          ['name'=> _l('software_license'),'color'=>'#17b8b8','y'=>$this->dashboard->percent_in($rs['software_license'],$total_password)]
        ];
        $arr_shared_percents = [
            ['name'=> _l('normal_password'),'color'=>'#17A2B8','y'=>$this->dashboard->percent_in($rs['shared_normal'],$total_password)],
            ['name'=> _l('bank_account'),'color'=>'#4a17b8','y'=>$this->dashboard->percent_in($rs['shared_bank_account'],$total_password)],
            ['name'=> _l('credit_card'),'color'=>'#b81789','y'=>$this->dashboard->percent_in($rs['shared_credit_card'],$total_password)],
            ['name'=> _l('email'),'color'=>'#b81757','y'=>$this->dashboard->percent_in($rs['shared_email'],$total_password)],
            ['name'=> _l('server'),'color'=>'#17b85e','y'=>$this->dashboard->percent_in($rs['shared_server'],$total_password)],
            ['name'=> _l('software_license'),'color'=>'#17b8b8','y'=>$this->dashboard->percent_in($rs['shared_software_license'],$total_password)]
          ];
          if($total_shared_passwords == 0){ $arr_shared_percents = []; }
          if($total_password == 0){ $arr_passwords_percents = []; }

        $return = [
            'status'=>true,
            'vars'=>[
              'total_password'=>$total_password,
              'normal_password'=>$rs['normal'],
              'bank_account'=>$rs['bank_account'],
              'credit_card'=>$rs['credit_card'],
              'email'=>$rs['email'],
              'server'=>$rs['server'],
              'software_license'=>$rs['software_license'],
              'shared'=>$total_shared_passwords,
            ],
            'arr_passwords_percents'=>$arr_passwords_percents,
            'arr_shared_percents'=>$arr_shared_percents,

        ];
      echo json_encode($return); exit;
    }


}
