<?php
defined('BASEPATH') or exit('No direct script access allowed');
/*
Module Name: CRMconnect Dashboards
Version: 1.0.0
*/
define('DASHBOARDS_MODULE', 'dashboards');
define('DASH_DEMO', false);
define('DASHBOARDS_FOLDER', FCPATH . 'uploads/' . DASHBOARDS_MODULE . '/');
// runs when module is been activated
register_activation_hook(DASHBOARDS_MODULE, 'setup_dashboards_module');
hooks()->add_action('admin_init', 'dashboards_register_permissions');
hooks()->add_action('admin_init', 'dashboards_menu');
hooks()->add_action('app_admin_head', 'dashboards_add_head_components');
hooks()->add_action('app_admin_footer', 'dashboards_add_footer_components');
register_language_files(DASHBOARDS_MODULE, [DASHBOARDS_MODULE]);
$CI = &get_instance();
$CI->load->helper(DASHBOARDS_MODULE . '/' . DASHBOARDS_MODULE);

/**
 * creates db operations for subscription products
 */
function setup_dashboards_module()
{
    //require(__DIR__ . '/install.php');
}

/**
 *  registers menu item for admin
 */
function dashboards_menu()
{
    $CI = &get_instance();

    if (has_permission(DASHBOARDS_MODULE, '', 'ceo_strategic')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'ceo_strategic',
            'name' => 'dashboards_ceo_strategic',
            'href' => site_url('dashboards/ceo_strategic'),
            'position' => 1,
        ]);
    }
    if (has_permission(DASHBOARDS_MODULE, '', 'cfo_strategic')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'cfo_strategic',
            'name' => 'dashboards_cfo_strategic',
            'href' => site_url('dashboards/cfo_strategic'),
            'position' => 3,
        ]);
    }
    if (has_permission(DASHBOARDS_MODULE, '', 'cmo_strategic')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'cmo_strategic',
            'name' => 'dashboards_cmo_strategic',
            'href' => site_url('dashboards/cmo_strategic'),
            'position' => 2,
        ]);
    }

    if (has_permission(DASHBOARDS_MODULE, '', 'sales_conversion')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'sales_conversion',
            'name' => 'dashboards_sales_conversion',
            'href' => site_url('dashboards/sales_conversion'),
            'position' => 4,
        ]);
    }

    if (has_permission(DASHBOARDS_MODULE, '', 'sales_opportunity')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'sales_opportunity',
            'name' => 'dashboards_sales_opportunity',
            'href' => site_url('dashboards/sales_opportunity'),
            'position' => 5,
        ]);
    }

    if (has_permission(DASHBOARDS_MODULE, '', 'sales_kpi')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'sales_kpi',
            'name' => 'dashboards_sales_kpi',
            'href' => site_url('dashboards/sales_kpi'),
            'position' => 6,
        ]);
    }
    if (has_permission(DASHBOARDS_MODULE, '', 'sales_cycle')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'sales_cycle',
            'name' => 'dashboards_sales_cycle',
            'href' => site_url('dashboards/sales_cycle'),
            'position' => 7,
        ]);
    }
    if (has_permission(DASHBOARDS_MODULE, '', 'inbound_lead_generation')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'inbound_lead_generation',
            'name' => 'dashboards_inbound_lead_generation',
            'href' => site_url('dashboards/inbound_lead_generation'),
            'position' => 7,
        ]);
    }

    if (has_permission(DASHBOARDS_MODULE, '', 'okr_dashboard')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'okr_dashboard',
            'name' => 'dashboards_okr_dashboard',
            'href' => site_url('dashboards/okr_dashboard'),
            'position' => 10,
        ]);
    }

    if (has_permission(DASHBOARDS_MODULE, '', 'helpdesk')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'helpdesk',
            'name' => 'dashboards_helpdesk',
            'href' => site_url('dashboards/helpdesk'),
            'position' => 8,
        ]);
    }
    if (has_permission(DASHBOARDS_MODULE, '', 'tactical_finance')) {
        $CI->app_menu->add_sidebar_children_item('dashboard', [
            'slug' => DASHBOARDS_MODULE . 'tactical_finance',
            'name' => 'dashboards_tactical_finance',
            'href' => site_url('dashboards/tactical_finance'),
            'position' => 9,
        ]);
    }

}

function dashboards_register_permissions()
{
    $capabilities = [];
    $capabilities[DASHBOARDS_MODULE] = [
        'sales_conversion' => _l('permission_sales_conversion'),
        'sales_opportunity' => _l('permission_sales_opportunity'),
        'okr_dashboard' => _l('permission_okr_dashboard'),
    ];

    register_staff_capabilities(DASHBOARDS_MODULE, $capabilities, _l(DASHBOARDS_MODULE), _l('management_permissions'));
}


/**
 * commission add head components
 * @return
 */
function dashboards_add_head_components()
{
    $CI = &get_instance();

    if ($CI->router->fetch_module() == 'dashboards') {
        echo '<link href="' . module_dir_url(DASHBOARDS_MODULE, 'assets/crmcon.css') . '"  rel="stylesheet" type="text/css" />';
        echo '<link href="' . module_dir_url(DASHBOARDS_MODULE, 'assets/okr.css') . '"  rel="stylesheet" type="text/css" />'; ?>
        <script>
            var csrf_token_name = '<?php echo $CI->security->get_csrf_token_name(); ?>';
            var csrf_hash = '<?php echo $CI->security->get_csrf_hash(); ?>';
        </script>
        <link href="https://cdn.jsdelivr.net/gh/greghub/funnel-graph-js@master/dist/css/main.min.css" rel="stylesheet"
              type="text/css">
        <link href="https://cdn.jsdelivr.net/gh/greghub/funnel-graph-js@master/dist/css/theme.min.css" rel="stylesheet"
              type="text/css">

        <?php
    }

    /*if (!(strpos($viewuri, '/admin/minutes/create') === false)) {
        echo '<link href="' . module_dir_url(DASHBOARDS_MODULE, 'assets/minutes.css') . '"  rel="stylesheet" type="text/css" />';
    }*/
}

/**
 * commission add footer components
 * @return
 */
function dashboards_add_footer_components()
{
    $CI = &get_instance();

    if ($CI->router->fetch_module() == 'dashboards') {
        /*echo '<script src="' . site_url('assets/plugins/highcharts/highcharts.js') . '"></script>'; */ ?>
        <script src="https://code.highcharts.com/stock/highstock.js"></script>


        <script src="https://cdn.jsdelivr.net/npm/vue@2.6.14/dist/vue.js"></script>
        <script src="https://unpkg.com/vue-i18n@8"></script>
        <script src="https://unpkg.com/axios/dist/axios.min.js"></script>     <!--<script src="https://cdn.jsdelivr.net/npm/vue@2.6.14"></script>-->
        <script src="https://unpkg.com/vue-infinite-loading@^2/dist/vue-infinite-loading.js"></script>
        <script src="https://code.highcharts.com/modules/no-data-to-display.js"></script>

        <script src="https://cdn.jsdelivr.net/gh/greghub/funnel-graph-js/dist/js/funnel-graph.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/tween.js/16.3.5/Tween.min.js"></script>
        <?php
        require_once(module_views_path(DASHBOARDS_MODULE, 'x-templates.php')); ?>


        <script type="module" src="<?= module_dir_url(DASHBOARDS_MODULE, 'assets/app.js') ?>"></script>


        <?php
    }
}


if (get_option('demo_mode') == '1') {
    hooks()->add_action('before_dashboards_content', 'warning_demo_mode');
}
function warning_demo_mode()
{
    ?>

    <div class="alert alert-warning alert-demo-mode" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        <strong class="d-block d-sm-inline-block-force"><?= _l('demo_mode_warning_title'); ?></strong>
        <?= _l('demo_mode_warning_content') . ' <a href="#" class="text text-success deactivate-demo">' . _l('btn_deactivate_demo_mode') . '</a>'; ?>
    </div>
    <?php
}