<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard {

    public $decimals = 0;
    public $color_default = '#008080';
    public $colors_waterfall = [
        //https://www.schemecolor.com/color/web
        //https://www.color-hex.com/color-palettes/
        //https://api.highcharts.com/highcharts/colors
        'turqoiuse'=>['#008080','#17d6b2','#71dfd1','#75cfdf','#5ae2fa','#91eafa','#009cb8'],
        'pallete-1'=>['#d3f6f2','#9ce2f2','#7c788b','#ace9bd','#a2b6ff'],
        'apple-juice'=>['#ff5d5d','#ffda69','#ffdb84','#8adb87','#9cff7d'],
        'nice'=>['#f9df7f','#ffc0cb','#c4e4f3','#cbaf95','#f8d3f1'],
        'stripe'=>['#f9ce71','#eb6d3d','#7cd0c0','#4f7084'],
        'vibrant'=>['#faaced','#585dff','#ff4e4e','#5afd65','#01cdfe'],
        'forrest'=>['#9CAB4A','#425B35','#393C21','#AA9B81'],

        //https://coolors.co/
        //5BC0EB,E6AF2E,C3423F,404E4D,20BF55
        //264653,2A9D8F,E9C46A,F4A261,E76F51
        'aquamarine'=>['03045E','023E8A','0077B6','0096C7','00B4D8','48CAE4','90E0EF','ADE8F4','CAF0F8'],


    'warm'=>["#ffadad","#ffd6a5","#fdffb6","#caffbf","#9bf6ff","#a0c4ff","#bdb2ff","#ffc6ff","#fffffc"],
    /*
    {"Light Pink":"ffadad","Deep Champagne":"ffd6a5","Lemon Yellow Crayola":"fdffb6","Tea Green":"caffbf","Celeste":"9bf6ff","Baby Blue Eyes":"a0c4ff","Maximum Blue Purple":"bdb2ff","Mauve":"ffc6ff","Baby Powder":"fffffc"}*/

        'dragon'=>["#ffbe0b","#fb5607","#ff006e","#8338ec","#3a86ff"],

    /* Object
    {"Mango":"ffbe0b","Orange Pantone":"fb5607","Winter Sky":"ff006e","Blue Violet":"8338ec","Azure":"3a86ff"}*/

        //Split complementary
        'flower'=>["#2a2585","#ff59bf","#eb219d","#6abd4a","#649950"],



    ];
    public $default_scheme = 'dragon';
    public function __construct(){
        //parent::__construct();
        //$this->load->model('dashboard_model');
        //$this->load->language('dashboard');
    }

    public $waterfall_count = 0;
    public function reset(){

        $this->waterfall_count = 0;
    }
    public function set_color($set = null){
        if($set == null){
            if($this->default_scheme == null){
                foreach($this->colors_waterfall as $wf){
                    $selected = $wf; continue;
                }
            }else{
                $selected = $this->default_scheme;
            }
        }else{
            if(empty($this->colors_waterfall[$set])){
                if($this->default_scheme == null){
                    foreach($this->colors_waterfall as $wf){
                        $selected = $wf; continue;
                    }
                }else{
                    $selected = $this->default_scheme;
                }
            }else{
                $selected = $this->colors_waterfall[$set];
            }
        }

        if(empty($this->colors_waterfall[$selected])){
            if($this->default_scheme == null){
                $color = $this->color_default;
            }else{
                $selected = $this->default_scheme;
                $color = $this->colors_waterfall[$selected][$this->waterfall_count];
            }
        }else{
            if(isset($this->colors_waterfall[$selected][$this->waterfall_count])){
                $color = $this->colors_waterfall[$selected][$this->waterfall_count];
            }else{
                $color = $this->color_default;
            }
        }


        $this->waterfall_count++;
        return $color;
    }
    public function set_color_theme($wf_name){
        $this->reset();
        if(empty($this->colors_waterfall[$wf_name])){
            return;
        }

        $this->default_scheme = $wf_name;
    }


    public $cur = 'RON';
    public $basecur = 'RON';

    public $rate_multiplier = [
        'RON'=>[
            'RON'=>1,
            'EUR'=>1/4.95,
            'USD'=>1/4.27
        ],

        'EUR'=>[
            'RON'=>4.95,
            'EUR'=>1,
            //'USD'=>4.95/4.27
        ],

        'USD'=>[
            'USD'=>1,
            'RON'=>4.27
        ],
    ];
    public function convert_currency($amounts,$rate_multiplier = null){
        if($rate_multiplier == null){
            $rate_multiplier = $this->rate_multiplier[$this->basecur][$this->cur];
        }

        if(is_array($amounts)){
            if(!empty($amounts)){
                foreach($amounts as $k=>$amount){
                    //if (str_starts_with($k, 'count_')) {
                    if(substr( $k, 0, 4 ) === "count_"){
                        continue;

                    }
                    $amounts[$k] = $amount*$rate_multiplier;
                    $amounts[$k] = round($amounts[$k],$this->decimals);
                }
            }
        }else{
            $amounts = $amounts*$rate_multiplier;
            $amounts = round($amounts,$this->decimals);
        }
        return $amounts;
    }




    public function generate_days($date = null,$type = 'Y-m-d'){
      return [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31];
    }
    public function days_of_month($month = null, $year = null) {
      if(!$month){ $month = date('m'); }
      if(!$year){ $year = date('Y'); }

        $num = cal_days_in_month(CAL_GREGORIAN, $month, $year);
        $dates_month = array();

        for ($i = 1; $i <= $num; $i++) {
            $mktime = mktime(0, 0, 0, $month, $i, $year);
            $date = date("d", $mktime);
            if(strtotime(date("Y-m-d", $mktime)) > strtotime(date('Y-m-d'))){ continue; }
            $dates_month[$i] = $date;
        }
        $dates_month = array_values($dates_month);
        return $dates_month;
    }


    public function fill_days_with_zero($results,$from_date,$to_date){
      $return = [];
      foreach($results as $k=>$result){
        $newk = (int)$k;
        if($newk < 10){$newk = '0'.$newk; }
        $return[$newk] = $result;
      }

      $month = date('m',strtotime($from_date));
      $year = date('Y',strtotime($from_date));
      $month_1 = $this->days_of_month($month, $year);

      $month = date('m',strtotime($to_date));
      $year = date('Y',strtotime($to_date));
      $month_2 = $this->days_of_month($month, $year);
      $alldays = array_unique(array_merge(array_values($month_1), array_values($month_2)));
      foreach($alldays as $k=>$day){
        if(!isset($return[$day])){
          $return[$day] = 0;
        }
      }
      ksort($return,SORT_NUMERIC );

      return $return;
    }
    public function fill_hours_with_zero($results,$prefix = '',$sufix = ''){

      $return = [];
      foreach($results as $k=>$result){
        $newk = (int)$k;
        if($newk < 10){$newk = '0'.$newk; }
        $return[$newk] = $result;
      }

      $alldays = ['00','01','02','03','04','05','06','07','08','09','10',
      '11','12','13','14','15','16','17','18','19','20',
      '21','22','23'
      ];
      foreach($alldays as $k=>$day){
        $newkey = $prefix.$day.$sufix;
        if(!isset($return[$newkey])){
          $return[$newkey] = 0;
        }
      }
      ksort($return,SORT_STRING );

      return $return;



    }
    public function fill_monthnames_with_zero($results,$from_date,$to_date){
      $return = [];
      if(!empty($results)){
      foreach($results as $k=>$result){
        $newk = $k;
        /*switch ($k) {
          case '01':
            $newk = 'Jan';
            break;
          case '02':
            $newk = 'Feb';
            break;
          case '03':
            $newk = 'Mar';
            break;
          case '04':
            $newk = 'Apr';
            break;
          case '05':
            $newk = 'May';
            break;
          case '06':
            $newk = 'Iun';
            break;
          case '07':
            $newk = 'Iul';
            break;
          case '08':
            $newk = 'Aug';
            break;
          case '09':
            $newk = 'Sep';
            break;
          case '10':
            $newk = 'Oct';
            break;
          case '11':
            $newk = 'Nov';
            break;
          case '12':
            $newk = 'Dec';
            break;
          default:
            break;
        }*/
        $return[$newk] = $result;
      }}

      $alldays = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
      foreach($alldays as $k=>$day){
        if(!isset($return[$day])){
          $return[$day] = 0;
        }
      }

      foreach($return as $month=>$data) {
          $m = date_parse($month);
          $return[$m['month']] = $data;
          unset($return[$month]);
      }
      ksort($return);



      return $return;
    }

    public function percent_in($number,$total,$round = 0){
      if($number == 0 OR $total == 0) return 0;
      return round($number/$total*100,$round);
    }

    public function delta($t1,$t0){
      if($t1 == 0 AND $t0 == 0) return 0;
      if($t0 == 0) return 100;

      $d = ($t1-$t0)/$t0;
      return round($d*100);
    }
    public function division($t1,$t0,$decimals){
      if($t1 == 0 OR $t0 == 0) return 0;

      $d = ($t1/$t0);
      return round($d,$decimals);
    }
    public function substract($a,$b){
      $a = (int)$a;
      $b = (int)$b;
      return $a-$b;
    }

    public function cast_int($results){
      if(!empty($results)){
        foreach($results as $k=>$result){
          $results[$k] = (int)$result;
        }
      }
      return $results;
    }
    public function cast_float($results){
      if(!empty($results)){
        foreach($results as $k=>$result){
          $results[$k] = (float)$result;
        }
      }
      return $results;
    }

}
