<?php
class Dashboard_period_filter extends CI_Model {

  public $index_formula = 'COUNT(*)';
  public $period = false;
  public $table = '';
  public $date_field = 'date';
  public $group = null;
  public $from_date = null;
  public $to_date = null;
  public $where = null;
  public $general_where = null;
  public $select_group_name = null;
  public $params = null;
  public $filtering_period = null;
  public function __construct(){
    parent::__construct();

  }
  public function reset(){
    $this->index_formula = 'COUNT(*)';
    $this->period = false;
    $this->table = '';
    $this->date_field = 'date';
    $this->group = null;
    $this->from_date = null;
    $this->to_date = null;
    $this->where = null;

    $this->general_where = null;
    $this->params = null;
    $this->select_group_name = null;
    $this->filtering_period = null;

  }
  public function set_filtering($params){
    $this->params = $params;
  }
  public function set_prev_filtering(){
    $this->filtering_period = 'prev';
  }


  public function unset_filtering(){
    $this->params = null;
  }
  public function formula($formula){
    $this->index_formula = $formula;
  }
  public function group_only_by_monthday(){
    $this->select_group_name = 'DAYOFMONTH('.$this->table.'.'.$this->date_field.')';
    $this->group = 'DAYOFMONTH('.$this->table.'.'.$this->date_field.')';
  }
  public function group_only_by_monthname(){
    $this->select_group_name = 'MONTHNAME('.$this->table.'.'.$this->date_field.')';
    $this->select_group_name = 'DATE_FORMAT('.$this->table.'.'.$this->date_field.',"%b")';

    $this->group = 'MONTHNAME('.$this->table.'.'.$this->date_field.')';
  }
  public function group_only_by_hours(){
    $this->select_group_name = 'HOUR('.$this->table.'.'.$this->date_field.')';
    $this->select_group_name = 'DATE_FORMAT('.$this->table.'.'.$this->date_field.',"%H")';

    $this->group = 'DATE_FORMAT('.$this->table.'.'.$this->date_field.',"%H")';
  }


  public function general_condition($where = null){
    $this->general_where = $where;
  }

  public function return_date_filtering($field){

  }
  public function select(){
    $this->db->select($this->index_formula.' as total_counted');
    if($this->select_group_name){
      $this->db->select($this->select_group_name.' as the_date');
    }else{
      $this->db->select($this->table.'.'.$this->date_field.' as the_date');
    }
    $this->db->from($this->table);
    if($this->params){
      $this->do_filtering();
    }
    if($this->general_where){
      $this->db->where($this->general_where,false,false);
    }
    $this->db->group_by($this->group);
    return $this;
  }
  public function prepare_filter(){
    $this->db->from($this->table);
    if($this->params){
      $this->do_filtering();
    }
    if($this->general_where){
      $this->db->where($this->general_where,false,false);
    }
    if($this->group){
      $this->db->group_by($this->group);
    }
    return $this;
  }
  public function add_select($select){
    $this->db->select($select);
    return $this;
  }
  public function where($where,$value = false,$escape = false){
    $this->db->where($where,$value,$escape);
    return $this;
  }
  public function where_in($where,$value = false,$escape = false){
    $this->db->where_in($where,$value,$escape);
    return $this;
  }
  public function group_by($group_by){
    $this->db->group_by($group_by);
    return $this;
  }
  public function having($where,$value = false,$escape = false){
    $this->db->having($where,$value,$escape);
    return $this;
  }
  public function join($table,$on,$type = null){
    $this->db->join($table,$on,$type);
    return $this;
  }
  public function join_first($table,$field,$on_table,$on_field,$t2_id,$type = null){
    $this->db->join(''.$on_table.' t2',
    't2.'.$t2_id.' = (SELECT MIN(t2_.'.$t2_id.')
    FROM '.$on_table.' t2_ WHERE (t2_.'.$on_field.' = '.$table.'.'.$field.') LIMIT 1)
    ');
    return $this;
  }

  public function all_monthdays(){
    $query = $this->db->get(); $results = $query->result_array();
    $this->load->library('dashboard');
    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            $return[$v['the_date']] = round((float)$v['total_counted'],2);
          }
    }

    $return = $this->dashboard->fill_days_with_zero($return,$this->from_date,$this->to_date);
    $return = array_values($return);
    return $return;
  }
  public function all_months(){
    $query = $this->db->get(); $results = $query->result_array();
    $this->load->library('dashboard');
    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            $return[$v['the_date']] = round((int)$v['total_counted'],2);
          }
    }

    $return = $this->dashboard->fill_monthnames_with_zero($return,$this->from_date,$this->to_date);
    $return = array_values($return);
    return $return;
  }
  public function all_hours(){
    $query = $this->db->get(); $results = $query->result_array();
    $this->load->library('dashboard');
    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            $return[$v['the_date']] = round((int)$v['total_counted'],2);
          }
    }

    $return = $this->dashboard->fill_hours_with_zero($return);
    $return = array_values($return);
    return $return;
  }
  public function all(){
    $query = $this->db->get(); $return = $query->result_array();
    $this->load->library('dashboard');
    $return = array_values($return);
    return $return;
  }
  public function value($field){
    $query = $this->db->get(); $return = $query->row_array();
    if(isset($return[$field])){
      return $return[$field];
    }
    return null;
  }
  public function number($field){
    return (int)$this->value($field);
  }
  public function row_fields($fields = [],$formatter = null){
    $default = $formatter;
    if($formatter == 'number'){ $default = 0; }
    $query = $this->db->get(); $result = $query->row_array();
    if(!empty($fields)){
      foreach($fields as $field){
        if(!isset($result[$field])){
          $result[$field] = $default;
        }

      }
    }
    return $result;

  }
  private function do_filtering(){
    if(isset($this->params['period_filter'])){
      if($this->params['period_filter'] == 't'){
        $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE()';
        $this->from_date = date('Y-m-d');
        $this->to_date = date('Y-m-d');

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));
          $this->to_date =  date('Y-m-d');
          $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';
        }

      }else if($this->params['period_filter'] == 'y'){
        $this->from_date = date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));
        $this->to_date =  date('Y-m-d');
        $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d',strtotime('-2 days',strtotime(date('Y-m-d'))));
          $this->to_date =  date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));;
          $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE() - INTERVAL 2 DAY';
        }

      }else if($this->params['period_filter'] == 'w'){
        $this->where = ' '.$this->table.'.'.$this->date_field.' <= CURRENT_DATE() ';
        $date = date('Y-m-d');
        $this->from_date = date("Y-m-d", strtotime('monday this week', strtotime($date)));
        $this->to_date = date("Y-m-d", strtotime('sunday this week', strtotime($date)));
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -7 days"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -7 days"));
        }

      }else if($this->params['period_filter'] == 'lw'){
        $date = date('Y-m-d');
        $this->from_date = date("Y-m-d", strtotime('monday last week', strtotime($date)));
        $this->to_date = date("Y-m-d", strtotime('sunday this week', strtotime($date)));
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -7 days"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -7 days"));
        }

      }else if($this->params['period_filter'] == 'm'){
        $this->where = ' '.$this->table.'.'.$this->date_field.' <= CURRENT_DATE() ';
        $date = date('Y-m-d');
        $this->from_date = date('Y-m-d', mktime(0,0,0,date('n'),1,date('Y')));
        $this->to_date = date("Y-m-t", strtotime($date)); //last day of the month of current date
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 months"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 months"));
        }

      }else if($this->params['period_filter'] == 'lm'){
        $date = date('Y-m-d');
        $this->from_date = date('Y-m-d', mktime(0,0,0,date('n')-1,1,date('Y')));
        $this->to_date = date('Y-m-d', strtotime('last day of previous month'));
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 months"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 months"));
        }

      }else if($this->params['period_filter'] == 'yr'){
        $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';

        $year = date('Y');
        $this->where = 'YEAR('.$this->table.'.'.$this->date_field.') = "'.$year.'"';
        $this->from_date = date('Y').'-01-01';
        $this->to_date = date('Y-m-d');//.'-12-31';
        /*$date = date('Y-m-d');

        $this->period = true;*/
        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 years"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 years"));
        }

      }else if($this->params['period_filter'] == 'lyr'){
        $year = date('Y')-1;
        $this->where = 'YEAR('.$this->table.'.'.$this->date_field.') = "'.$year.'"';
        $date = date('Y-m-d');
        $this->from_date = $year.'-01-01';
        $this->to_date = $year.'-12-31';
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 years"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 years"));
        }

      }else if($this->params['period_filter'] == 'p'){
        $this->from_date = $this->params['date_from'];
        $this->to_date = $this->params['date_to'];
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $datediff = strtotime($this->from_date) - strtotime($this->to_date);
          $days = round($datediff / (60 * 60 * 24));
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -".$days." days"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -".$days." days"));
        }

      }else if($this->params['period_filter'] == '30d'){
        $this->from_date = date('Y-m-d',strtotime('-30 days',strtotime(date('Y-m-d'))));
        $this->to_date =  date('Y-m-d');
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -30 days"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -30 days"));
        }

      }

      if($this->period){
        $this->where = ''.$this->table.'.'.$this->date_field.' BETWEEN "'.$this->from_date.'" AND "'.$this->to_date.'"';
      }
    }

    if($this->where){
      $this->db->where($this->where,false,false);
    }
    return $this;
  }
  public function row_array($fields = [],$formatter = null){
    $default = $formatter;
    if($formatter == 'number'){ $default = 0; }
    $query = $this->db->get(); $result = $query->row_array();
    return $result;
  }
  public $limit = null;
  public function result_array($fields = [],$formatter = null){
    if($this->limit){
      $this->db->limit($this->limit);
    }
    $default = $formatter;
    if($formatter == 'number'){ $default = 0; }
    $query = $this->db->get(); $result = $query->result_array();
    return $result;
  }

  public function result_format_indexed_series($fields = [],$fillrules = null,$fill_for_key){
    if($this->limit){
      $this->db->limit($this->limit);
    }
    $query = $this->db->get(); $results = $query->result_array();
    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            foreach($fields as $key=>$field){
              $return[$k][$key] = $v[$field];
            }
          }
    }

    $return2 = [];
    if(!empty($return)){
      foreach($return as $values){
        $daynum = $values[$fill_for_key];
        $daynum = (int)$daynum;
        if($daynum < 10){$daynum = '0'.$daynum; }

        $return2[$daynum] = $values;
      }
    }


    $month = date('m',strtotime($this->from_date));
    $year = date('Y',strtotime($this->from_date));
    $month_1 = $this->dashboard->days_of_month($month, $year);
    $month = date('m',strtotime($this->to_date));
    $year = date('Y',strtotime($this->to_date));
    $month_2 = $this->dashboard->days_of_month($month, $year);
    $alldays = array_unique(array_merge(array_values($month_1), array_values($month_2)));
    foreach($alldays as $k=>$day){
      if(!isset($return2[$day])){
        $return2[$day] = [$day,0];
      }
    }


    sort($return2);

    //$return = $this->dashboard->fill_days_with_zero($return,$this->from_date,$this->to_date);
    //$return = array_values($return);

    return $return2;
  }
}
