<?php
class Dashboard_period_filter_v2 extends CI_Model {

  public $index_formula = 'COUNT(*)';
  public $period = false;
  public $table = '';
  public $date_field = 'date';
  public $period_group = null;
  public $from_date = null;
  public $to_date = null;
  public $where = null;
  public $select_group_name = null;
  public $params = null;
  public $filtering_period = null;
  public $limit = 100;
  public $current_result = null;
  public function __construct(){
    parent::__construct();

  }
  public function reset(){
    $this->index_formula = 'COUNT(*)';
    $this->period = false;
    $this->table = '';
    $this->date_field = 'date';
    $this->period_group = null;
    $this->from_date = null;
    $this->to_date = null;
    $this->where = null;

    $this->params = null;
    $this->select_group_name = null;
    $this->filtering_period = null;
    $this->current_result = null;
  }


  /*Active record*/
  public function select($select){
    $this->db->select($select);
    return $this;
  }
  public function from($table){
    $this->current_result = null;
    $this->table = $table;
    $this->db->from($this->table);
    return $this;
  }
  public function set_params($params){
    $this->params = $params;
    if($this->params){
      $this->_do_filtering(false);
    }
    return $this;
  }
  public function set_period_on($params,$date_field,$prev = false){
    $this->params = $params;
    $this->date_field = $date_field;
    if($prev){
      $this->filtering_period = 'prev';
    }
    if($this->params){
      $this->_do_filtering();
    }
    //if($this->period_group){
      //$this->db->group_by($this->period_group);
    //}

    return $this;
  }
  public function order_by($order_by,$sort = false){
    $this->db->order_by($order_by,$sort);
    return $this;
  }

  public function unset_filtering(){
    $this->params = null;
  }
  public function where($where,$value = false,$escape = false){
    $this->db->where($where,$value,$escape);
    return $this;
  }
  public function where_in($where,$value = false,$escape = false){
    $this->db->where_in($where,$value,$escape);
    return $this;
  }
  public function group_by($group_by){
    $this->db->group_by($group_by);
    return $this;
  }
  public function group_only_by_monthday(){
    $this->select_group_name = 'DAYOFMONTH('.$this->table.'.'.$this->date_field.')';
    $this->group = 'DAYOFMONTH('.$this->table.'.'.$this->date_field.')';
  }
  public function group_only_by_monthname(){
    $this->select_group_name = 'MONTHNAME('.$this->table.'.'.$this->date_field.')';
    $this->select_group_name = 'DATE_FORMAT('.$this->table.'.'.$this->date_field.',"%b")';

    $this->group = 'MONTHNAME('.$this->table.'.'.$this->date_field.')';
  }
  public function group_only_by_hours(){
    $this->select_group_name = 'HOUR('.$this->table.'.'.$this->date_field.')';
    $this->select_group_name = 'DATE_FORMAT('.$this->table.'.'.$this->date_field.',"%H")';

    $this->group = 'DATE_FORMAT('.$this->table.'.'.$this->date_field.',"%H")';
  }
  public function having($where,$value = false,$escape = false){
    $this->db->having($where,$value,$escape);
    return $this;
  }
  public function join($table,$on,$type = null){
    $this->db->join($table,$on,$type);
    return $this;
  }
  public function join_first($table,$field,$on_table,$on_field,$t2_id,$type = null){
    $this->db->join(''.$on_table.' t2',
    't2.'.$t2_id.' = (SELECT MIN(t2_.'.$t2_id.')
    FROM '.$on_table.' t2_ WHERE (t2_.'.$on_field.' = '.$table.'.'.$field.') LIMIT 1)
    ');
    return $this;
  }

  public function limit($limit){
    $this->limit = $limit;
  }
  /*Utilities*/
  public function return_date_filtering_on($field,$prefix = null, $prev = false){
    $where = '';
    if(isset($this->params['period_filter'])){
      if($this->params['period_filter'] == 't'){
        $where = 'DATE('.$field.') = CURRENT_DATE()';
        if($prev){
          $where = 'DATE('.$field.') = CURRENT_DATE() - INTERVAL 1 DAY';
        }
      }else if($this->params['period_filter'] == 'y'){
        $where = 'DATE('.$field.') = CURRENT_DATE() - INTERVAL 1 DAY';
        if($prev){
          $where = 'DATE('.$field.') BETWEEN CURRENT_DATE() - INTERVAL 1 DAY AND CURRENT_DATE() - INTERVAL 2 DAY';
        }
      }else if($this->params['period_filter'] == 'w'){

      }else if($this->params['period_filter'] == 'lw'){

      }else if($this->params['period_filter'] == 'm'){

      }else if($this->params['period_filter'] == 'lm'){

      }else if($this->params['period_filter'] == 'yr'){
        $year = date('Y');

        if($prev){
          $year = $year-1;
        }
        $where = 'YEAR('.$field.') = "'.$year.'"';
      }else if($this->params['period_filter'] == 'lyr'){
      }else if($this->params['period_filter'] == 'p'){

      }else if($this->params['period_filter'] == '30d'){

      }
      if($this->period){
        $where = 'DATE('.$field.') BETWEEN "'.$this->from_date.'" AND "'.$this->to_date.'"';
        if($prev){
          $datediff = strtotime($this->from_date) - strtotime($this->to_date);
          $days = abs(round($datediff / (60 * 60 * 24)));

          $from_date = date('Y-m-d', strtotime($this->from_date . " -".$days." days"));
          $to_date = date('Y-m-d', strtotime($this->to_date . " -".$days." days"));
          $where = 'DATE('.$field.') BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
        }

      }
    }
    if($prefix and $where){
      $where = $prefix.' '.$where;
    }
    return $where;
  }


  /*Active record - data gathers, formatters,getters*/
  public function all_monthdays(){
    $query = $this->db->get(); $results = $query->result_array();
    $this->load->library('dashboard');
    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            $return[$v['the_date']] = round((float)$v['total_counted'],2);
          }
    }

    $return = $this->dashboard->fill_days_with_zero($return,$this->from_date,$this->to_date);
    $return = array_values($return);

    $this->current_result = $return;
    return $return;
  }
  public function all_months(){
    $query = $this->db->get(); $results = $query->result_array();
    $this->load->library('dashboard');
    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            $return[$v['the_date']] = round((int)$v['total_counted'],2);
          }
    }

    $return = $this->dashboard->fill_monthnames_with_zero($return,$this->from_date,$this->to_date);
    $return = array_values($return);
    $this->current_result = $return;
    return $return;
  }
  public function all_hours(){
    $query = $this->db->get(); $results = $query->result_array();
    $this->load->library('dashboard');
    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            $return[$v['the_date']] = round((int)$v['total_counted'],2);
          }
    }

    $return = $this->dashboard->fill_hours_with_zero($return);
    $return = array_values($return);
    $this->current_result = $return;
    return $return;
  }
  public function get_by_weeknumber(){
    $this->db->select('WEEK('.$this->table.'.'.$this->date_field.',3) as week');
    $this->db->select('YEAR('.$this->table.'.'.$this->date_field.') as year');

    $this->db->select('CONCAT(YEAR('.$this->table.'.'.$this->date_field.'),"-",WEEK('.$this->table.'.'.$this->date_field.',3)) as unique_group');
    //$this->db->select('CONCAT(YEAR('.$this->table.'.'.$this->date_field.'),", week #",WEEK('.$this->table.'.'.$this->date_field.',3)) as display_format');

    $this->db->group_by('YEAR('.$this->table.'.'.$this->date_field.')');
    $this->db->group_by('WEEK('.$this->table.'.'.$this->date_field.',3)');
    //,3 indicates that this has weeks starting on Mondays and weeks numbered 1-53.
    $query = $this->db->get(); $results = $query->result_array();
    $this->load->library('dashboard');

    $startDateUnix = strtotime($this->from_date);
    $endDateUnix = strtotime($this->to_date);
    $currentDateUnix = $startDateUnix;
    $weekNumbers = array();



    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            $return[$v['unique_group']] = $v;
            $return[$v['unique_group']]['source'] = 'data';
            $return[$v['unique_group']]['display_format'] = $v['year'].', week #'.$v['week'];

            //$a = strtotime($v['date_converted_to_opp']);
            //$return[$v['unique_group']]['wwwkknumphp'] = date('W', $a);
          }
    }

    while ($currentDateUnix <= $endDateUnix) {
      $unique_group = date('Y', $currentDateUnix).'-'.date('W', $currentDateUnix);
      $weekNumbers[] = date('W', $currentDateUnix);

      if(!isset($return[$unique_group])){
        $return[$unique_group] = [
          'unique_group'=>$unique_group,
          'display_format'=>date('Y', $currentDateUnix).', week #'.date('W', $currentDateUnix),
          'converted_to_opp'=>0,
          'total_leads'=>0,
          'scl'=>0,
          'week'=>date('W', $currentDateUnix),
          'year'=>date('Y', $currentDateUnix),
          'source'=>'logic'
        ];
      }

      $currentDateUnix = strtotime('+1 week', $currentDateUnix);
    }


    //$return = $this->dashboard->fill_hours_with_zero($return);
    ksort($return);
    $return = array_values($return);
    $this->current_result = $return;
    return $return;
  }
  public function get_by_monthday(){
    $this->db->select('DAYOFMONTH('.$this->table.'.'.$this->date_field.') as monthday');
    $this->db->group_by('DAYOFMONTH('.$this->table.'.'.$this->date_field.')');

    $query = $this->db->get(); $results = $query->result_array();
    $this->load->library('dashboard');

    $month = date('m',strtotime($this->from_date));
    $year = date('Y',strtotime($this->from_date));
    $month_1 = $this->dashboard->days_of_month($month, $year);

    $month = date('m',strtotime($this->to_date));
    $year = date('Y',strtotime($this->to_date));
    $month_2 = $this->dashboard->days_of_month($month, $year);
    $alldays = array_unique(array_merge(array_values($month_1), array_values($month_2)));
    foreach($alldays as $k=>$day){
      if(!isset($return[$day])){
        $return[$day] = [
          'dateadded'=>null,
          'monthday'=>$day,
          'won_opp'=>0,
          'source'=>'logic',
          'display_format'=>'Day: '.$day
        ];
      }
    }

    if(!empty($results)){
        foreach($results as $k=>$v){
            //$v['won_opp'] = (int)$v['won_opp'];
            $return[$v['monthday']] = $v;
            $return[$v['monthday']]['source'] = 'data';
            $return[$v['monthday']]['display_format'] = 'Day: '.$v['monthday'];
          }
    }


    ksort($return);
    $return = array_values($return);
    $this->current_result = $return;
    return $return;
  }
  public function all(){
    $query = $this->db->get(); $return = $query->result_array();
    $this->load->library('dashboard');
    $return = array_values($return);
    $this->current_result = $return;
    return $return;
  }
  public function value($field){
    if($this->current_result){
      if(isset($this->current_result[$field])){
        return $this->current_result[$field];
      }else{
        return null;
      }
    }

    $query = $this->db->get(); $return = $query->row_array();
    $this->current_result = $return;
    if(isset($return[$field])){

      return $return[$field];
    }
    return null;
  }
  public function number($field){
    //$this->current_result = (int)$this->value($field);
    return (int)$this->value($field);
  }
  public function row_fields($fields = [],$formatter = null){
    $default = $formatter;
    if($formatter == 'number'){ $default = 0; }
    $query = $this->db->get(); $result = $query->row_array();
    if(!empty($fields)){
      foreach($fields as $field){
        if(!isset($result[$field])){
          $result[$field] = $default;
        }

      }
    }
    $this->current_result = $result;
    return $result;

  }
  public function row_array($fields = [],$formatter = null){
    $default = $formatter;
    if($formatter == 'number'){ $default = 0; }
    $query = $this->db->get(); $result = $query->row_array();
    $this->current_result = $result;
    return $result;
  }
  public function result_array($fields = [],$formatter = null){
    if($this->limit){
      $this->db->limit($this->limit);
    }
    $default = $formatter;
    if($formatter == 'number'){ $default = 0; }
    $query = $this->db->get(); $result = $query->result_array();
    $this->current_result = $result;
    return $result;
  }
  public function compiled(){
    $compiled = $this->db->get_compiled_select();
    return $compiled;
  }

  /*Private methods*/
  private function _do_filtering($return_where = true){

    if(isset($this->params['period_filter'])){
      if($this->params['period_filter'] == 't'){
        $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE()';
        $this->from_date = date('Y-m-d');
        $this->to_date = date('Y-m-d');

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));
          $this->to_date =  date('Y-m-d');
          $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';
        }

      }else if($this->params['period_filter'] == 'y'){
        $this->from_date = date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));
        $this->to_date =  date('Y-m-d');
        $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d',strtotime('-2 days',strtotime(date('Y-m-d'))));
          $this->to_date =  date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));;
          $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE() - INTERVAL 2 DAY';
        }

      }else if($this->params['period_filter'] == 'w'){
        $this->where = ' '.$this->table.'.'.$this->date_field.' <= CURRENT_DATE() ';
        $date = date('Y-m-d');
        $this->from_date = date("Y-m-d", strtotime('monday this week', strtotime($date)));
        $this->to_date = date("Y-m-d", strtotime('sunday this week', strtotime($date)));
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -7 days"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -7 days"));
        }

      }else if($this->params['period_filter'] == 'lw'){
        $date = date('Y-m-d');
        $this->from_date = date("Y-m-d", strtotime('monday last week', strtotime($date)));
        $this->to_date = date("Y-m-d", strtotime('sunday this week', strtotime($date)));
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -7 days"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -7 days"));
        }

      }else if($this->params['period_filter'] == 'm'){
        $this->where = ' '.$this->table.'.'.$this->date_field.' <= CURRENT_DATE() ';
        $date = date('Y-m-d');
        $this->from_date = date('Y-m-d', mktime(0,0,0,date('n'),1,date('Y')));
        $this->to_date = date("Y-m-t", strtotime($date)); //last day of the month of current date
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 months"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 months"));
        }

      }else if($this->params['period_filter'] == 'lm'){
        $date = date('Y-m-d');
        $this->from_date = date('Y-m-d', mktime(0,0,0,date('n')-1,1,date('Y')));
        $this->to_date = date('Y-m-d', strtotime('last day of previous month'));
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 months"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 months"));
        }

      }else if($this->params['period_filter'] == 'yr'){
        $this->where = 'DATE('.$this->table.'.'.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';

        $year = date('Y');
        $this->where = 'YEAR('.$this->table.'.'.$this->date_field.') = "'.$year.'"';
        $this->from_date = date('Y').'-01-01';
        $this->to_date = date('Y-m-d');//.'-12-31';
        /*$date = date('Y-m-d');
        $this->from_date = date('Y-m-d', strtotime('first day of this year'));
        $this->to_date = date('Y-m-d', strtotime('last day of this year'));
        $this->period = true;*/
        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 years"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 years"));
        }

      }else if($this->params['period_filter'] == 'lyr'){
        $year = date('Y')-1;
        $this->where = 'YEAR('.$this->table.'.'.$this->date_field.') = "'.$year.'"';
        $this->from_date = $year.'-01-01';
        $this->to_date = $year.'-12-31';
        $this->period = true;
        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 years"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 years"));
        }

      }else if($this->params['period_filter'] == 'p'){
        $this->from_date = $this->params['date_from'];
        $this->to_date = $this->params['date_to'];
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $datediff = strtotime($this->from_date) - strtotime($this->to_date);
          $days = round($datediff / (60 * 60 * 24));
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -".$days." days"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -".$days." days"));
        }

      }else if($this->params['period_filter'] == '30d'){
        $this->from_date = date('Y-m-d',strtotime('-30 days',strtotime(date('Y-m-d'))));
        $this->to_date =  date('Y-m-d');
        $this->period = true;

        if($this->filtering_period == 'prev'){
          $this->from_date = date('Y-m-d', strtotime($this->from_date . " -30 days"));
          $this->to_date = date('Y-m-d', strtotime($this->to_date . " -30 days"));
        }

      }

      if($this->period and $return_where){
        $this->where = ''.$this->table.'.'.$this->date_field.' BETWEEN "'.$this->from_date.'" AND "'.$this->to_date.'"';
      }
    }

    if($this->where and $return_where){
      $this->db->where($this->where,false,false);
    }
    return $this;
  }

}
