<?php

class Filtering_model extends CI_Model
{

  public $params = [];
  public $config = [];
  public $from_date = null;
  public $to_date = null;
  public $where = null;

  public $from_date_prev = null;
  public $to_date_prev = null;
  public $where_prev = null;

  public $filtering_period = null;
  public $table = '';
  public $date_field = null;
  public $period = false;

  public function set_date_field($field){
    $this->date_field = $field;
  }
  public function filter_api($params = [],$config){
      $this->params = $params;
      $this->config = $config;
      $this->table = $config['table'];

        $this->db->select($config['table'].'.'.$config['id_field']);
        $this->db->from($config['table']);
        $this->do_filtering();
        if($this->where){
          $this->db->where($this->where,false,false);
        }
        $where = '';
        $addAND = false;


        if (array_key_exists("where", $params)) {
            $count_wh_params = count($params['where']);
            $i = 0;
            foreach ($params['where'] as $whereq) {
                if ($addAND) {
                    if ($i != 0) {
                        $where .= ' AND ';
                    }
                }
                $where .= '(' . $whereq . ')';
                $addAND = true;
                $i++;
            }
        }
        if (array_key_exists("heur_search", $params)) {
            if ($params['heur_search'] != '') {
                if ($addAND) {
                    $where .= ' AND ';
                }
                $where .= ' ( ';
                $where .= '(product_name LIKE "%' . $params['heur_search'] . '%")';
                $where .= ' OR (sku LIKE "%' . $params['heur_search'] . '%")';
                $where .= ' OR (product_category.category_name LIKE "%' . $params['heur_search'] . '%")';

                $where .= ' ) ';
                $addAND = true;
            }
        }

        if ($where != '') {
            $this->db->where(''.$where,false,false);
        }

        return $this;
    }

    public function get(){
      if (array_key_exists("returnType", $this->params) && $this->params['returnType'] == 'count') {
          $result = $this->db->count_all_results();
          //$query = $this->db->get();
          //$result = $query->num_rows();
      } else {



          if (array_key_exists("id", $this->params) || (array_key_exists("returnType", $this->params) && $this->params['returnType'] == 'single')) {
              if (!empty($this->params['id'])) {
                  $this->db->where($this->config['table'].'.'.$this->config['id_field'], $this->params['id']);
              }
              $query = $this->db->get();
              $result = $query->row_array();
          } else {
              //$this->db->order_by('postId', 'desc');
              //$this->db->order_by('siteUsers.registerDate','DESC');

              if (array_key_exists("order_by", $this->params)) {
                  foreach($this->params['order_by'] as $order){
                      $this->db->order_by($order[0],$order[1]);
                  }

              }else{
                  $this->db->order_by($this->config['table'].'.'.$this->config['id_field'], 'DESC');
              }


              if (array_key_exists("start", $this->params) && array_key_exists("limit", $this->params)) {
                  $this->db->limit($this->params['limit'], $this->params['start']);
              } elseif (!array_key_exists("start", $this->params) && array_key_exists("limit", $this->params)) {
                  $this->db->limit($this->params['limit']);
              }
              //pre($this->db->get_compiled_select());
              $query = $this->db->get();
              $result = ($query->num_rows() > 0) ? $query->result_array() : FALSE;



          }
      }
      return $result;
    }
    public function select($select){
      $this->db->select($select);
      return $this;
    }
    public function where($where,$value = false,$escape = false){
      $this->db->where($where,$value,$escape);
      return $this;
    }
    public function group_by($group_by){
      $this->db->group_by($group_by);
      return $this;
    }
    public function having($where,$value = false,$escape = false){
      $this->db->having($where,$value,$escape);
      return $this;
    }
    public $joins = [];
    public function join($table,$on,$type = null){
      $this->db->join($table,$on,$type);
      $this->joins[$table] = [$table,$on,$type];
      return $this;
    }
    private function do_filtering(){
      if(isset($this->params['period_filter']) and $this->date_field){
        if($this->params['period_filter'] == 't'){
          $this->where = 'DATE('.$this->date_field.') = CURRENT_DATE()';
          $this->from_date = date('Y-m-d');
          $this->to_date = date('Y-m-d');

          $this->from_date_prev = date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));
          $this->to_date_prev =  date('Y-m-d');
          $this->where_prev = 'DATE('.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';

          if($this->filtering_period == 'prev'){
            $this->from_date = date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));
            $this->to_date =  date('Y-m-d');
            $this->where = 'DATE('.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';
          }

        }else if($this->params['period_filter'] == 'y'){
          $this->from_date = date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));
          $this->to_date =  date('Y-m-d');
          $this->where = 'DATE('.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';

          $this->from_date_prev = date('Y-m-d',strtotime('-2 days',strtotime(date('Y-m-d'))));
          $this->to_date_prev =  date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));;
          $this->where_prev = 'DATE('.$this->date_field.') = CURRENT_DATE() - INTERVAL 2 DAY';

          if($this->filtering_period == 'prev'){
            $this->from_date_prev = date('Y-m-d',strtotime('-2 days',strtotime(date('Y-m-d'))));
            $this->to_date_prev =  date('Y-m-d',strtotime('-1 days',strtotime(date('Y-m-d'))));;
            $this->where_prev = 'DATE('.$this->date_field.') = CURRENT_DATE() - INTERVAL 2 DAY';
          }

        }else if($this->params['period_filter'] == 'w'){
          $this->where = ' '.$this->date_field.' <= CURRENT_DATE() ';
          $date = date('Y-m-d');
          $this->from_date = date("Y-m-d", strtotime('monday this week', strtotime($date)));
          $this->to_date = date("Y-m-d", strtotime('sunday this week', strtotime($date)));
          $this->period = true;

          $this->from_date_prev = date('Y-m-d', strtotime($this->from_date . " -7 days"));
          $this->to_date_prev = date('Y-m-d', strtotime($this->to_date . " -7 days"));

          if($this->filtering_period == 'prev'){
            $this->from_date = date('Y-m-d', strtotime($this->from_date . " -7 days"));
            $this->to_date = date('Y-m-d', strtotime($this->to_date . " -7 days"));
          }

        }else if($this->params['period_filter'] == 'lw'){
          $date = date('Y-m-d');
          $this->from_date = date("Y-m-d", strtotime('monday last week', strtotime($date)));
          $this->to_date = date("Y-m-d", strtotime('sunday this week', strtotime($date)));
          $this->period = true;

          $this->from_date_prev = date('Y-m-d', strtotime($this->from_date . " -7 days"));
          $this->to_date_prev = date('Y-m-d', strtotime($this->to_date . " -7 days"));

          if($this->filtering_period == 'prev'){
            $this->from_date = date('Y-m-d', strtotime($this->from_date . " -7 days"));
            $this->to_date = date('Y-m-d', strtotime($this->to_date . " -7 days"));
          }

        }else if($this->params['period_filter'] == 'm'){
          $this->where = ' '.$this->date_field.' <= CURRENT_DATE() ';
          $date = date('Y-m-d');
          $this->from_date = date('Y-m-d', mktime(0,0,0,date('n'),1,date('Y')));
          $this->to_date = date("Y-m-t", strtotime($date)); //last day of the month of current date
          $this->period = true;

          $this->from_date_prev = date('Y-m-d', strtotime($this->from_date . " -1 months"));
          $this->to_date_prev = date('Y-m-d', strtotime($this->to_date . " -1 months"));

          if($this->filtering_period == 'prev'){
            $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 months"));
            $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 months"));
          }

        }else if($this->params['period_filter'] == 'lm'){
          $date = date('Y-m-d');
          $this->from_date = date('Y-m-d', mktime(0,0,0,date('n')-1,1,date('Y')));
          $this->to_date = date('Y-m-d', strtotime('last day of previous month'));
          $this->period = true;

          $this->from_date_prev = date('Y-m-d', strtotime($this->from_date . " -1 months"));
          $this->to_date_prev = date('Y-m-d', strtotime($this->to_date . " -1 months"));

          if($this->filtering_period == 'prev'){
            $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 months"));
            $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 months"));
          }

        }else if($this->params['period_filter'] == 'yr'){
          $this->where = 'DATE('.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY';
          $year = date('Y');
          $this->where = 'YEAR('.$this->date_field.') = "'.$year.'"';

          $this->from_date = date('Y').'-01-01';
          $this->to_date = date('Y-m-d');//.'-12-31';

          if($this->filtering_period == 'prev'){
            $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 years"));
            $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 years"));
          }

        }else if($this->params['period_filter'] == 'lyr'){
          $year = date('Y')-1;
          $this->where = 'YEAR('.$this->date_field.') = "'.$year.'"';
          $date = date('Y-m-d');
          $this->from_date = $year.'-01-01';
          $this->to_date = $year.'-12-31';
          $this->period = true;

          $this->from_date_prev = date('Y-m-d', strtotime($this->from_date . " -1 years"));
          $this->to_date_prev = date('Y-m-d', strtotime($this->to_date . " -1 years"));

          if($this->filtering_period == 'prev'){
            $this->from_date = date('Y-m-d', strtotime($this->from_date . " -1 years"));
            $this->to_date = date('Y-m-d', strtotime($this->to_date . " -1 years"));
          }

        }else if($this->params['period_filter'] == 'p'){
          $this->from_date = $this->params['date_from'];
          $this->to_date = $this->params['date_to'];
          $this->period = true;

          $datediff = strtotime($this->from_date) - strtotime($this->to_date);
          $days = round($datediff / (60 * 60 * 24));
          $this->from_date_prev = date('Y-m-d', strtotime($this->from_date . " -".$days." days"));
          $this->to_date_prev = date('Y-m-d', strtotime($this->to_date . " -".$days." days"));

          if($this->filtering_period == 'prev'){
            $datediff = strtotime($this->from_date) - strtotime($this->to_date);
            $days = round($datediff / (60 * 60 * 24));
            $this->from_date = date('Y-m-d', strtotime($this->from_date . " -".$days." days"));
            $this->to_date = date('Y-m-d', strtotime($this->to_date . " -".$days." days"));
          }

        }else if($this->params['period_filter'] == '30d'){
          $this->from_date = date('Y-m-d',strtotime('-30 days',strtotime(date('Y-m-d'))));
          $this->to_date =  date('Y-m-d');
          $this->period = true;

          $this->from_date_prev = date('Y-m-d', strtotime($this->from_date . " -30 days"));
          $this->to_date_prev = date('Y-m-d', strtotime($this->to_date . " -30 days"));

          if($this->filtering_period == 'prev'){
            $this->from_date = date('Y-m-d', strtotime($this->from_date . " -30 days"));
            $this->to_date = date('Y-m-d', strtotime($this->to_date . " -30 days"));
          }

        }

        if($this->period){
          $this->where = $this->date_field.' BETWEEN "'.$this->from_date.'" AND "'.$this->to_date.'"';
          $this->where_prev = $this->date_field.' BETWEEN "'.$this->from_date_prev.'" AND "'.$this->to_date_prev.'"';

        }
      }

    }
  public function calc_delta_as($formula,$previus_value_alias = 'previus_value',$delta_alias = 'delta',$subquery_where_conj = null,$tables = []){
    $sub_query = $this->get_delta_subquery($formula,$previus_value_alias,$delta_alias,$subquery_where_conj,$tables);

    //pre($sub_query);
    //$sub_query = str_replace(array_keys($tables), array_values($tables), $sub_query);
    $this->db->select('('.$sub_query.') as '.$previus_value_alias);
    return $this;
  }
  private function get_delta_subquery($formula,$previus_value_alias = 'previus_value',$delta_alias = 'delta',$subquery_where_conj = null,$tables = []){
    $db2 = $this->load->database('default', TRUE);
    $db2->dbprefix = '';
    //$formula = str_replace(array_keys($tables), $tables, $formula);
    if($this->where_prev){
      $wh = $this->where_prev;
      $wh = str_replace(array_keys($tables), array_values($tables), $wh);
      //$db2->select('IFNULL((SELECT '.$formula.'),0) as '.$previus_value_alias.' ');
      $db2->select('IFNULL(('.$formula.'),0)');

      $db2->where($wh,false,false);
    }else{
      $db2->select(' "" as '.$previus_value_alias.' ');
    }

    if($subquery_where_conj){
      $db2->where($subquery_where_conj,false,false);
    }

    $table = $this->table;
    $table = str_replace(array_keys($tables), array_values($tables), $table);
    $db2->from($this->table.' as '.$table);
    if(!empty($this->joins)){
      foreach($this->joins as $join){
        $join[0] = $join[0].' as '.$tables[$join[0]]; //str_replace(array_keys($tables), $tables, $join[0]);
        $join[1] = str_replace(array_keys($tables), array_values($tables), $join[1]);
        $db2->join($join[0],$join[1],$join[2]);
      }
    }
    $sub_query = $db2->get_compiled_select();
    return $sub_query;
  }

}
