<?php

class Helpdesk_model extends CI_Model
{

  public function num_tickets_by_hour($params){
    $this->period = false;
    $this->table = 'tbltickets';
    $this->date_field = 'date';

    if(isset($params['period_filter'])){
      if($params['period_filter'] == 't'){
        $this->today();
      }else if($params['period_filter'] == 'y'){
        $this->current_year();
      }else if($params['period_filter'] == 'w'){
        $this->w();
      }else if($params['period_filter'] == 'lw'){
        $this->lw();
      }else if($params['period_filter'] == 'm'){
        $this->m();
      }else if($params['period_filter'] == 'lm'){
        $this->lm();
      }else if($params['period_filter'] == 'yr'){
        $this->yr();
      }else if($params['period_filter'] == 'lyr'){
        $this->lyr();
      }else if($params['period_filter'] == 'p'){
        $this->p();
      }else if($params['period_filter'] == '30d'){
        $this->last_30d();
      }

    }

    if($this->period){
      $this->sql = '

      SELECT
            COUNT(l.ticketid) as total_counted,
             DAYOFMONTH('.$this->period_selector.') AS the_date
      FROM (
              SELECT DATE_ADD(curdate(), INTERVAL 2 MONTH) - INTERVAL (a.a + (10 * b.a) ) DAY as Date
              FROM (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a
              CROSS JOIN (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b
            ) all_dates
            LEFT OUTER JOIN '.$this->table.' l
                        ON  DATE(all_dates.Date) = DATE(l.date)

      WHERE all_dates.Date BETWEEN "'.$this->from_date.'" AND "'.$this->to_date.'" AND ('.$this->where.')
      AND (status != 0 AND status IS NOT NULL)
      GROUP BY
            '.$this->group.'
      ORDER BY
            l.date ASC

      ';
    }

    $query = $this->db->query($this->sql); $results = $query->result_array();
    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            $return[$v['the_date']] = (int)$v['total_counted'];
          }
    }

    $return = $this->dashboard->fill_days_with_zero($return,$this->from_date,$this->to_date);

    return $return;
  }
  public function daily_alltime_tickets(){
    $this->group = 'all_dates.Date';
    $this->period_selector = 'all_dates.Date';
    $this->table = 'tbltickets';
    $this->date_field = 'date';
    $this->from_date = date('Y-m-d',strtotime('-30 days',strtotime(date('Y-m-d'))));
    $this->to_date =  date('Y-m-d');

    $this->sql = '

    SELECT
          COUNT(l.ticketid) as total_counted,
           DAYOFMONTH('.$this->period_selector.') AS the_date
    FROM (
            SELECT DATE_ADD(curdate(), INTERVAL 2 MONTH) - INTERVAL (a.a + (10 * b.a) ) DAY as Date
            FROM (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a
            CROSS JOIN (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b
          ) all_dates
          LEFT OUTER JOIN '.$this->table.' l
                      ON  DATE(all_dates.Date) = DATE(l.date)

    WHERE
    (status != 0 AND status IS NOT NULL)
    GROUP BY
          '.$this->group.'
    ORDER BY
          l.date ASC

    ';

    $query = $this->db->query($this->sql); $results = $query->result_array();
    $return = [];
    if(!empty($results)){
        foreach($results as $k=>$v){
            $return[$v['the_date']] = (int)$v['total_counted'];
          }
    }

    $return = $this->dashboard->fill_days_with_zero($return,$this->from_date,$this->to_date);

    return $return;


  }



  public function today(){
    $this->sql = '
    SELECT
      COUNT(l.id) as total_counted,
      sum(l.total) as sum_total,
    CONCAT(HOUR(l.'.$this->date_field.'), "h.") AS the_date

    FROM  '.$this->table.' l
    WHERE DATE(l.'.$this->date_field.') = CURRENT_DATE()
    AND (status != 0 AND status IS NOT NULL)

    GROUP BY HOUR(l.'.$this->date_field.')
    ORDER BY
          HOUR(l.'.$this->date_field.') ASC
    ';

    $this->sql = '
    SELECT
      1 as total_counted,
      l.total as sum_total,
    CONCAT(HOUR(l.'.$this->date_field.'), "h.") AS the_date

    FROM  '.$this->table.' l
    WHERE DATE(l.'.$this->date_field.') = CURRENT_DATE()
    AND (status != 0 AND status IS NOT NULL)

    ORDER BY
          HOUR(l.'.$this->date_field.') ASC
    ';

  }
  public function current_year(){
    $this->sql = '
    SELECT
          COUNT(l.id) as total_counted,
          sum(l.total) as sum_total
          , CONCAT(HOUR(l.'.$this->date_field.'), "h.") AS the_date
    FROM   '.$this->table.' l
    WHERE DATE(l.'.$this->date_field.') = CURRENT_DATE() - INTERVAL 1 DAY
    AND (status != 0 AND status IS NOT NULL)

    GROUP BY HOUR(l.'.$this->date_field.')
    ORDER BY
          HOUR(l.'.$this->date_field.') ASC
    ';
  }
  public function w(){
    $day = date('w');
    $week_start = date('m-d-Y', strtotime('-'.$day.' days'));
    $week_end = date('m-d-Y', strtotime('+'.(6-$day).' days'));

    if($day == 1){
      $this->group = 'HOUR(the_date)';
      $this->period_selector = 'CONCAT(HOUR(l.'.$this->date_field.'), "h.")';
    }else{
      $this->group = 'the_date';
      $this->period_selector = 'DAYNAME(all_dates.Date)';
    }

    /*
    $day contains a number from 0 to 6 representing the day of the week (Sunday = 0, Monday = 1, etc.).
    $week_start contains the date for Sunday of the current week as mm-dd-yyyy.
    $week_end contains the date for the Saturday of the current week as mm-dd-yyyy.
    */

    $date = date('Y-m-d');
    $this->from_date = date("Y-m-d", strtotime('monday this week', strtotime($date)));
    $this->to_date = date("Y-m-d", strtotime('sunday this week', strtotime($date)));
    $this->period = true;

    $this->where = ' all_dates.Date <= CURRENT_DATE() ';
  }
  public function lw(){
    $date = date('Y-m-d');
    $this->from_date = date("Y-m-d", strtotime('monday last week', strtotime($date)));
    $this->to_date = date("Y-m-d", strtotime('sunday this week', strtotime($date)));
    $this->period = true;
    $this->group = 'all_dates.Date';
    $this->where  = ' 1 = 1 ';
    $this->period_selector = 'DAYNAME(all_dates.Date)';
  }
  public function m(){
    $date = date('Y-m-d');
    $this->from_date = date('Y-m-d', mktime(0,0,0,date('n'),1,date('Y')));
    $this->to_date = date("Y-m-t", strtotime($date)); //last day of the month of current date
    $this->period = true;
    $this->group = 'all_dates.Date';
    $this->where = ' all_dates.Date <= CURRENT_DATE() ';
    $this->period_selector = 'all_dates.Date';
  }
  public function lm(){
    $date = date('Y-m-d');
    $this->from_date = date('Y-m-d', mktime(0,0,0,date('n')-1,1,date('Y')));
    $this->to_date = date('Y-m-d', strtotime('last day of previous month'));
    $this->period = true;
    $this->group = 'all_dates.Date';
    $this->where  = ' 1 = 1 ';
    $this->period_selector = 'all_dates.Date';
  }
  public function last_30d(){
    $this->from_date = date('Y-m-d',strtotime('-30 days',strtotime(date('Y-m-d'))));
    $this->to_date =  date('Y-m-d');
    $this->period = true;
    $this->group = 'all_dates.Date';
    $this->where  = ' 1 = 1  ';
    $this->period_selector = 'all_dates.Date';
  }
  public function p(){
    $this->from_date = $params['date_from'];
    $this->to_date = $params['date_to'];
    $this->period = true;
    $this->group = 'all_dates.Date';
    $this->where  = ' 1 = 1  ';
    $this->period_selector = 'all_dates.Date';
  }
  public function lyr(){
    $date = date('Y-m-d');
    $this->from_date = $year.'-01-01';
    $this->to_date = $year.'-12-31';
    $this->group = ' MONTHNAME(l.'.$this->date_field.')';
    $this->period = false;
    $this->where  = ' 1 = 1 ';

    //WHERE all_dates.Date BETWEEN "'.$this->from_date.'" AND "'.$this->to_date.'" AND ('.$this->where.')
    $this->period_selector = 'CONCAT(MONTHNAME(l.'.$this->date_field.'), "")';
    $year = date('Y')-1; //, strtotime('last day of previous year'));
    $this->sql = '
    SELECT
          COUNT(l.id) as total_counted,
          sum(l.total) as sum_total
          , '.$this->period_selector.' AS the_date
    FROM   '.$this->table.' l
    WHERE YEAR(l.'.$this->date_field.') = "'.$year.'"
    AND (status != 0 AND status IS NOT NULL)
    GROUP BY '.$this->group.'
    ORDER BY
           month(l.'.$this->date_field.')
    ';

    $this->period_selector = 'CONCAT(MONTHNAME(l.'.$this->date_field.'), "")';
    $this->group = ' MONTHNAME(l.'.$this->date_field.')';
    $this->sql = '

    SELECT
          COUNT(l.id) as total_counted,
          '.$this->period_selector.' AS the_date,
          sum(l.total) as sum_total
    FROM (
            SELECT DATE_ADD(curdate(), INTERVAL 2 MONTH) - INTERVAL (a.a + (10 * b.a) ) DAY as Date
            FROM (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a
            CROSS JOIN (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b
          ) all_dates
          LEFT OUTER JOIN  '.$this->table.' l
                      ON  DATE(all_dates.Date) = DATE(l.'.$this->date_field.')

    WHERE YEAR(l.'.$this->date_field.') = "'.$year.'"
    AND (status != 0 AND status IS NOT NULL)
    GROUP BY
          '.$this->group.'
    ORDER BY
           month(all_dates.Date) ASC

    ';



    $this->period_selector = 'CONCAT(MONTHNAME(l.'.$this->date_field.'), " '.$year.'")';
    $this->group = ' MONTHNAME(l.'.$this->date_field.')';
    $this->sql = '

    SELECT
          COUNT(l.id) as total_counted
        , '.$this->period_selector.' AS the_date
        , id
    FROM  '.$this->table.' l
    LEFT JOIN (
    SELECT 1 AS `month`
    UNION
    SELECT 2 AS `month`
    UNION
    SELECT 3 AS `month`
    UNION
    SELECT 4 AS `month`
    UNION
    SELECT 5 AS `month`
    UNION
    SELECT 6 AS `month`
    UNION
    SELECT 7 AS `month`
    UNION
    SELECT 8 AS `month`
    UNION
    SELECT 9 AS `month`
    UNION
    SELECT 10 AS `month`
    UNION
    SELECT 11 AS `month`
    UNION
    SELECT 12 AS `month`
    ) AS t on t.month = MONTH(l.'.$this->date_field.')


    WHERE YEAR(l.'.$this->date_field.') = "'.$year.'"
    AND (status != 0 AND status IS NOT NULL)
    GROUP BY
          '.$this->group.'
    ORDER BY
           month(l.'.$this->date_field.') ASC

    ';
  }
  public function yr(){
    $month  = date('m');

    $date = date('Y-m-d');
    $this->from_date = date('Y-m-d', strtotime('first day of this year'));
    $this->to_date = date('Y-m-d', strtotime('last day of this year'));

    if((int)$month == 1){
      $this->period = false;

      $this->group = 'all_dates.Date';
      $this->where = ' all_dates.Date <= CURRENT_DATE() ';
      $this->period_selector = 'all_dates.Date';
    }else{

      $this->group = ' MONTHNAME(all_dates.Date)';
      $this->period = false;
      $this->where = ' all_dates.Date <= CURRENT_DATE() ';
      $this->period_selector = 'MONTHNAME(all_dates.Date)';
    }



    $this->sql = '

    SELECT
          COUNT(l.id) as total_counted
        , '.$this->period_selector.' AS the_date,
        sum(l.total) as sum_total
        , id
    FROM (
            SELECT DATE_ADD(curdate(), INTERVAL 2 MONTH) - INTERVAL (a.a + (10 * b.a) ) DAY as Date
            FROM (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a
            CROSS JOIN (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b
          ) all_dates
          LEFT OUTER JOIN  '.$this->table.' l
                      ON  DATE(all_dates.Date) = DATE(l.'.$this->date_field.')

    WHERE all_dates.Date BETWEEN "'.$this->from_date.'" AND "'.$this->to_date.'" AND ('.$this->where.')
    AND (status != 0 AND status IS NOT NULL)
    GROUP BY
          '.$this->group.'
    ORDER BY
           MONTHNAME(all_dates.Date) ASC

    ';



    $year = date('Y');

    $this->period_selector = 'CONCAT(MONTHNAME(l.'.$this->date_field.'), " '.$year.'")';
    $this->group = ' MONTHNAME(l.'.$this->date_field.')';
    $this->sql = '

    SELECT
          COUNT(l.id) as total_counted,
          sum(l.total) as sum_total
        , '.$this->period_selector.' AS the_date
        , id
    FROM  '.$this->table.' l
    LEFT JOIN (
    SELECT 1 AS `month`
    UNION
    SELECT 2 AS `month`
    UNION
    SELECT 3 AS `month`
    UNION
    SELECT 4 AS `month`
    UNION
    SELECT 5 AS `month`
    UNION
    SELECT 6 AS `month`
    UNION
    SELECT 7 AS `month`
    UNION
    SELECT 8 AS `month`
    UNION
    SELECT 9 AS `month`
    UNION
    SELECT 10 AS `month`
    UNION
    SELECT 11 AS `month`
    UNION
    SELECT 12 AS `month`
    ) AS t on t.month = MONTH(l.'.$this->date_field.')


    WHERE YEAR(l.'.$this->date_field.') = "'.$year.'"
    AND (status != 0 AND status IS NOT NULL)

    GROUP BY
          '.$this->group.'
    ORDER BY
           month(l.'.$this->date_field.') ASC

    ';
  }

}
