<?php

class Okr_dashboard_model extends CI_Model
{
    public function get_progress_dashboard($type)
    {
        switch ($type) {
            case 1:
                $progress = '50.00';
                $query = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs 
            WHERE (recently_checkin <= CAST(DATE(NOW()) AS DATE)
            AND recently_checkin >= CAST((DATE(NOW()) - INTERVAL 7 DAY) AS DATE)) AND `progress` > ' . $progress . '';
                break;
            case 2:
                $progress = '50.00';
                $query = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs 
            WHERE (recently_checkin <= CAST(DATE(NOW()) AS DATE)
            AND recently_checkin >= CAST((DATE(NOW()) - INTERVAL 7 DAY) AS DATE)) AND `progress` < ' . $progress . '';
                break;
            default:
                $progress = '50.00';
                $query = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs 
            WHERE (recently_checkin <= CAST(DATE(NOW()) AS DATE)
            AND recently_checkin >= CAST((DATE(NOW()) - INTERVAL 7 DAY) AS DATE)) AND `progress` >= ' . $progress . ' and `progress` <= "70.00"';
                break;
        }
        return $this->db->query($query)->row();
    }

    public function get_okrs($id = '')
    {
        if ($id != '') {
            $this->db->where('id', $id);
            return $this->db->get(db_prefix() . 'okrs')->row();
        }
        return $this->db->get(db_prefix() . 'okrs')->result_array();
    }

    public function checkin_status_dashboard()
    {
        $query1 = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs_checkin_log where confidence_level = 1';
        $query2 = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs_checkin_log where confidence_level = 2';
        $query3 = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs_checkin_log where confidence_level = 3';

        $is_fine = $this->db->query($query1)->row()->count;
        $not_so_good = $this->db->query($query2)->row()->count;
        $very_good = $this->db->query($query3)->row()->count;

        $total = $is_fine + $not_so_good + $very_good;

        if ($total == 0) {
            $percent_1 = 0;
            $percent_2 = 0;
            $percent_3 = 0;
        } else {
            $percent_1 = ($is_fine / ($total)) * 100;
            $percent_2 = ($not_so_good / ($total)) * 100;
            $percent_3 = ($very_good / ($total)) * 100;
        }
        return $final = [['name' => _l('is_fine'), 'y' => $percent_1], ['name' => _l('not_so_good'), 'y' => $percent_2], ['name' => _l('very_good'), 'y' => $percent_3]];
    }

    public function get_category($id = '')
    {
        if ($id != '') {
            $this->db->where('id', $id);
            return $this->db->get(db_prefix() . 'okr_setting_category')->row();
        }
        return $this->db->get(db_prefix() . 'okr_setting_category')->result_array();
    }

    public function get_circulation($id = '')
    {
        if ($id != '') {
            $this->db->where('id', $id);
            return $this->db->get(db_prefix() . 'okr_setting_circulation')->row();
        }
        return $this->db->get(db_prefix() . 'okr_setting_circulation')->result_array();
    }

    public function okrs_company_dasdboard()
    {
        $query_oks = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs';
        $query_progress = 'SELECT (sum(progress)/((select count(*) from ' . db_prefix() . 'okrs)*100)*100) as progress  FROM ' . db_prefix() . 'okrs';
        $query_keyres = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs_key_result';

        $query1 = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs where confidence_level = 1';
        $query2 = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs where confidence_level = 2';
        $query3 = 'SELECT count(*) as count FROM ' . db_prefix() . 'okrs where confidence_level = 3';

        $is_fine = $this->db->query($query1)->row()->count;
        $not_so_good = $this->db->query($query2)->row()->count;
        $very_good = $this->db->query($query3)->row()->count;
        $okrs_count = $this->db->query($query_oks)->row()->count;
        $okrs_keyres = $this->db->query($query_keyres)->row()->count;
        $okrs_progress = $this->db->query($query_progress)->row()->progress;
        $total = $is_fine + $not_so_good + $very_good;
        $total = $total <= 0 ? $total = 1 : $total;
        $percent_1 = ($is_fine / ($total)) * 100;
        $percent_2 = ($not_so_good / ($total)) * 100;
        $percent_3 = ($very_good / ($total)) * 100;

        if ($total == 0) {
            $total = 3;
            $percent_1 = ($is_fine / ($total)) * 100;
            $percent_2 = ($not_so_good / ($total)) * 100;
            $percent_3 = ($very_good / ($total)) * 100;
        }
        return ['okrs_count' => $okrs_count, 'okrs_progress' => $okrs_progress, 'okrs_keyres' => $okrs_keyres, 'html' => [$percent_1, $percent_2, $percent_3]];
    }

    public function okrs_user_dasdboard()
    {
        $staff_current = get_staff_user_id();
        $query_oks = 'SELECT count(*) as count FROM '.db_prefix().'okrs where person_assigned = '.$staff_current;
        $query_progress = 'SELECT (sum(progress)/((select count(*) from '.db_prefix().'okrs where person_assigned = '.$staff_current.')*100)*100) as progress  FROM '.db_prefix().'okrs';
        $query_keyres = 'SELECT count(*) as count FROM '.db_prefix().'okrs_key_result a left join '.db_prefix().'okrs b ON b.id = a.okrs_id
        where b.person_assigned = 2';

        $query1 = 'SELECT count(*) as count FROM '.db_prefix().'okrs where confidence_level = 1 and person_assigned = '.$staff_current;
        $query2 = 'SELECT count(*) as count FROM '.db_prefix().'okrs where confidence_level = 2 and person_assigned = '.$staff_current;
        $query3 = 'SELECT count(*) as count FROM '.db_prefix().'okrs where confidence_level = 3 and person_assigned = '.$staff_current;

        $is_fine = $this->db->query($query1)->row()->count;
        $not_so_good = $this->db->query($query2)->row()->count;
        $very_good = $this->db->query($query3)->row()->count;
        $okrs_count = $this->db->query($query_oks)->row()->count;
        $okrs_keyres = $this->db->query($query_keyres)->row()->count;
        $okrs_progress = $this->db->query($query_progress)->row()->progress;
        $total = $is_fine + $not_so_good + $very_good;
        if ($total == 0) {
            $percent_1 = 0;
            $percent_2 = 0;
            $percent_3 = 0;
        } else {
            $percent_1 = ($is_fine/($total))*100;
            $percent_2 = ($not_so_good/($total))*100;
            $percent_3 = ($very_good/($total))*100;
        }

        return ['okrs_count' => $okrs_count, 'okrs_progress' => $okrs_progress, 'okrs_keyres' => $okrs_keyres, 'html' => [$percent_1, $percent_2, $percent_3]];
    }

}
