<?php

class Sales_opportunity_model extends CI_Model
{
    public function current_opportunities()
    {
        $data = $this->db
            ->select('*')
            ->from('tblleads')
//            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
//            ->group_start() //this will start grouping
//            ->where('status_opportunity !=', 10)
//            ->or_where('status_opportunity', null)
//            ->group_end()
            ->get(); // end of sql grouping
        $date = $data->result_array();

//        $this->db
//            ->select_sum('*')
//            ->from('tblleads');
//        if (date('m') - 1 == 0) {
//            $this->db->where('month(dateadded)', 12);
//            $this->db->where('year(dateadded)', date('y') - 1);
//        } else {
//            $this->db->where('month(dateadded)', date('m') - 1);
//        }
//        $this->db->where('is_opportunity', 1)
//            ->group_start() //this will start grouping
//            ->where('status_opportunity !=', 10)
//            ->or_where('status_opportunity', null)
//            ->group_end(); // end of sql grouping
//        $data = $this->db->count_all_results();
//        $date['previous_month'] = $data;
        return $date;
    }

    public function current_purchase_value()
    {
        $data = $this->db
            ->select_sum('opportunity_ot_value')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->group_start() //this will start grouping
            ->where('status_opportunity !=', 9)
            ->or_where('status_opportunity', null)
            ->group_end() // end of sql grouping
            ->get();
        $result['one_fee']['this_month'] = $data->result_array();

        $this->db
            ->select_sum('opportunity_ot_value')
            ->from('tblleads');
        if (date('m') - 1 == 0) {
            $this->db->where('month(dateadded)', 12);
            $this->db->where('year(dateadded)', date('y') - 1);
        } else {
            $this->db->where('month(dateadded)', date('m') - 1);
        }
        $this->db->where('is_opportunity', 1)
            ->group_start() //this will start grouping
            ->where('status_opportunity !=', 9)
            ->or_where('status_opportunity', null)
            ->group_end(); // end of sql grouping
        $data = $this->db->get();
        $result['one_fee']['previous_month'] = $data->result_array();

        $data = $this->db
            ->select_sum('opportunity_mo_value')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->group_start() //this will start grouping
            ->where('status_opportunity !=', 9)
            ->or_where('status_opportunity', null)
            ->group_end() // end of sql grouping
            ->get();
        $result['mounthly_fee']['this_month'] = $data->result_array();

        $this->db
            ->select_sum('opportunity_mo_value')
            ->from('tblleads');
        if (date('m') - 1 == 0) {
            $this->db->where('month(dateadded)', 12);
            $this->db->where('year(dateadded)', date('y') - 1);
        } else {
            $this->db->where('month(dateadded)', date('m') - 1);
        }
        $this->db->where('is_opportunity', 1)
            ->group_start() //this will start grouping
            ->where('status_opportunity !=', 9)
            ->or_where('status_opportunity', null)
            ->group_end(); // end of sql grouping
        $data = $this->db->get();
        $result['mounthly_fee']['previous_month'] = $data->result_array();

        return $result;
    }

    public function average_purchase_rate()
    {
        $data = $this->db
            ->select_avg('opportunity_ot_value')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->group_start() //this will start grouping
            ->where('status_opportunity !=', 9)
            ->or_where('status_opportunity', null)
            ->group_end() // end of sql grouping
            ->get();
        $result['one_fee'] = $data->result_array();

        $this->db
            ->select_avg('opportunity_mo_value')
            ->from('tblleads');
        if (date('m') - 1 == 0) {
            $this->db->where('month(dateadded)', 12);
            $this->db->where('year(dateadded)', date('y') - 1);
        } else {
            $this->db->where('month(dateadded)', date('m') - 1);
        }
        $this->db->where('is_opportunity', 1)
            ->group_start() //this will start grouping
            ->where('status_opportunity !=', 9)
            ->or_where('status_opportunity', null)
            ->group_end(); // end of sql grouping
        $data = $this->db->get();
        $result['mounthly_fee'] = $data->result_array();
        return $result;
    }

    public function win_rate()
    {
        $data = $this->db
            ->select('*')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->where('status_opportunity =', 9)
            ->count_all_results();
        $result['this_month']['win'] = $data;

        $data = $this->db
            ->select('*')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->count_all_results();
        $result['this_month']['total'] = $data;

        $this->db
            ->select('*')
            ->from('tblleads');
        if (date('m') - 1 == 0) {
            $this->db->where('month(dateadded)', 12);
            $this->db->where('year(dateadded)', date('y') - 1);
        } else {
            $this->db->where('month(dateadded)', date('m') - 1);
        }
        $this->db->where('is_opportunity', 1)
            ->where('status_opportunity =', 9);
        $data = $this->db->count_all_results();
        $result['last_month']['win'] = $data;

        $this->db
            ->select('*')
            ->from('tblleads');
        if (date('m') - 1 == 0) {
            $this->db->where('month(dateadded)', 12);
            $this->db->where('year(dateadded)', date('y') - 1);
        } else {
            $this->db->where('month(dateadded)', date('m') - 1);
        }
        $this->db->where('is_opportunity', 1);
        $data = $this->db->count_all_results();
        $result['last_month']['total'] = $data;

        return $result;
    }

    public function lost_opportunities()
    {
        $data = $this->db
            ->select('*')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->where('status_opportunity =', 9)
            ->count_all_results();
        $result['this_month'] = $data;

        $this->db
            ->select('*')
            ->from('tblleads');
        if (date('m') - 1 == 0) {
            $this->db->where('month(dateadded)', 12);
            $this->db->where('year(dateadded)', date('y') - 1);
        } else {
            $this->db->where('month(dateadded)', date('m') - 1);
        }
        $this->db->where('is_opportunity', 1)
            ->where('status_opportunity =', 9);
        $data = $this->db->count_all_results();
        $result['last_month'] = $data;
        return $result;
    }

    public function lost_opportunities_otf()
    {
        $data = $this->db
            ->select_sum('opportunity_ot_value')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->where('status_opportunity =', 9)
            ->get();
        $result['this_month'] = $data->result_array();

        $this->db
            ->select_sum('opportunity_ot_value')
            ->from('tblleads');
        if (date('m') - 1 == 0) {
            $this->db->where('month(dateadded)', 12);
            $this->db->where('year(dateadded)', date('y') - 1);
        } else {
            $this->db->where('month(dateadded)', date('m') - 1);
        }
        $this->db->where('is_opportunity', 1)
            ->where('status_opportunity =', 9);
        $data = $this->db->get();

        $result['last_month'] = $data->result_array();
        return $result;
    }

    public function lost_opportunities_mrr()
    {
        $data = $this->db
            ->select_sum('opportunity_mo_value')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->where('status_opportunity =', 9)
            ->get();
        $result['this_month'] = $data->result_array();

        $this->db
            ->select_sum('opportunity_mo_value')
            ->from('tblleads');
        if (date('m') - 1 == 0) {
            $this->db->where('month(dateadded)', 12);
            $this->db->where('year(dateadded)', date('y') - 1);
        } else {
            $this->db->where('month(dateadded)', date('m') - 1);
        }
        $this->db->where('is_opportunity', 1)
            ->where('status_opportunity =', 9);
        $data = $this->db->get();
        $result['last_month'] = $data->result_array();
        return $result;
    }


    public function details($params, $period)
    {
        $this->db
            ->select('*')
            ->from('tblleads')
            ->order_by('dateadded', 'ASC')
            ->where('is_opportunity', 1);
        // status selection
        if ($params != null) {
            $this->db->where('status_opportunity', $params);
        }
        // period selection
        if ($period == '30d') {
            $this->db->where('dateadded BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE()');
        }
        if ($period == 't') {
            $this->db->where('DATE(dateadded) = DATE(NOW())');
        }
        if ($period == 'y') {
            $this->db->where('DATE(dateadded) BETWEEN DATE(NOW() - INTERVAL 1 DAY) AND CURRENT_DATE()');
        }
        if ($period == 'w') {
            $this->db->where('YEARWEEK(dateadded) = YEARWEEK(NOW())');
        }
        if ($period == 'lw') {
            $this->db->where('DATE(dateadded) >= curdate() - INTERVAL DAYOFWEEK(curdate())+6 DAY AND DATE(dateadded) < curdate() - INTERVAL DAYOFWEEK(curdate())-1 DAY ');
        }
        if ($period == 'm') {
            $this->db->where('MONTH(dateadded) = MONTH(CURRENT_DATE()) AND YEAR(dateadded) = YEAR(CURRENT_DATE())  ');
        }
        if ($period == 'lm') {
            $this->db->where('MONTH(dateadded) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH) AND YEAR(dateadded) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH) ');
        }
        if ($period == 'yr') {
            $this->db->where('YEAR(dateadded) = YEAR(CURRENT_DATE()) ');
        }
        if ($period == 'lyr') {
            $this->db->where('YEAR(dateadded) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) ');
        }
        $data = $this->db->get();
        return $data->result_array();
    }

    public function OOP_stages()
    {
        $data = $this->db
            ->select('*')
            ->from('opportunities_status')
            ->get();
        return $data->result_array();
    }

    public function lost_statuses()
    {
        $data = $this->db
            ->select('name')
            ->from('tbllead_lost_reasons')
            ->get();
        return $data->result_array();
    }

    public function Sales_persons()
    {
        $data = $this->db
            ->select('name')
            ->from('tblleads')
            ->where('is_opportunity', 1)
            ->group_by('name')
            ->get();
        return $data->result_array();
    }

    public function lost_reasons_data($period, $name)
    {
        $this->db
            ->select_sum('opportunity_ot_value')
            ->select_sum('opportunity_mo_value')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->where('status_opportunity =', 9)
            ->group_by('id_lost_reason');
        if ($name != null) {
            $this->db->where('name', $name);
        }
        if ($period == '30d') {
            $this->db->where('dateadded BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE()');
        }
        if ($period == 't') {
            $this->db->where('DATE(dateadded) = DATE(NOW())');
        }
        if ($period == 'y') {
            $this->db->where('DATE(dateadded) BETWEEN DATE(NOW() - INTERVAL 1 DAY) AND CURRENT_DATE()');
        }
        if ($period == 'w') {
            $this->db->where('YEARWEEK(dateadded) = YEARWEEK(NOW())');
        }
        if ($period == 'lw') {
            $this->db->where('DATE(dateadded) >= curdate() - INTERVAL DAYOFWEEK(curdate())+6 DAY AND DATE(dateadded) < curdate() - INTERVAL DAYOFWEEK(curdate())-1 DAY ');
        }
        if ($period == 'm') {
            $this->db->where('MONTH(dateadded) = MONTH(CURRENT_DATE()) AND YEAR(dateadded) = YEAR(CURRENT_DATE())  ');
        }
        if ($period == 'lm') {
            $this->db->where('MONTH(dateadded) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH) AND YEAR(dateadded) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH) ');
        }
        if ($period == 'yr') {
            $this->db->where('YEAR(dateadded) = YEAR(CURRENT_DATE()) ');
        }
        if ($period == 'lyr') {
            $this->db->where('YEAR(dateadded) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) ');
        }
        $data = $this->db->get();
        $result['this_month'] = $data->result_array();

        $this->db
            ->select('id_lost_reason, count(id_lost_reason) AS num_of_opp')
            ->from('tblleads')
            ->where('month(dateadded)', date('m'))
            ->where('is_opportunity', 1)
            ->where('status_opportunity =', 9)
            ->group_by('id_lost_reason');
        // period selection
        if ($name != null) {
            $this->db->where('name', $name);
        }
        if ($period == '30d') {
            $this->db->where('dateadded BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE()');
        }
        if ($period == 't') {
            $this->db->where('DATE(dateadded) = DATE(NOW())');
        }
        if ($period == 'y') {
            $this->db->where('DATE(dateadded) BETWEEN DATE(NOW() - INTERVAL 1 DAY) AND CURRENT_DATE()');
        }
        if ($period == 'w') {
            $this->db->where('YEARWEEK(dateadded) = YEARWEEK(NOW())');
        }
        if ($period == 'lw') {
            $this->db->where('DATE(dateadded) >= curdate() - INTERVAL DAYOFWEEK(curdate())+6 DAY AND DATE(dateadded) < curdate() - INTERVAL DAYOFWEEK(curdate())-1 DAY ');
        }
        if ($period == 'm') {
            $this->db->where('MONTH(dateadded) = MONTH(CURRENT_DATE()) AND YEAR(dateadded) = YEAR(CURRENT_DATE())  ');
        }
        if ($period == 'lm') {
            $this->db->where('MONTH(dateadded) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH) AND YEAR(dateadded) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH) ');
        }
        if ($period == 'yr') {
            $this->db->where('YEAR(dateadded) = YEAR(CURRENT_DATE()) ');
        }
        if ($period == 'lyr') {
            $this->db->where('YEAR(dateadded) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) ');
        }
        $data = $this->db->get();
        $result['count'] = $data->result_array();

        return $result;
    }
}
