<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['dashboard']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content" id="app">
        <cfo_strategic></cfo_strategic>
    </div>
    <template id="cfo_strategic">
        <div>
            <?php hooks()->do_action('before_dashboards_content'); ?>
            <div class="row mb20" style="margin-left: 0px;margin-right: 0px;">
                <div class="col-md-12">
                    <div class="" style="background: white;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12 bgbox">
                                        <div class="col-md-9">
                                            <select class="form-control" name="period_filter" id="period_filter"
                                                    v-model="period_filter" @change="filter_on_change($event)">
                                                <option value="30d"><?= _l('filter_period_last_30d'); ?></option>
                                                <option value="t"><?= _l('filter_period_today'); ?></option>
                                                <option value="y"><?= _l('filter_period_yesterday'); ?></option>
                                                <option value="w"><?= _l('filter_period_current_week'); ?></option>
                                                <option value="lw"><?= _l('filter_period_last_week'); ?></option>
                                                <option value="m"><?= _l('filter_period_current_month'); ?></option>
                                                <option value="lm"><?= _l('filter_period_last_month'); ?></option>
                                                <option value="yr"><?= _l('filter_period_current_year'); ?></option>
                                                <option value="lyr"><?= _l('filter_period_last_year'); ?></option>
                                                <option value="p"><?= _l('filter_period_range'); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="#" class="btn btn-primary d-inline" @click.prevent="filter_on_change"><i
                                                        class="fa fa-refresh"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row" v-if=" period_filter == 'p' ">
                                    <div class="col-md-8">
                                        <vue-datepicker @selected-date="updated"></vue-datepicker>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="bgbox">
                                            <button class="btn btn-primary" @click="filter_on_change()"><?= _l('filter_apply'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row p-0 m-0">

                <div class="col-sm-12 col-lg-12 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header">
                            <div class="dashcard__header_title"><?= _l('title_revenue') ?></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="dashcard">
                                        <div class="dashcard__header_normal">
                                            <div class="dashcard__header_title"><?= _l('revenue') ?></div>
                                            <div class="dashcard__header_right_title"><?= _l("target"); ?>:
                                                <span v-text="revenue_target" v-if="has_revenue_goal"></span>
                                                <span v-else-if="!has_revenue_goal">-</span>
                                            </div>
                                        </div>
                                        <div class="dashcard__body">
                                            <div class="dashcard__chart">
                                                <div id="chart__revenue"></div>
                                            </div>
                                            <p class="tx-10 tx-uppercase tx-medium mg-b-0 tx-spacing-1"><?= _l("accomplished"); ?></p>
                                            <h2 class="tx-inverse m-0 p-0 mb20">
                                                <span v-text="revenue_accomplished"></span></h2>

                                            <div class="d-flex justify-content-between tx-12" v-if="has_revenue_goal == false">
                                                <p class="alert alert-info"><?= _l('no_goal_set', admin_url('goals')); ?></p>
                                            </div>
                                            <?php /*<div class="d-flex justify-content-between tx-12" v-if="has_revenue_goal == false">
                                        <div class="mg-r-5">
                                          <form action="" method="">
                                          <div class="input group">
                                            <input type="number" class="form-control form-sm" name="goal" value="" placeholder="Goal" />
                                            <input type="submit" class="btn btn-primary btn-sm" value="Save" />
                                          </div>
                                          </form>
                                        </div>
                                    </div>*/ ?>

                                            <div class="d-flex justify-content-between tx-12" v-else-if="has_revenue_goal == true">
                                                <div class="mg-r-5">
                                                    <span class="square-10 mg-r-5 bg-chart-primary"></span>
                                                    <span v-text="percent_revenue"></span>
                                                </div>

                                                <div class="mg-r-5">
                                                    <span class="square-10 mg-r-5 bg-chart-empty"></span>
                                                    <span v-text="percent_to_target"></span> <?= _l("to_target"); ?>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="dashcard">
                                        <div class="dashcard__header_normal">
                                            <div class="dashcard__header_title"><?= _l('title_income_and_expenses') ?></div>
                                            <div class="dashcard__header_right_title"><?= _l("target"); ?>
                                                <span v-text="income_expenses_ratio_target" v-if="has_inc_vs_exp_ratio_goal"></span>
                                                <span v-else-if="!income_expenses_ratio_target">-</span>
                                            </div>
                                        </div>
                                        <div class="dashcard__body">
                                            <div class="dashcard__chart">
                                                <div id="chart__income_and_expenses"></div>
                                            </div>
                                            <p class="tx-10 tx-uppercase tx-medium mg-b-0 tx-spacing-1"><?= _l("income_vs_expenses"); ?></p>
                                            <h2 class="tx-inverse m-0 p-0 mb20">
                                                <span v-text="income_expenses_ratio"></span></h2>
                                            <div class="d-flex justify-content-between tx-12" v-if="has_inc_vs_exp_ratio_goal == true">
                                                <div class="mg-r-5">
                                                    <span class="square-10 mg-r-5 bg-chart-primary"></span> <?= _l("income"); ?>
                                                    <h5 class="mg-b-0 mg-t-5 tx-bold tx-inverse" v-text="percent_income"></h5>
                                                </div>
                                                <div class="mg-r-5">
                                                    <span class="square-10 mg-r-5 bg-chart-empty"></span> <?= _l("expenses"); ?>
                                                    <h5 class="mg-b-0 mg-t-5 tx-bold tx-inverse" v-text="percent_expenses"></h5>
                                                </div>
                                            </div>

                                            <div class="d-flex justify-content-between tx-12" v-if="has_inc_vs_exp_ratio_goal == false">
                                                <p class="alert alert-info"><?= _l('no_goal_set', admin_url('goals')); ?></p>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="dashcard">
                                        <div class="dashcard__header_normal">
                                            <div class="dashcard__header_title"><?= _l('title_gross_margin') ?></div>
                                            <div class="dashcard__header_right_title"><?= _l("target"); ?>
                                                <span v-text="gross_profit_target" v-if="has_inc_vs_exp_ratio_goal"></span>
                                                <span v-else-if="!has_gross_margin_goal">-</span>
                                            </div>
                                        </div>
                                        <div class="dashcard__body">
                                            <div class="dashcard__chart">
                                                <div id="chart__gross_profit"></div>
                                            </div>
                                            <p class="tx-10 tx-uppercase tx-medium mg-b-0 tx-spacing-1"><?= _l("accomplished_gross_margin"); ?></p>
                                            <h2 class="tx-inverse m-0 p-0 mb20"><span v-text="gross_profit"></span></h2>
                                            <div class="d-flex justify-content-between tx-12" v-if="has_gross_margin_goal == true">
                                                <div class="mg-r-5">
                                                    <span class="square-10 mg-r-5 bg-chart-primary"></span> <?= _l("accomplished"); ?>
                                                    <h5 class="mg-b-0 mg-t-5 tx-bold tx-inverse" v-text="percent_gross_profit_formatted"></h5>
                                                </div>
                                                <div class="mg-r-5">
                                                    <span class="square-10 mg-r-5 bg-chart-empty"></span> <?= _l("to_target"); ?>
                                                    <h5 class="mg-b-0 mg-t-5 tx-bold tx-inverse" v-text="percent_gross_profit_totarget_formatted"></h5>
                                                </div>
                                            </div>

                                            <div class="d-flex justify-content-between tx-12" v-if="has_gross_margin_goal == false">
                                                <p class="alert alert-info"><?= _l('no_goal_set', admin_url('goals')); ?></p>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="dashcard">
                                        <div class="dashcard__header_normal">
                                            <div class="dashcard__header_title"><?= _l('title_addition') ?></div>
                                            <div class="dashcard__header_right_title"><?= _l("target"); ?>
                                                <span v-text="addition_target" v-if="has_addition_goal"></span>
                                                <span v-else-if="!has_addition_goal">-</span>
                                            </div>
                                        </div>
                                        <div class="dashcard__body">
                                            <div class="dashcard__chart">
                                                <div id="chart__ebit"></div>
                                            </div>
                                            <p class="tx-10 tx-uppercase tx-medium mg-b-0 tx-spacing-1"><?= _l("accomplished_addition_percent"); ?></p>
                                            <h2 class="tx-inverse m-0 p-0 mb20"><span v-text="addition_total"></span>
                                            </h2>
                                            <div class="d-flex justify-content-between tx-12" v-if="has_addition_goal == true">
                                                <div class="mg-r-5">
                                                    <span class="square-10 mg-r-5 bg-chart-primary"></span> <?= _l("accomplished"); ?>
                                                    <h5 class="mg-b-0 mg-t-5 tx-bold tx-inverse" v-text="addition_accomplished"></h5>
                                                </div>
                                                <div class="mg-r-5">
                                                    <span class="square-10 mg-r-5 bg-chart-empty"></span> <?= _l("to_target"); ?>
                                                    <h5 class="mg-b-0 mg-t-5 tx-bold tx-inverse" v-text="addition_to_target"></h5>
                                                </div>
                                            </div>

                                            <div class="d-flex justify-content-between tx-12" v-if="has_addition_goal == false">
                                                <p class="alert alert-info"><?= _l('no_goal_set', admin_url('goals')); ?></p>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                            </div>


                        </div>
                    </div>
                </div>

            </div>
            <?php /*
    <div class="row p-0 m-0">
        <div class="col-sm-6 col-lg-6 p-10 m-0">
        <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('Employee satisfaction') ?></div>
                    <div class="dashcard__header_right_title"></div>
                </div>
                <div class="dashcard__body">
                    <span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> POSITIVE</span> Employee satisfaction</p></span>
                    <div class="dashcard__chart"><div id="chart_employee_satisfaction_pie"></div></div>
                    <div class="dashcard__chart"><div id="chart_employee_satisfaction_line"></div></div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-6 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('Customer satisfaction') ?></div>
                    <div class="dashcard__header_right_title"></div>
                </div>
                <div class="dashcard__body">
                    <span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> POSITIVE</span> Customer satisfaction</p></span>
                    <div class="dashcard__chart"><div id="chart_customer_satisfaction_pie"></div></div>
                    <div class="dashcard__chart"><div id="chart_customer_satisfaction_line"></div></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row p-0 m-0">
        <div class="col-sm-12 col-lg-12 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('Breakdowns') ?></div>
                    <div class="dashcard__header_right_title">Costs/Revenue</div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__chart"><div id="chart_breakdown"></div></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row p-0 m-0">
        <div class="col-sm-6 col-lg-4 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('EVA') ?></div>
                    <div class="dashcard__header_right_title">Economic Value Add</div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__widget1">
                        <h4 class="dashcard__widget1_title text-center">$5,322,425</h4>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-sm-6 col-lg-4 p-10 m-0">
        <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('Berry ratio') ?></div>
                    <div class="dashcard__header_right_title"></div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__widget1">
                        <h4 class="dashcard__widget1_title text-center">2:1</h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-4 p-10 m-0">
        <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('Payroll headcount ratio') ?></div>
                    <div class="dashcard__header_right_title"></div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__widget1">
                        <h4 class="dashcard__widget1_title text-center">0.02</h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
    */ ?>
        </div>
    </template>

    <?php show_footer(); ?><?php init_tail(); ?>
    <div>
